/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.performlist.bo.NoticeBO;
import com.tydic.enquiry.api.performlist.bo.QryNoticeReqBO;
import com.tydic.enquiry.api.performlist.bo.QryNoticeRspBO;
import com.tydic.enquiry.api.performlist.service.QryNoticeService;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.po.DIqrPurchaseNoticePO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.performlist.service.QryNoticeService"})
public class QryNoticeServiceImpl
implements QryNoticeService {
    private static final Logger log = LoggerFactory.getLogger(QryNoticeServiceImpl.class);
    @Autowired
    DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;

    @PostMapping(value={"qryNotice"})
    public QryNoticeRspBO qryNotice(@RequestBody QryNoticeReqBO reqBO) {
        log.info("QryNoticeService\u5165\u53c2\u6570\u636e\u4fe1\u606f" + reqBO);
        QryNoticeRspBO rspBO = new QryNoticeRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getBusiType())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            map.put("busiType", reqBO.getBusiType());
            List<DIqrPurchaseNoticePO> dIqrPurchaseNoticePOList = null;
            dIqrPurchaseNoticePOList = "Y".equals(reqBO.getIsPagination()) ? this.dIqrPurchaseNoticeMapper.queryHadRegistForDealForPage(map, (Page<Map<String, Object>>)page) : this.dIqrPurchaseNoticeMapper.queryHadRegistForDealNoPage(map);
            if (CollectionUtils.isNotEmpty(dIqrPurchaseNoticePOList)) {
                ArrayList<NoticeBO> purchaseNoticeBOList = new ArrayList<NoticeBO>();
                for (DIqrPurchaseNoticePO po : dIqrPurchaseNoticePOList) {
                    NoticeBO noticeBO = new NoticeBO();
                    BeanUtils.copyProperties((Object)po, (Object)noticeBO);
                    noticeBO.setPlanUnit(po.getPurchaseId());
                    noticeBO.setPlanUnitName(po.getPurchaseName());
                    noticeBO.setPublishTime(DateUtils.dateToStrLong((Date)po.getPublishTime()));
                    purchaseNoticeBOList.add(noticeBO);
                }
                rspBO.setRows(purchaseNoticeBOList);
                rspBO.setPageNo(page.getPageNo());
            } else {
                rspBO.setPageNo(1);
                rspBO.setRows(Collections.EMPTY_LIST);
            }
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u91c7\u8d2d\u516c\u544a\u5217\u8868\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }
}

