/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quoteFinish;

import com.tydic.enquiry.api.quoteFinish.bo.RecoveryRisunQuoteReqBO;
import com.tydic.enquiry.api.quoteFinish.bo.RecoveryRisunQuoteRspBO;
import com.tydic.enquiry.api.quoteFinish.service.RecoveryRisunQuoteService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.enquiry.vo.QuotationInfoVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quoteFinish.service.RecoveryRisunQuoteService"})
public class RecoveryRisunQuoteServiceImpl
implements RecoveryRisunQuoteService {
    private static final Logger log = LoggerFactory.getLogger(RecoveryRisunQuoteServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;

    @PostMapping(value={"recoveryRisunQuote"})
    public RecoveryRisunQuoteRspBO recoveryRisunQuote(@RequestBody RecoveryRisunQuoteReqBO reqBO) {
        RecoveryRisunQuoteRspBO rspBO = new RecoveryRisunQuoteRspBO();
        List<DIqrInquiryMatePO> iqrInquiryMatePOS = this.dIqrInquiryMateMapper.queryInquiryMateList(Integer.parseInt("2006"), new Date());
        if (!CollectionUtils.isEmpty(iqrInquiryMatePOS)) {
            for (DIqrInquiryMatePO inquiryMatePO : iqrInquiryMatePOS) {
                List<DIqrQuotationItemPO> allQuotationItemList;
                List<DIqrQuotationPO> quoteList;
                List<DIqrQuotationPO> quotationPOS = this.dIqrQuotationMapper.selectByInquiryIdDocStatus(inquiryMatePO.getInquiryId(), "40014");
                if (!CollectionUtils.isEmpty(quotationPOS)) {
                    QuotationInfoVO vo = new QuotationInfoVO();
                    vo.setDocStatus(Integer.parseInt("40014"));
                    vo.setNodeStatus(Integer.parseInt("40014"));
                    ArrayList<Long> quotationIds = new ArrayList<Long>();
                    for (DIqrQuotationPO dIqrQuotationPO : quotationPOS) {
                        quotationIds.add(dIqrQuotationPO.getQuotationId());
                    }
                    vo.setQuotationIds(quotationIds);
                    this.dIqrQuotationMapper.updateByQuotationIds(vo);
                }
                if (!CollectionUtils.isEmpty(quoteList = this.dIqrQuotationMapper.selectByInquiryIdDocStatus(inquiryMatePO.getInquiryId(), "4001"))) {
                    QuotationInfoVO vo = new QuotationInfoVO();
                    vo.setDocStatus(Integer.parseInt("40016"));
                    ArrayList<Long> quotationIds = new ArrayList<Long>();
                    for (Object quotationPO2 : quoteList) {
                        quotationIds.add(((DIqrQuotationPO)quotationPO2).getQuotationId());
                    }
                    vo.setQuotationIds(quotationIds);
                    this.dIqrQuotationMapper.updateByQuotationIds(vo);
                }
                List<DIqrQuotationPO> allQuotationList = this.dIqrQuotationMapper.selectByInquiryId(inquiryMatePO.getInquiryId());
                ArrayList<DIqrQuotationPO> updateQuotationList = new ArrayList<DIqrQuotationPO>();
                ArrayList<DIqrQuotationItemPO> arrayList = new ArrayList<DIqrQuotationItemPO>();
                if (allQuotationList != null && allQuotationList.size() >= 0) {
                    Object quotationPO2;
                    quotationPO2 = allQuotationList.iterator();
                    while (quotationPO2.hasNext()) {
                        DIqrQuotationPO dIqrQuotationPO = (DIqrQuotationPO)quotationPO2.next();
                        if (!StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) continue;
                        Long amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                        DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
                        updateQuotationPO.setQuotationId(dIqrQuotationPO.getQuotationId());
                        updateQuotationPO.setAmountSec("");
                        updateQuotationPO.setAmount(amount);
                        updateQuotationList.add(updateQuotationPO);
                    }
                }
                if ((allQuotationItemList = this.dIqrQuotationItemMapper.selectByInquiryId(inquiryMatePO.getInquiryId())) != null && allQuotationItemList.size() >= 0) {
                    for (DIqrQuotationItemPO dIqrQuotationItemPO : allQuotationItemList) {
                        if (StringUtils.isEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec()) && StringUtils.isEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) continue;
                        DIqrQuotationItemPO updateQuotationItemPO = new DIqrQuotationItemPO();
                        updateQuotationItemPO.setQuotationItemId(dIqrQuotationItemPO.getQuotationItemId());
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                            Long quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                            updateQuotationItemPO.setQuoteAmountSec("");
                            updateQuotationItemPO.setQuoteAmount(quoteAmount);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                            Long quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                            updateQuotationItemPO.setQuotePriceSec("");
                            updateQuotationItemPO.setQuotePrice(quotePrice);
                        }
                        arrayList.add(updateQuotationItemPO);
                    }
                }
                if (!CollectionUtils.isEmpty(updateQuotationList)) {
                    this.dIqrQuotationMapper.updatePriceByIdList(updateQuotationList);
                }
                if (CollectionUtils.isEmpty(arrayList)) continue;
                this.dIqrQuotationItemMapper.updatePriceByIdList(arrayList);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

