/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.QryQuotationItemByIdReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationItemByIdRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationItemBO;
import com.tydic.enquiry.api.quote.service.QryQuotationItemByIdService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.quote.service.QryQuotationItemByIdService"})
public class QryQuotationItemByIdServiceImpl
implements QryQuotationItemByIdService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationItemByIdServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;

    @PostMapping(value={"qryQuotationItemById"})
    public QryQuotationItemByIdRspBO qryQuotationItemById(@RequestBody QryQuotationItemByIdReqBO qryQuotationItemByIdReqBO) {
        QryQuotationItemByIdRspBO rspBO = new QryQuotationItemByIdRspBO();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(qryQuotationItemByIdReqBO.getInquiryId());
        if (dIqrInquiryMatePO == null) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPO qryQuotationPO = new DIqrQuotationPO();
        qryQuotationPO.setInquiryId(qryQuotationItemByIdReqBO.getInquiryId());
        qryQuotationPO.setHisStatus("1");
        qryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        qryQuotationPO.setSupplierId(qryQuotationItemByIdReqBO.getSupplierId());
        List<DIqrQuotationPO> quotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryQuotationPO);
        if (quotationPOs == null || quotationPOs.size() <= 0) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPO quotationPO = quotationPOs.get(0);
        List<DIqrQuotationItemPO> dIqrQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationId(quotationPO.getQuotationId());
        BeanUtils.copyProperties((Object)quotationPO, (Object)rspBO);
        try {
            Long amount = quotationPO.getAmount();
            if (StringUtils.isNotEmpty((CharSequence)quotationPO.getAmountSec())) {
                amount = QuoteUtil.decode(quotationPO.getAmountSec(), quotationPO.getQuotationId().toString());
            }
            rspBO.setAmount(MoneyUtils.Long2BigDecimal((Long)amount));
        }
        catch (Exception e) {
            log.error("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
        }
        if (dIqrInquiryMatePO.getLimitBargainNum() != null && StringUtils.isNotBlank((CharSequence)quotationPO.getQuoteRounds())) {
            rspBO.setSurplusQuotationTimes(Integer.valueOf(dIqrInquiryMatePO.getLimitBargainNum() - Integer.valueOf(quotationPO.getQuoteRounds())));
        }
        rspBO.setQuotationSubmitTime(DateUtils.dateToStr((Date)quotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        ArrayList<QuotationItemBO> quotationItemInfoList = new ArrayList<QuotationItemBO>();
        for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOList) {
            QuotationItemBO quotationItemBO = new QuotationItemBO();
            BeanUtils.copyProperties((Object)dIqrQuotationItemPO, (Object)quotationItemBO);
            try {
                Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                Long quoteAmount = dIqrQuotationItemPO.getQuoteAmount();
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                    quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                }
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                    quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                }
                quotationItemBO.setPurchaseNum(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum()));
                quotationItemBO.setQuotePrice(MoneyUtils.Long2BigDecimal((Long)quotePrice));
                quotationItemBO.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quoteAmount));
            }
            catch (Exception e) {
                log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
            }
            quotationItemBO.setSupplierId(quotationPO.getSupplierId());
            quotationItemBO.setSupplierName(quotationPO.getSupplierName());
            quotationItemBO.setQuoteRounds(quotationPO.getQuoteRounds());
            quotationItemBO.setQuotationCode(quotationPO.getQuotationCode());
            quotationItemInfoList.add(quotationItemBO);
        }
        rspBO.setQuotationItemInfoList(quotationItemInfoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u62a5\u4ef7\u4fe1\u606f\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

