/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.dealNotice;

import com.tydic.enquiry.api.dealNotice.bo.PublishConfirmNoticeReqBO;
import com.tydic.enquiry.api.dealNotice.bo.PublishConfirmNoticeRspBO;
import com.tydic.enquiry.api.dealNotice.service.PublishConfirmNoticeService;
import com.tydic.enquiry.api.quote.bo.QryBidQuotationByInquiryIdReqBO;
import com.tydic.enquiry.api.quote.bo.QryBidQuotationByInquiryIdRspBO;
import com.tydic.enquiry.api.quote.service.QryBidQuotationByInquiryIdService;
import com.tydic.enquiry.api.registdoc.bo.UpMarginPayStatusReqBO;
import com.tydic.enquiry.api.registdoc.service.UpMarginPayStatusService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.dao.DIqrConfirmNoticeMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.DIqrConfirmNoticePO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.dealNotice.service.PublishConfirmNoticeService"})
public class PublishConfirmNoticeServiceImpl
implements PublishConfirmNoticeService {
    private static final Logger log = LoggerFactory.getLogger(PublishConfirmNoticeServiceImpl.class);
    @Autowired
    UpMarginPayStatusService upMarginPayStatusService;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    DIqrConfirmNoticeMapper dIqrConfirmNoticeMapper;
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    QryBidQuotationByInquiryIdService qryBidQuotationByInquiryIdService;
    @Autowired
    SeqIdCreateService seqIdCreateService;

    @PostMapping(value={"publishConfirmNotice"})
    public PublishConfirmNoticeRspBO publishConfirmNotice(@RequestBody PublishConfirmNoticeReqBO reqBO) {
        log.info("PublishConfirmNoticeService\u5165\u53c2" + reqBO);
        PublishConfirmNoticeRspBO respBo = new PublishConfirmNoticeRspBO();
        if (null != reqBO.getInquiryId()) {
            respBo.setRespCode("9999");
            respBo.setRespDesc("\u7ade\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return respBo;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getNoticeContent())) {
            respBo.setRespCode("9999");
            respBo.setRespDesc("\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
            return respBo;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getNoticeContent())) {
            respBo.setRespCode("9999");
            respBo.setRespDesc("\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
            return respBo;
        }
        try {
            DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(reqBO.getInquiryId());
            if (null != dIqrInquiryMatePO) {
                DIqrConfirmNoticePO dIqrConfirmNoticePO = this.dIqrConfirmNoticeMapper.selectByInquiryId(dIqrInquiryMatePO.getInquiryId());
                if (null != dIqrConfirmNoticePO) {
                    respBo.setRespCode("9999");
                    respBo.setRespDesc("\u6267\u884c\u5355\u5df2\u53d1\u5e03\uff0c\u65e0\u9700\u518d\u53d1\u5e03");
                    return respBo;
                }
                DIqrConfirmNoticePO record = new DIqrConfirmNoticePO();
                BeanUtils.copyProperties((Object)dIqrInquiryMatePO, (Object)record);
                record.setNoticeContent(HtmlUtils.htmlEscapeHex((String)reqBO.getNoticeContent()));
                record.setPublishTime(new Date());
                record.setCreateUserId(reqBO.getOperId());
                record.setCreateUserName(reqBO.getOperName());
                record.setPurchaseMethod(reqBO.getPurchaseMethod());
                SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("RISUN01");
                seqEnquiryReqBO.setSeqType("99");
                record.setNoticeId(this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId());
                int i = this.dIqrConfirmNoticeMapper.insertSelective(record);
                if (i > 0) {
                    QryBidQuotationByInquiryIdReqBO qryBidQuotationByInquiryIdReqBO = new QryBidQuotationByInquiryIdReqBO();
                    qryBidQuotationByInquiryIdReqBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                    QryBidQuotationByInquiryIdRspBO qryBidQuotationByInquiryIdRspBO = this.qryBidQuotationByInquiryIdService.qryBidQuotationByInquiryId(qryBidQuotationByInquiryIdReqBO);
                    if (null != qryBidQuotationByInquiryIdRspBO && "0000".equals(qryBidQuotationByInquiryIdRspBO.getRespCode())) {
                        List<DIqrRegistDocPO> dIqrRegistDocList = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(reqBO.getInquiryId());
                        if (CollectionUtils.isNotEmpty(dIqrRegistDocList)) {
                            for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocList) {
                                if (!dIqrRegistDocPO.getSupplierId().equals(qryBidQuotationByInquiryIdRspBO.getSupplierId())) continue;
                                UpMarginPayStatusReqBO upMarginPayStatusReqBO = new UpMarginPayStatusReqBO();
                                upMarginPayStatusReqBO.setRegistId(dIqrRegistDocPO.getRegistId());
                                upMarginPayStatusReqBO.setSupplierId(dIqrRegistDocPO.getSupplierId());
                                upMarginPayStatusReqBO.setPayFlag("3");
                                this.upMarginPayStatusService.upMarginPayStatus(upMarginPayStatusReqBO);
                            }
                        }
                    } else {
                        respBo.setRespCode("9999");
                        respBo.setRespDesc("\u83b7\u53d6\u6210\u4ea4\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38\uff01");
                    }
                }
            } else {
                respBo.setRespCode("9999");
                respBo.setRespDesc("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u6267\u884c\u5355\u4fe1\u606f");
            }
            log.info("PublishConfirmNoticeService\u51fa\u53c2" + respBo);
            return respBo;
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u6210\u4ea4\u7ed3\u679c\u516c\u544a\u5f02\u5e38", (Throwable)e);
            throw new EnqBusinessException("9999", "\u53d1\u5e03\u6210\u4ea4\u7ed3\u679c\u516c\u544a\u5f02\u5e38!");
        }
    }
}

