/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.statistic;

import com.tydic.enquiry.api.statistic.bo.QryToDoInfo;
import com.tydic.enquiry.api.statistic.bo.QryToDoReqBO;
import com.tydic.enquiry.api.statistic.bo.QryToDoRspBO;
import com.tydic.enquiry.api.statistic.service.QryToDoService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP/1.0.0/com.tydic.enquiry.api.statistic.service.QryToDoService"})
public class QryToDoServiceImpl
implements QryToDoService {
    private static final Logger log = LoggerFactory.getLogger(QryToDoServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    @PostMapping(value={"countToDoList"})
    public QryToDoRspBO countToDoList(@RequestBody QryToDoReqBO reqBO) {
        QryToDoRspBO rspBO = new QryToDoRspBO();
        log.info("QryToDoService\u5165\u53c2:" + reqBO);
        if (CollectionUtils.isEmpty((Collection)reqBO.getBtnCodeList())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6309\u94ae\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        List btnCodeList = reqBO.getBtnCodeList();
        ArrayList<QryToDoInfo> qryToDoInfoRspList = new ArrayList<QryToDoInfo>(btnCodeList.size());
        for (String s : btnCodeList) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("operId", reqBO.getUserId());
            map.put("busiType", "RS1");
            map.put("supplierId", reqBO.getUserId());
            if ("biddingToSubmit".equals(s)) {
                map.put("docStatus", "2001");
                this.getCountRsp(map, qryToDoInfoRspList, s, 25, "\u5f85\u63d0\u4ea4", Boolean.TRUE);
                continue;
            }
            if ("biddingToNotice".equals(s)) {
                map.put("docStatus", "2004");
                this.getCountRsp(map, qryToDoInfoRspList, s, 26, "\u5f85\u53d1\u5e03\u7ade\u4ef7\u516c\u544a", Boolean.TRUE);
                continue;
            }
            if ("biddingToSureBond".equals(s)) {
                map.put("docStatus", "2004");
                this.getCountRsp(map, qryToDoInfoRspList, s, 27, "\u5f85\u786e\u8ba4\u4fdd\u8bc1\u91d1", Boolean.TRUE);
                continue;
            }
            if ("biddingToSureResult".equals(s)) {
                map.put("docStatus", "2007");
                this.getCountRsp(map, qryToDoInfoRspList, s, 28, "\u5f85\u786e\u8ba4\u7ade\u4ef7\u7ed3\u679c", Boolean.TRUE);
                continue;
            }
            if ("biddingToReturnBond".equals(s)) {
                map.put("docStatus", "2009");
                this.getCountRsp(map, qryToDoInfoRspList, s, 29, "\u5f85\u9000\u8fd8\u4fdd\u8bc1\u91d1", Boolean.TRUE);
                continue;
            }
            if ("biddingToResultPublicity".equals(s)) {
                map.put("docStatus", "2009");
                this.getCountRsp(map, qryToDoInfoRspList, s, 30, "\u5f85\u53d1\u5e03\u7ed3\u679c\u516c\u544a", Boolean.TRUE);
                continue;
            }
            if ("biddingToSignup".equals(s)) {
                map.put("docStatus", "3001");
                this.getCountRsp(map, qryToDoInfoRspList, s, 31, "\u5f85\u62a5\u540d", Boolean.FALSE);
                continue;
            }
            if (!"biddingToBid".equals(s)) continue;
            map.put("docStatus", "3006");
            this.getCountRsp(map, qryToDoInfoRspList, s, 32, "\u5f85\u7ade\u4ef7", Boolean.FALSE);
        }
        rspBO.setQryToDoInfo(qryToDoInfoRspList);
        log.info("QryToDoService\u51fa\u53c2:" + rspBO);
        return rspBO;
    }

    private void getCountRsp(Map<String, Object> map, List<QryToDoInfo> qryToDoInfoRspList, String buttonCode, Integer moduleType, String moduleTypeStr, Boolean inquiry) {
        int i = inquiry != false ? this.dIqrInquiryMateMapper.countInquiryMate(map) : this.dIqrRegistDocMapper.countRegist(map);
        QryToDoInfo qryToDoInfo = new QryToDoInfo();
        qryToDoInfo.setButtonCode(buttonCode);
        qryToDoInfo.setModuleType(moduleType);
        qryToDoInfo.setModuleTypeStr(moduleTypeStr);
        qryToDoInfo.setTabsCount(Integer.valueOf(i));
        qryToDoInfoRspList.add(qryToDoInfo);
    }
}

