/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryInquiryAllQuotationBillItemReqBO;
import com.tydic.enquiry.api.quote.bo.QryInquiryAllQuotationBillItemRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationInquiryDetailBO;
import com.tydic.enquiry.api.quote.bo.QuotationItemBO;
import com.tydic.enquiry.api.quote.bo.QuotationSupplierInfoBO;
import com.tydic.enquiry.api.quote.service.QryInquiryAllQuotationBillItemService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryInquiryAllQuotationBillItemService.class)
public class QryInquiryAllQuotationBillItemServiceImpl
implements QryInquiryAllQuotationBillItemService {
    private static final Logger log = LoggerFactory.getLogger(QryInquiryAllQuotationBillItemServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    public QryInquiryAllQuotationBillItemRspBO qryInquiryAllQuotationBillItem(QryInquiryAllQuotationBillItemReqBO reqBO) {
        QryInquiryAllQuotationBillItemRspBO rspBO = new QryInquiryAllQuotationBillItemRspBO();
        List<Object> detailList = new ArrayList();
        List<DIqrInquiryDetailPO> dIqrInquiryDetailPOList = this.dIqrInquiryDetailMapper.selectByInquiryId(reqBO.getInquiryId());
        if (CollectionUtils.isEmpty(dIqrInquiryDetailPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u5bf9\u5e94\u7684\u5206\u5305\u6682\u65e0\u62a5\u4ef7");
            rspBO.setDetailList(detailList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        detailList = dIqrInquiryDetailPOList.stream().map(e -> {
            QuotationInquiryDetailBO quoteInquiryDatailBO = new QuotationInquiryDetailBO();
            BeanUtils.copyProperties((Object)e, (Object)quoteInquiryDatailBO);
            try {
                quoteInquiryDatailBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)e.getBudgetPrice()));
                quoteInquiryDatailBO.setGoodsNumber(MoneyUtils.Long2BigDecimal((Long)e.getGoodsNumber()));
                quoteInquiryDatailBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)e.getBudgetAmount()));
            }
            catch (Exception e1) {
                log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e1.getStackTrace());
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
            }
            quoteInquiryDatailBO.setMaterialClassName(this.qryDicAtomService.getDicCodeName("MATERIAL_CLASS_ID", e.getMaterialClassId() + ""));
            return quoteInquiryDatailBO;
        }).collect(Collectors.toList());
        DIqrQuotationPO quotationPO = new DIqrQuotationPO();
        DIqrQuotationPO record = new DIqrQuotationPO();
        ArrayList<String> hisStatusList = new ArrayList<String>();
        hisStatusList.add("1");
        hisStatusList.add("2");
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("4002"));
        docStatusList.add(Integer.valueOf("4004"));
        docStatusList.add(Integer.valueOf("4006"));
        quotationPO.setInquiryId(reqBO.getInquiryId());
        quotationPO.setValidStatus(Constants.IS_VALID_Y);
        quotationPO.setHisStatus("1");
        quotationPO.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> effectiveQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(quotationPO);
        if (CollectionUtils.isEmpty(effectiveQuotationPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setDetailList(detailList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        HashMap<Long, DIqrQuotationPO> effectiveQuotationPOMap = new HashMap<Long, DIqrQuotationPO>();
        ArrayList<Long> effectiveQuotationId = new ArrayList<Long>();
        for (DIqrQuotationPO dIqrQuotationPO : effectiveQuotationPOList) {
            effectiveQuotationPOMap.put(dIqrQuotationPO.getQuotationId(), dIqrQuotationPO);
            effectiveQuotationId.add(dIqrQuotationPO.getQuotationId());
        }
        record.setInquiryId(reqBO.getInquiryId());
        record.setHisStatusList(hisStatusList);
        record.setValidStatus(Constants.IS_VALID_Y);
        record.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> dIqrQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
        if (CollectionUtils.isEmpty(dIqrQuotationPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setDetailList(detailList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationItemPO effectiveQuotationItemPO = new DIqrQuotationItemPO();
        effectiveQuotationItemPO.setQuotationIds(effectiveQuotationId);
        List<DIqrQuotationItemPO> effectiveQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationItem(effectiveQuotationItemPO);
        HashMap<Long, Object> quotationItemPriceMap = new HashMap<Long, Object>();
        HashMap<Long, Integer> quotationItemCountMap = new HashMap<Long, Integer>();
        for (DIqrQuotationItemPO dIqrQuotationItemPO : effectiveQuotationItemPOList) {
            Object quotePrice = dIqrQuotationItemPO.getQuotePrice();
            if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
            }
            if (quotationItemPriceMap.size() <= 0 || quotationItemPriceMap.get(dIqrQuotationItemPO.getInquiryItemId()) == null) {
                quotationItemPriceMap.put(dIqrQuotationItemPO.getInquiryItemId(), quotePrice);
                quotationItemCountMap.put(dIqrQuotationItemPO.getInquiryItemId(), 1);
                continue;
            }
            Long itemQuoteAmount = (Long)quotationItemPriceMap.get(dIqrQuotationItemPO.getInquiryItemId()) + (Long)quotePrice;
            Integer itemQuoteCount = (Integer)quotationItemCountMap.get(dIqrQuotationItemPO.getInquiryItemId()) + 1;
            quotationItemPriceMap.put(dIqrQuotationItemPO.getInquiryItemId(), itemQuoteAmount);
            quotationItemCountMap.put(dIqrQuotationItemPO.getInquiryItemId(), itemQuoteCount);
        }
        ArrayList<Long> quotationIds = new ArrayList<Long>();
        HashMap<Long, DIqrQuotationPO> dIqrQuotationPOMap = new HashMap<Long, DIqrQuotationPO>();
        for (DIqrQuotationPO dIqrQuotationPO : dIqrQuotationPOList) {
            quotationIds.add(dIqrQuotationPO.getQuotationId());
            dIqrQuotationPOMap.put(dIqrQuotationPO.getQuotationId(), dIqrQuotationPO);
        }
        DIqrQuotationItemPO quotationItemPO = new DIqrQuotationItemPO();
        quotationItemPO.setQuotationIds(quotationIds);
        List<DIqrQuotationItemPO> dIqrQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationItem(quotationItemPO);
        detailList = detailList.stream().map(e -> {
            ArrayList<QuotationItemBO> quotationItemBOList = new ArrayList<QuotationItemBO>();
            ArrayList<QuotationSupplierInfoBO> quotationSupplierInfoList = new ArrayList<QuotationSupplierInfoBO>();
            HashSet<Long> itemQuotationIds = new HashSet<Long>();
            Long itemAllQuotePrice = 0L;
            Integer itemAllQuoteCount = 0;
            BigDecimal averagePrice = new BigDecimal("0");
            if (quotationItemPriceMap.get(e.getInquiryItemId()) != null) {
                itemAllQuotePrice = (Long)quotationItemPriceMap.get(e.getInquiryItemId());
                itemAllQuoteCount = (Integer)quotationItemCountMap.get(e.getInquiryItemId());
                try {
                    averagePrice = MoneyUtils.Long2BigDecimal((Long)itemAllQuotePrice).divide(new BigDecimal(itemAllQuoteCount)).setScale(2, 4);
                }
                catch (Exception e2) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e2.getStackTrace());
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
            }
            int higherAaverageAmountNumber = 0;
            int lowerAaverageAmountNumber = 0;
            for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOList) {
                if (dIqrQuotationItemPO.getInquiryItemId().longValue() != e.getInquiryItemId().longValue()) continue;
                QuotationItemBO quotationItemBO = new QuotationItemBO();
                BeanUtils.copyProperties((Object)dIqrQuotationItemPO, (Object)quotationItemBO);
                try {
                    Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                    Long quoteAmount = dIqrQuotationItemPO.getQuoteAmount();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                        quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                        quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    quotationItemBO.setQuotePrice(MoneyUtils.Long2BigDecimal((Long)quotePrice));
                    quotationItemBO.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quoteAmount));
                }
                catch (Exception e1) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e1.getStackTrace());
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                if (quotationItemBO.getQuotePrice().compareTo(averagePrice) <= 0) {
                    ++lowerAaverageAmountNumber;
                } else {
                    ++higherAaverageAmountNumber;
                }
                if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null && ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationSubmitTime() != null) {
                    quotationItemBO.setQuotationSubmitTime(DateUtils.dateToStr((Date)((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null && ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDeliveryDatePromise() != null) {
                    quotationItemBO.setDeliveryDatePromise(DateUtils.dateToStr((Date)((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null) {
                    quotationItemBO.setDocStatus(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDocStatus());
                    quotationItemBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDocStatus() + ""));
                }
                if (effectiveQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null) {
                    QuotationSupplierInfoBO quotationSupplierInfo = new QuotationSupplierInfoBO();
                    quotationSupplierInfo.setInquiryId(((DIqrQuotationPO)effectiveQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getInquiryId());
                    quotationSupplierInfo.setQuotationId(((DIqrQuotationPO)effectiveQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationId());
                    quotationSupplierInfo.setQuoteRounds(((DIqrQuotationPO)effectiveQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuoteRounds());
                    quotationSupplierInfo.setSupplierId(((DIqrQuotationPO)effectiveQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getSupplierId());
                    quotationSupplierInfo.setSupplierName(((DIqrQuotationPO)effectiveQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getSupplierName());
                    quotationSupplierInfo.setQuotationItemId(dIqrQuotationItemPO.getQuotationItemId());
                    quotationSupplierInfo.setInquiryItemId(e.getInquiryItemId());
                    quotationSupplierInfo.setInquiryPkgId(e.getInquiryPkgId());
                    quotationSupplierInfo.setPlanItemId(e.getPlanItemId());
                    quotationSupplierInfoList.add(quotationSupplierInfo);
                }
                quotationItemBOList.add(quotationItemBO);
                itemQuotationIds.add(quotationItemBO.getQuotationId());
            }
            e.setAverageAmount(averagePrice);
            e.setHigherAaverageAmountNumber(Integer.valueOf(higherAaverageAmountNumber));
            e.setLowerAaverageAmountNumber(Integer.valueOf(lowerAaverageAmountNumber));
            e.setQuotationSupplierInfoList(quotationSupplierInfoList);
            e.setQuotationInfoList(quotationItemBOList);
            return e;
        }).collect(Collectors.toList());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u67e5\u8be2\u62a5\u4ef7\u4fe1\u606f\u6210\u529f");
        rspBO.setDetailList(detailList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

