/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quoteFinish;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.quoteFinish.bo.InquirySupInfo;
import com.tydic.enquiry.api.quoteFinish.bo.QrySupListByItemIdReqBO;
import com.tydic.enquiry.api.quoteFinish.bo.QrySupListByItemIdRspBO;
import com.tydic.enquiry.api.quoteFinish.service.QrySupListByItemIdService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.vo.DIqrQuotationVO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QrySupListByItemIdService.class)
public class QrySupListByItemIdServiceImpl
implements QrySupListByItemIdService {
    private static final Logger log = LoggerFactory.getLogger(QrySupListByItemIdServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;

    public QrySupListByItemIdRspBO qrySupListByItemId(QrySupListByItemIdReqBO reqBO) {
        QrySupListByItemIdRspBO rspBO = new QrySupListByItemIdRspBO();
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        List<Object> supInfoList = new ArrayList();
        DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
        if (inquiryMatePO == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        List<DIqrQuotationVO> quotationPOS = this.dIqrQuotationMapper.selectByInquiryItemIds(reqBO.getInquiryItemId());
        if (!CollectionUtils.isEmpty(quotationPOS)) {
            supInfoList = quotationPOS.stream().map(e -> {
                InquirySupInfo supInfo = new InquirySupInfo();
                supInfo.setSupplierId(e.getSupplierId().toString());
                supInfo.setSupplierName(e.getSupplierName());
                supInfo.setQuotationItemId(e.getQuotationItemId().toString());
                supInfo.setInquiryItemId(e.getInquiryItemId().toString());
                supInfo.setInquiryPkgId(e.getInquiryPkgId());
                return supInfo;
            }).collect(Collectors.toList());
            rspBO.setSupInfoList(supInfoList);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

