/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.requirement;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.demandlist.bo.AttachmentBO;
import com.tydic.enquiry.api.demandlist.bo.OtherInfoBO;
import com.tydic.enquiry.api.demandlist.bo.PlanDetailBO;
import com.tydic.enquiry.api.demandlist.bo.PurchaseInfoBO;
import com.tydic.enquiry.api.demandlist.bo.SettleInfoBO;
import com.tydic.enquiry.api.demandlist.bo.SupplierInfoBO;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.requirement.bo.BaseInfoBO;
import com.tydic.enquiry.api.requirement.bo.RequireOrderDetailReqBO;
import com.tydic.enquiry.api.requirement.bo.RequireOrderDetailRspBO;
import com.tydic.enquiry.api.requirement.service.QryRequireOrderDetailService;
import com.tydic.enquiry.dao.DPlanItemMaterialMapper;
import com.tydic.enquiry.dao.DPlanMaterialMapper;
import com.tydic.enquiry.dao.RPlanAttachmentInfoMapper;
import com.tydic.enquiry.dao.RPlanSupplierRelMapper;
import com.tydic.enquiry.po.DPlanMaterialPO;
import com.tydic.enquiry.po.RPlanAttachmentInfoPO;
import com.tydic.enquiry.po.RPlanSupplierRelPO;
import com.tydic.enquiry.util.RedisUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryRequireOrderDetailService.class)
public class QryRequireOrderDetailServiceImpl
implements QryRequireOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(QryRequireOrderDetailServiceImpl.class);
    @Autowired
    private DPlanMaterialMapper dPlanMaterialMapper;
    @Autowired
    private DPlanItemMaterialMapper dPlanItemMaterialMapper;
    @Autowired
    private RPlanAttachmentInfoMapper rPlanAttachmentInfoMapper;
    @Autowired
    private RPlanSupplierRelMapper rPlanSupplierRelMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    private RedisUtils redisUtils;

    public RequireOrderDetailRspBO qryRequireOrderDetail(RequireOrderDetailReqBO requireOrderDetailReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1arequireOrderDetailReqBO=" + requireOrderDetailReqBO.toString());
        RequireOrderDetailRspBO requireOrderDetailRspBO = new RequireOrderDetailRspBO();
        DPlanMaterialPO dPlanMaterialPO = this.dPlanMaterialMapper.selectByPrimaryKey(requireOrderDetailReqBO.getPlanId());
        List<RPlanAttachmentInfoPO> attchmentList = this.rPlanAttachmentInfoMapper.selectAttachByPlanId(requireOrderDetailReqBO.getPlanId());
        List<RPlanSupplierRelPO> supplierList = this.rPlanSupplierRelMapper.selectSupplierByPlanId(requireOrderDetailReqBO.getPlanId());
        List<Object> itemMaterialPOList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)requireOrderDetailReqBO.getDetailList())) {
            ArrayList<Long> itemIds = new ArrayList<Long>();
            for (PlanDetailBO planDetailBO : requireOrderDetailReqBO.getDetailList()) {
                itemIds.add(planDetailBO.getPlanItemId());
            }
            log.info("\u67e5\u8be2\u5165\u53c2:itemIds=" + ((Object)itemIds).toString());
            itemMaterialPOList = this.dPlanItemMaterialMapper.selectItemMaterialByItemIds(itemIds);
        } else {
            itemMaterialPOList = this.dPlanItemMaterialMapper.selectItemMaterialByPlanId(requireOrderDetailReqBO.getPlanId());
        }
        BaseInfoBO baseInfoBO = new BaseInfoBO();
        baseInfoBO.setPlanId(dPlanMaterialPO.getPlanId());
        baseInfoBO.setCreateDate(DateUtils.dateToStr((Date)dPlanMaterialPO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        baseInfoBO.setOperId(dPlanMaterialPO.getCreateUserId());
        baseInfoBO.setOperName(dPlanMaterialPO.getCreateUserName());
        baseInfoBO.setPlanCode(dPlanMaterialPO.getPlanCode());
        baseInfoBO.setPlanDepart(dPlanMaterialPO.getPurchaseProfessionalOrgId());
        baseInfoBO.setPlanName(dPlanMaterialPO.getPlanName());
        baseInfoBO.setPlanUnit(dPlanMaterialPO.getPurchaseId());
        baseInfoBO.setPlanUnitName(dPlanMaterialPO.getPurchaseName());
        baseInfoBO.setPlanDepartName(dPlanMaterialPO.getPlanDepartName());
        requireOrderDetailRspBO.setBaseInfo(baseInfoBO);
        PurchaseInfoBO purchaseInfoBO = new PurchaseInfoBO();
        purchaseInfoBO.setPurchaseAccount(dPlanMaterialPO.getPurchaseAccount());
        purchaseInfoBO.setPurchaseAccountName(dPlanMaterialPO.getPurchaseAccountName());
        purchaseInfoBO.setPurchaseCategory(dPlanMaterialPO.getPurchaseCategory());
        purchaseInfoBO.setPurchaseCategoryName(this.qryDicAtomService.getDicCodeName("PURCHASE_CATEGORY", dPlanMaterialPO.getPurchaseCategory() + ""));
        purchaseInfoBO.setDeliveryDateMethod(dPlanMaterialPO.getDeliveryDateMethod());
        purchaseInfoBO.setDeliveryDateMethodName(this.qryDicAtomService.getDicCodeName("DELIVERY_DATE_METHOD", dPlanMaterialPO.getDeliveryDateMethod() + ""));
        purchaseInfoBO.setReqArrivalDate(DateUtils.dateToStr((Date)dPlanMaterialPO.getReqArrivalDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        purchaseInfoBO.setReqArrivalTimeInt(dPlanMaterialPO.getReqArrivalTimeInt());
        purchaseInfoBO.setDeliveryAddr(dPlanMaterialPO.getDeliveryAddr());
        purchaseInfoBO.setPurchaseMethod(dPlanMaterialPO.getPurchaseMethod());
        purchaseInfoBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", dPlanMaterialPO.getPurchaseMethod() + ""));
        if (CollectionUtils.isNotEmpty(supplierList)) {
            List supplierInfoBOList = supplierList.stream().map(e -> {
                SupplierInfoBO supplierInfoBO = new SupplierInfoBO();
                BeanUtils.copyProperties((Object)e, (Object)supplierInfoBO);
                return supplierInfoBO;
            }).collect(Collectors.toList());
            purchaseInfoBO.setSupplierTendencyList(supplierInfoBOList);
        }
        requireOrderDetailRspBO.setPurchaseInfo(purchaseInfoBO);
        SettleInfoBO settleInfoBO = new SettleInfoBO();
        settleInfoBO.setInvoiceType(dPlanMaterialPO.getInvoiceType());
        settleInfoBO.setInvoiceTypeName(this.qryDicAtomService.getDicCodeName("INVOICE_TYPE", dPlanMaterialPO.getInvoiceType()));
        settleInfoBO.setPayChannel(dPlanMaterialPO.getPayChannel());
        settleInfoBO.setPayChannelName(this.qryDicAtomService.getDicCodeName("PAY_CHANNEL", dPlanMaterialPO.getPayChannel()));
        settleInfoBO.setPayType(dPlanMaterialPO.getPayType());
        settleInfoBO.setInvoiceTypeName(this.qryDicAtomService.getDicCodeName("PAY_TYPE", dPlanMaterialPO.getPayType()));
        log.info("\u53d1\u7968\u62ac\u5934 \uff1a==" + dPlanMaterialPO.getInvoiceTitle());
        settleInfoBO.setInvoiceTitle(dPlanMaterialPO.getInvoiceTitle());
        requireOrderDetailRspBO.setSettleInfo(settleInfoBO);
        OtherInfoBO otherInfoBO = new OtherInfoBO();
        otherInfoBO.setContactMode(dPlanMaterialPO.getContactMode());
        otherInfoBO.setContactName(dPlanMaterialPO.getContactName());
        otherInfoBO.setProjectName(dPlanMaterialPO.getProjectName());
        otherInfoBO.setRemarks(dPlanMaterialPO.getRemarks());
        otherInfoBO.setIsApprove(dPlanMaterialPO.getIsApprove());
        otherInfoBO.setIsApproveName(this.qryDicAtomService.getDicCodeName("IS_APPROVE", dPlanMaterialPO.getIsApprove()));
        requireOrderDetailRspBO.setOtherInfo(otherInfoBO);
        if (CollectionUtils.isNotEmpty(attchmentList)) {
            List attachmentInfoList = attchmentList.stream().map(e -> {
                AttachmentBO attachmentBO = new AttachmentBO();
                BeanUtils.copyProperties((Object)e, (Object)attachmentBO);
                return attachmentBO;
            }).collect(Collectors.toList());
            requireOrderDetailRspBO.setAttachmentInfoList(attachmentInfoList);
        }
        if (CollectionUtils.isNotEmpty(itemMaterialPOList)) {
            List planDetailBOList = itemMaterialPOList.stream().map(e -> {
                PlanDetailBO planDetailBO = new PlanDetailBO();
                BeanUtils.copyProperties((Object)e, (Object)planDetailBO);
                BigDecimal amount = new BigDecimal(10000);
                BigDecimal budgetPriceTemp = new BigDecimal(e.getBudgetPrice());
                log.info("budgetPriceTemp=" + budgetPriceTemp);
                planDetailBO.setBudgetPrice(budgetPriceTemp.divide(amount).setScale(2, RoundingMode.HALF_UP));
                BigDecimal budgetTemp = new BigDecimal(e.getBudgetAmount());
                log.info("budgetTemp=" + budgetTemp);
                planDetailBO.setBudgetAmount(budgetTemp.divide(amount).setScale(2, RoundingMode.HALF_UP));
                BigDecimal requireNumberTemp = new BigDecimal(e.getRequireNumber());
                log.info("requireNumberTemp=" + requireNumberTemp);
                planDetailBO.setRequireNumber(requireNumberTemp.divide(amount).setScale(2, RoundingMode.HALF_UP));
                return planDetailBO;
            }).collect(Collectors.toList());
            requireOrderDetailRspBO.setDetailList(planDetailBOList);
        }
        if ("1001".equals(dPlanMaterialPO.getDocStatus())) {
            for (PlanDetailBO planDetailBO : requireOrderDetailReqBO.getDetailList()) {
                planDetailBO.setOperFlag("0");
            }
        }
        requireOrderDetailRspBO.setRespCode("0000");
        requireOrderDetailRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arequireOrderDetailRspBO=" + requireOrderDetailRspBO.toString());
        return requireOrderDetailRspBO;
    }
}

