/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryQuotationHistoryItemReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationHistoryItemRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationItemBO;
import com.tydic.enquiry.api.quote.service.QryQuotationHistoryItemService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryQuotationHistoryItemService.class)
public class QryQuotationHistoryItemServiceImpl
implements QryQuotationHistoryItemService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationHistoryItemServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    private DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;

    public QryQuotationHistoryItemRspBO qryQuotationHistoryItem(QryQuotationHistoryItemReqBO qryQuotationHistoryItemReqBO) {
        QryQuotationHistoryItemRspBO rspBO = new QryQuotationHistoryItemRspBO();
        DIqrQuotationPO record = new DIqrQuotationPO();
        ArrayList<String> hisStatusList = new ArrayList<String>();
        hisStatusList.add("1");
        hisStatusList.add("2");
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("40014"));
        docStatusList.add(Integer.valueOf("40015"));
        record.setInquiryId(qryQuotationHistoryItemReqBO.getInquiryId());
        record.setBidsectionId(qryQuotationHistoryItemReqBO.getBidsectionId());
        record.setHisStatusList(hisStatusList);
        record.setValidStatus(Constants.IS_VALID_Y);
        record.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> dIqrQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
        if (CollectionUtils.isEmpty(dIqrQuotationPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        ArrayList<Long> quotationIds = new ArrayList<Long>();
        HashMap<Long, DIqrQuotationPO> dIqrQuotationPOMap = new HashMap<Long, DIqrQuotationPO>();
        for (DIqrQuotationPO dIqrQuotationPO : dIqrQuotationPOList) {
            quotationIds.add(dIqrQuotationPO.getQuotationId());
            dIqrQuotationPOMap.put(dIqrQuotationPO.getQuotationId(), dIqrQuotationPO);
        }
        DIqrQuotationItemPO quotationItemPO = new DIqrQuotationItemPO();
        quotationItemPO.setQuotationIds(quotationIds);
        List<DIqrQuotationItemPO> dIqrQuotationItemPOList = this.dIqrQuotationItemMapper.selectQuotaItemOrderBySubmitTime(quotationItemPO);
        ArrayList<QuotationItemBO> quotationItemBOList = new ArrayList<QuotationItemBO>();
        for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOList) {
            QuotationItemBO quotationItemBO = new QuotationItemBO();
            BeanUtils.copyProperties((Object)dIqrQuotationItemPO, (Object)quotationItemBO);
            try {
                Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                Long quoteAmount = dIqrQuotationItemPO.getQuoteAmount();
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                    quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                }
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                    quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                }
                quotationItemBO.setQuotePrice(MoneyUtils.Long2BigDecimal((Long)quotePrice));
                quotationItemBO.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quoteAmount));
            }
            catch (Exception e1) {
                log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e1.getStackTrace());
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
            }
            if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null && ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationSubmitTime() != null) {
                quotationItemBO.setQuotationSubmitTime(DateUtils.dateToStr((Date)((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null && ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDeliveryDatePromise() != null) {
                quotationItemBO.setDeliveryDatePromise(DateUtils.dateToStr((Date)((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId()) != null) {
                quotationItemBO.setDocStatus(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDocStatus());
                quotationItemBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", ((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getDocStatus() + ""));
                quotationItemBO.setSupplierId(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getSupplierId());
                quotationItemBO.setSupplierName(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getSupplierName());
                quotationItemBO.setQuotationCode(((DIqrQuotationPO)dIqrQuotationPOMap.get(dIqrQuotationItemPO.getQuotationId())).getQuotationCode());
            }
            quotationItemBOList.add(quotationItemBO);
        }
        DIqrInquiryBidsectionPO bidsectionPO = this.dIqrInquiryBidsectionMapper.selectByPrimaryKey(qryQuotationHistoryItemReqBO.getBidsectionId());
        rspBO.setMaterialName(bidsectionPO.getMaterialName());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u67e5\u8be2\u62a5\u4ef7\u4fe1\u606f\u6210\u529f");
        rspBO.setRows(quotationItemBOList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

