/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.requirement;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.requirement.bo.QryRequireOrderReqBO;
import com.tydic.enquiry.api.requirement.bo.QryRequireOrderRspBO;
import com.tydic.enquiry.api.requirement.bo.RequireOrderInfoBO;
import com.tydic.enquiry.api.requirement.service.QryRequireOrderInfoService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DPlanMaterialMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DPlanMaterialPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryRequireOrderInfoService.class)
public class QryRequireOrderInfoServiceImpl
implements QryRequireOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(QryRequireOrderInfoServiceImpl.class);
    @Autowired
    DPlanMaterialMapper dPlanMaterialMapper;
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    public QryRequireOrderRspBO qryRequireOrder(QryRequireOrderReqBO qryRequireOrderReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryRequireOrderReqBO=" + qryRequireOrderReqBO.toString());
        Page page = new Page(qryRequireOrderReqBO.getPageNo(), qryRequireOrderReqBO.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        QryRequireOrderRspBO qryRequireOrderRspBO = new QryRequireOrderRspBO();
        Long beginBudget = null;
        Long endBudget = null;
        if (qryRequireOrderReqBO.getBeginBudgetAmount() != null && qryRequireOrderReqBO.getEndBudgetAmount() != null) {
            beginBudget = qryRequireOrderReqBO.getBeginBudgetAmount().multiply(BigDecimal.valueOf(10000L)).longValue();
            log.info("beginBudget=" + beginBudget);
            endBudget = qryRequireOrderReqBO.getEndBudgetAmount().multiply(BigDecimal.valueOf(10000L)).longValue();
            log.info("endBudget=" + endBudget);
        }
        Date createDateTemp = null;
        Date planApproveDateTemp = null;
        if (qryRequireOrderReqBO.getCreateDate() != null && qryRequireOrderReqBO.getPlanApproveDate() != null) {
            createDateTemp = DateUtils.strToDate((String)qryRequireOrderReqBO.getCreateDate(), (String)"yyyyMMddHHmmss");
            log.info("createDateTemp=" + createDateTemp);
            planApproveDateTemp = DateUtils.strToDate((String)qryRequireOrderReqBO.getCreateDate(), (String)"yyyyMMddHHmmss");
            log.info("planApproveDateTemp=" + planApproveDateTemp);
        }
        List<DPlanMaterialPO> planMaterialPOList = null;
        map.put("planApproveDate", planApproveDateTemp);
        map.put("createDate", createDateTemp);
        map.put("beginBudgetAmount", beginBudget);
        map.put("endBudgetAmount", endBudget);
        map.put("planDepart", qryRequireOrderReqBO.getPlanDepart());
        map.put("planCode", qryRequireOrderReqBO.getPlanCode());
        log.info("qryRequireOrderReqBO.getPlanCode()=" + qryRequireOrderReqBO.getPlanCode());
        map.put("purchaseAccount", qryRequireOrderReqBO.getPurchaseAccount());
        map.put("planName", qryRequireOrderReqBO.getPlanName());
        map.put("operName", qryRequireOrderReqBO.getOperName());
        map.put("docStatus", qryRequireOrderReqBO.getDocStatus());
        map.put("qryApprFlag", qryRequireOrderReqBO.getQryApprFlag());
        log.info("createDateTemp=" + createDateTemp);
        log.info("qryRequireOrderReqBO.getIsPagination()=" + qryRequireOrderReqBO.getIsPagination());
        planMaterialPOList = "Y".equals(qryRequireOrderReqBO.getIsPagination()) ? this.dPlanMaterialMapper.queryPlanMaterialForPage(map, (Page<Map<String, Object>>)page) : this.dPlanMaterialMapper.queryPlanMaterialNoPage(map);
        log.info("queryPlanMaterial end");
        List reqOrderInfoList = null;
        if (CollectionUtils.isNotEmpty(planMaterialPOList)) {
            log.info("planMaterialPOList.size()=" + planMaterialPOList.size());
            reqOrderInfoList = planMaterialPOList.stream().map(e -> {
                RequireOrderInfoBO reqOrderInfoBO = new RequireOrderInfoBO();
                BeanUtils.copyProperties((Object)e, (Object)reqOrderInfoBO);
                reqOrderInfoBO.setOperId(e.getCreateUserId());
                log.info("reqOrderInfoBO.getOperName()=" + reqOrderInfoBO.getOperName());
                reqOrderInfoBO.setOperName(e.getCreateUserName());
                reqOrderInfoBO.setPlanUnit(e.getPurchaseId());
                reqOrderInfoBO.setPlanUnitName(e.getPurchaseName());
                if (e.getSubmitTime() != null) {
                    reqOrderInfoBO.setCreateDate(DateUtils.dateToStr((Date)e.getSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (e.getPlanApproveDate() != null) {
                    reqOrderInfoBO.setPlanApproveDate(DateUtils.dateToStr((Date)e.getPlanApproveDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (e.getInquiryCreateDate() != null) {
                    reqOrderInfoBO.setInquireCreateDate(DateUtils.dateToStr((Date)e.getInquiryCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                BigDecimal amount = new BigDecimal(10000);
                BigDecimal budgetTemp = null;
                if (e.getBudgetAmount() != null) {
                    budgetTemp = new BigDecimal(e.getBudgetAmount());
                    log.info("budgetTemp=" + budgetTemp);
                    reqOrderInfoBO.setBudgetAmount(budgetTemp.divide(amount).setScale(2, RoundingMode.HALF_UP));
                } else {
                    budgetTemp = new BigDecimal(0);
                    reqOrderInfoBO.setBudgetAmount(budgetTemp);
                }
                log.info("reqOrderInfoBO.getBudgetAmount()=" + reqOrderInfoBO.getBudgetAmount());
                reqOrderInfoBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("REQ_DOC_STATUS", e.getDocStatus() + ""));
                reqOrderInfoBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", e.getPurchaseMethod() + ""));
                List<DIqrInquiryMatePO> dIqrInquiryMatePOS = this.dIqrInquiryMateMapper.selectByPlanId(reqOrderInfoBO.getPlanId());
                if (CollectionUtils.isNotEmpty(dIqrInquiryMatePOS)) {
                    reqOrderInfoBO.setHadIqrOrderFlag("1");
                    for (DIqrInquiryMatePO dIqrInquiryMatePO : dIqrInquiryMatePOS) {
                        reqOrderInfoBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                    }
                } else {
                    reqOrderInfoBO.setHadIqrOrderFlag("0");
                }
                if ("1002".equals(reqOrderInfoBO.getDocStatus()) || "1003".equals(reqOrderInfoBO.getDocStatus())) {
                    reqOrderInfoBO.setIsShowCloseFlag("1");
                } else {
                    reqOrderInfoBO.setIsShowCloseFlag("0");
                }
                return reqOrderInfoBO;
            }).collect(Collectors.toList());
        }
        log.info("reqOrderInfoList\u8d4b\u503c\u5b8c\u6210");
        qryRequireOrderRspBO.setPageNo(qryRequireOrderReqBO.getPageNo());
        qryRequireOrderRspBO.setTotal(page.getTotalPages());
        qryRequireOrderRspBO.setRecordsTotal(page.getTotalCount());
        qryRequireOrderRspBO.setRows(reqOrderInfoList);
        qryRequireOrderRspBO.setRespCode("0000");
        qryRequireOrderRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryRequireOrderRspBO=" + qryRequireOrderRspBO.toString());
        return qryRequireOrderRspBO;
    }
}

