/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.enquiry.api.performlist.bo.ApprCirculationBO;
import com.tydic.enquiry.api.performlist.bo.QryApprCircReqBO;
import com.tydic.enquiry.api.performlist.bo.QryApprCircRspBO;
import com.tydic.enquiry.api.performlist.service.QryApprCircService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.util.HttpSendUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryApprCircService.class)
public class QryApprCircServiceImpl
implements QryApprCircService {
    private static final Logger log = LoggerFactory.getLogger(QryApprCircServiceImpl.class);
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Value(value="${erp.appr.url}")
    private String erpApprUrl;

    public QryApprCircRspBO qryApprCirculationInfo(QryApprCircReqBO qryApprCircReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryApprCircReqBO=" + qryApprCircReqBO.toString());
        QryApprCircRspBO qryApprCircRspBO = new QryApprCircRspBO();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(qryApprCircReqBO.getInquiryId());
        if (dIqrInquiryMatePO == null) {
            qryApprCircRspBO.setRespCode("9999");
            qryApprCircRspBO.setRespDesc("\u672a\u83b7\u53d6\u5230\u7ade\u4ef7\u9879\u76ee\u4fe1\u606f");
            return qryApprCircRspBO;
        }
        log.info("erpApprUrl:" + this.erpApprUrl);
        JSONObject paramJson = new JSONObject();
        paramJson.put("biddcode", (Object)(qryApprCircReqBO.getInquiryId() + ""));
        log.info("paramJson.toJSONString():" + paramJson.toJSONString());
        String resultStr = "";
        try {
            resultStr = HttpSendUtils.sendPost(this.erpApprUrl + "/bidstatus/v1", paramJson.toJSONString());
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ERP\u83b7\u53d6\u5ba1\u6279\u6d41\u8f6c\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3API\u5f02\u5e38:" + e);
            throw new EnqBusinessException("9999", "\u8c03\u7528ERP\u83b7\u53d6\u5ba1\u6279\u6d41\u8f6c\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3API\u5f02\u5e38:" + e);
        }
        log.info("resultStr:" + resultStr);
        JSONObject returnObj = JSON.parseObject((String)resultStr);
        if (returnObj != null && returnObj.containsKey((Object)"code") && "1".equals(returnObj.getString("code"))) {
            if (returnObj.containsKey((Object)"msg")) {
                log.error(returnObj.getString("msg"));
                throw new EnqBusinessException("9999", returnObj.getString("msg"));
            }
            log.error("\u8c03\u7528ERP\u521b\u5efa\u7ade\u4ef7\u9879\u76eeAPI\u5931\u8d25");
            throw new EnqBusinessException("9999", "\u8c03\u7528ERP\u521b\u5efa\u7ade\u4ef7\u9879\u76eeAPI\u5931\u8d25");
        }
        qryApprCircRspBO.setPageNo(1);
        qryApprCircRspBO.setTotal(1);
        qryApprCircRspBO.setRecordsTotal(0);
        if (returnObj != null && returnObj.containsKey((Object)"data") && returnObj.getJSONArray("data") != null) {
            log.info("returnObj.get(\"data\")=" + returnObj.get((Object)"data"));
            ArrayList<ApprCirculationBO> apprCirculationBOList = new ArrayList<ApprCirculationBO>();
            JSONArray dataArray = returnObj.getJSONArray("data");
            log.info("dataArray.size()=" + dataArray.size());
            qryApprCircRspBO.setRecordsTotal(dataArray.size());
            int totalPages = dataArray.size() % 10 == 0 ? dataArray.size() / 10 : dataArray.size() / 10 + 1;
            log.info("totalPages=" + totalPages);
            qryApprCircRspBO.setTotal(totalPages);
            for (int i = 0; i < dataArray.size(); ++i) {
                ApprCirculationBO apprCirculationBO = new ApprCirculationBO();
                if (dataArray.getJSONObject(i).containsKey((Object)"approveresult")) {
                    apprCirculationBO.setApproveResult(dataArray.getJSONObject(i).getString("approveresult"));
                }
                if (dataArray.getJSONObject(i).containsKey((Object)"approvestatus")) {
                    apprCirculationBO.setApproveStatus(dataArray.getJSONObject(i).getString("approvestatus"));
                }
                if (dataArray.getJSONObject(i).containsKey((Object)"checkman")) {
                    apprCirculationBO.setCheckMan(dataArray.getJSONObject(i).getString("checkman"));
                }
                if (dataArray.getJSONObject(i).containsKey((Object)"checknote")) {
                    apprCirculationBO.setCheckNote(dataArray.getJSONObject(i).getString("checknote"));
                }
                if (dataArray.getJSONObject(i).containsKey((Object)"dealdate")) {
                    apprCirculationBO.setDealDate(dataArray.getJSONObject(i).getString("dealdate"));
                }
                if (dataArray.getJSONObject(i).containsKey((Object)"senderman")) {
                    apprCirculationBO.setSenderMan(dataArray.getJSONObject(i).getString("senderman"));
                }
                apprCirculationBOList.add(apprCirculationBO);
            }
            qryApprCircRspBO.setRows(apprCirculationBOList);
        }
        qryApprCircRspBO.setRespCode("0000");
        qryApprCircRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryApprCircRspBO=" + qryApprCircRspBO.toString());
        return qryApprCircRspBO;
    }
}

