/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.performlist.bo.BidsectionInfoBO;
import com.tydic.enquiry.api.registdoc.bo.CreateRisunRegistDocReqBO;
import com.tydic.enquiry.api.registdoc.bo.CreateRisunRegistDocRspBO;
import com.tydic.enquiry.api.registdoc.service.CreateRisunRegistDocService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=CreateRisunRegistDocService.class)
public class CreateRisunRegistDocServiceImpl
implements CreateRisunRegistDocService {
    private static final Logger log = LoggerFactory.getLogger(CreateRisunRegistDocServiceImpl.class);
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    SeqIdCreateService seqIdCreateService;
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;
    @Autowired
    DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;
    @Autowired
    QryDicAtomService qryDicAtomService;
    @Autowired
    DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;

    @Transactional(rollbackFor={Exception.class})
    public CreateRisunRegistDocRspBO risunRegistDocCreate(CreateRisunRegistDocReqBO reqBO) {
        log.info("\u62a5\u540d\u5355\u521b\u5efa\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aCreateRisunRegistDocReqBO=" + reqBO.toString());
        CreateRisunRegistDocRspBO rspBO = new CreateRisunRegistDocRspBO();
        try {
            rspBO = this.initParam(reqBO);
            if ("9999".equals(rspBO.getRespCode())) {
                return rspBO;
            }
            DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(reqBO.getInquiryId());
            if (null != dIqrInquiryMatePO && new Date().after(dIqrInquiryMatePO.getLimitQuoteDate())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u540d\u65f6\u95f4\u5df2\u8fc7!");
                return rspBO;
            }
            List<DIqrInquiryDetailPO> dIqrInquiryDetailPOS = this.dIqrInquiryDetailMapper.selectByInquiryId(reqBO.getInquiryId());
            if (null != dIqrInquiryMatePO || CollectionUtils.isNotEmpty(dIqrInquiryDetailPOS)) {
                Long registId = null;
                DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectRegistDocByInquiryIdSupId(reqBO.getInquiryId(), reqBO.getSupplierId());
                if (null != dIqrRegistDocPO) {
                    if ("3002".equals(dIqrRegistDocPO.getDocStatus().toString())) {
                        rspBO.setRespCode("9999");
                        rspBO.setRespDesc("\u60a8\u5df2\u62a5\u540d!");
                        return rspBO;
                    }
                    dIqrRegistDocPO.setDocStatus(Integer.valueOf("3002"));
                    dIqrRegistDocPO.setRegistTime(new Date());
                    dIqrRegistDocPO.setRegistUserId(reqBO.getRegistUserId());
                    dIqrRegistDocPO.setRegistUserName(reqBO.getRegistUserName());
                    BigDecimal totalMarginAmount = new BigDecimal(0);
                    if (reqBO.getTotalMarginAmount() != null) {
                        totalMarginAmount = reqBO.getTotalMarginAmount();
                    } else if (CollectionUtils.isNotEmpty((Collection)reqBO.getBidsectionInfoList())) {
                        for (BidsectionInfoBO bidsectionInfoBO : reqBO.getBidsectionInfoList()) {
                            if (!"1".equals(bidsectionInfoBO.getParticipateFlag())) continue;
                            totalMarginAmount = totalMarginAmount.add(bidsectionInfoBO.getMarginAmount());
                        }
                    }
                    dIqrRegistDocPO.setMarginAmount(MoneyUtils.BigDecimal2Long((BigDecimal)totalMarginAmount));
                    this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocPO);
                    String dicCodeName = this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", "3002");
                    registId = dIqrRegistDocPO.getRegistId();
                    this.insertOperLog(dIqrRegistDocPO.getRegistId(), "\u4f9b\u5e94\u5546\u62a5\u540d", "\u62a5\u540d\u5355\u72b6\u6001\u53d8\u66f4(" + dicCodeName + ")", reqBO.getRegistUserId(), reqBO.getRegistUserName());
                } else {
                    DIqrRegistDocPO dIqrRegistDocInsert = new DIqrRegistDocPO();
                    registId = this.getDocId("RISUN01", "3");
                    dIqrRegistDocInsert.setRegistId(registId);
                    BeanUtils.copyProperties((Object)dIqrInquiryMatePO, (Object)dIqrRegistDocInsert);
                    dIqrRegistDocInsert.setRegistUserId(reqBO.getRegistUserId());
                    dIqrRegistDocInsert.setRegistUserName(reqBO.getRegistUserName());
                    dIqrRegistDocInsert.setRegistIpAddr(reqBO.getRegistIpAddr());
                    dIqrRegistDocInsert.setValidStatus(Constants.IS_VALID_Y);
                    dIqrRegistDocInsert.setSupplierId(reqBO.getSupplierId());
                    dIqrRegistDocInsert.setSupplierName(reqBO.getSupplierName());
                    dIqrRegistDocInsert.setCreditNo(reqBO.getCreditNo());
                    dIqrRegistDocInsert.setPhoneNumber(reqBO.getPhoneNumber());
                    dIqrRegistDocInsert.setSupplierContactName(reqBO.getSupplierContactName());
                    dIqrRegistDocInsert.setSupplierContactTele(reqBO.getSupplierContactTele());
                    dIqrRegistDocInsert.setRegistBeginDate(new Date());
                    dIqrRegistDocInsert.setRegistEndDate(dIqrInquiryMatePO.getLimitQuoteDate());
                    dIqrRegistDocInsert.setRegistTime(new Date());
                    if (reqBO.getTotalMarginAmount() != null) {
                        dIqrRegistDocInsert.setMarginAmount(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getTotalMarginAmount()));
                    }
                    if (Constants.PURCHASE_METHOD_INVITE.equals(reqBO.getPurchaseMethod())) {
                        dIqrRegistDocInsert.setDocStatus(Integer.valueOf("3001"));
                        dIqrRegistDocInsert.setPayStatus("1");
                    } else {
                        dIqrRegistDocInsert.setDocStatus(Integer.valueOf("3002"));
                        dIqrRegistDocInsert.setPayStatus("1");
                    }
                    int ret = this.dIqrRegistDocMapper.insertSelective(dIqrRegistDocInsert);
                    this.insertOperLog(dIqrRegistDocInsert.getRegistId(), "\u4f9b\u5e94\u5546\u62a5\u540d", "\u62a5\u540d\u5355\u4fe1\u606f\u521b\u5efa", reqBO.getRegistUserId(), reqBO.getRegistUserName());
                }
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getBidsectionInfoList())) {
                    ArrayList<DIqrRegistDetailPO> dIqrRegistDetailPOList = new ArrayList<DIqrRegistDetailPO>();
                    for (BidsectionInfoBO bidsectionInfoBO : reqBO.getBidsectionInfoList()) {
                        if (!"1".equals(bidsectionInfoBO.getParticipateFlag())) continue;
                        DIqrRegistDetailPO dIqrRegistDetailInsert = new DIqrRegistDetailPO();
                        dIqrRegistDetailInsert.setRegistItemId(this.getDocId("RISUN01", "31"));
                        dIqrRegistDetailInsert.setInquiryId(reqBO.getInquiryId());
                        dIqrRegistDetailInsert.setRegistId(registId);
                        dIqrRegistDetailInsert.setInquiryItemId(dIqrInquiryDetailPOS.get(0).getInquiryItemId());
                        dIqrRegistDetailInsert.setRemarks(bidsectionInfoBO.getBidsectionName() + "\u6807\u6bb5\u62a5\u540d\u660e\u7ec6\u521b\u5efa");
                        dIqrRegistDetailInsert.setValidStatus(Constants.IS_VALID_Y);
                        dIqrRegistDetailInsert.setBidsectionId(bidsectionInfoBO.getBidsectionId());
                        dIqrRegistDetailPOList.add(dIqrRegistDetailInsert);
                    }
                    this.dIqrRegistDetailMapper.insertRegistDetailBatch(dIqrRegistDetailPOList);
                }
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u7ade\u4ef7\u5355\u6570\u636e\u4e0d\u5b58\u5728!");
            }
        }
        catch (Exception e) {
            log.error("\u62a5\u540d\u5355\u521b\u5efa\u5f02\u5e38", (Throwable)e);
            throw new EnqBusinessException("9999", "\u62a5\u540d\u5355\u521b\u5efa\u5f02\u5e38");
        }
        return rspBO;
    }

    private void insertOperLog(Long docId, String operLink, String behavior, Long operUserId, String operUserName) {
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        cAllOperLogPO.setHisId(this.getDocId("RISUN01", "99"));
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperBehavior(behavior);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        cAllOperLogPO.setRemark("\u6210\u529f");
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }

    private Long getDocId(String systemId, String type) {
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId(systemId);
        seqEnquiryReqBO.setSeqType(type);
        return this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId();
    }

    private CreateRisunRegistDocRspBO initParam(CreateRisunRegistDocReqBO reqBO) {
        CreateRisunRegistDocRspBO rspBO = new CreateRisunRegistDocRspBO();
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getPurchaseMethod() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        return rspBO;
    }
}

