/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.BidsectionInfoBO;
import com.tydic.enquiry.api.quote.bo.CreateQuotationBillByRegistReqBO;
import com.tydic.enquiry.api.quote.bo.GenerateQuotationBillReqBO;
import com.tydic.enquiry.api.quote.bo.GenerateQuotationBillRspBO;
import com.tydic.enquiry.api.quote.bo.QuoteExecOrderDetailBO;
import com.tydic.enquiry.api.quote.bo.QuoteInquiryDatailBO;
import com.tydic.enquiry.api.quote.bo.QuoteRegistIqrDocBO;
import com.tydic.enquiry.api.quote.bo.QuoteRegistItemBO;
import com.tydic.enquiry.api.quote.service.CreateQuotationBillByRegistService;
import com.tydic.enquiry.api.quote.service.GenerateQuotationBillService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=GenerateQuotationBillService.class)
public class GenerateQuotationBillServiceImpl
implements GenerateQuotationBillService {
    private static final Logger log = LoggerFactory.getLogger(GenerateQuotationBillServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @Autowired
    CreateQuotationBillByRegistService createQuotationBillByRegistService;
    @Autowired
    DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;

    public GenerateQuotationBillRspBO addQuotationBill(GenerateQuotationBillReqBO reqBO) {
        GenerateQuotationBillRspBO rspBO = new GenerateQuotationBillRspBO();
        QuoteExecOrderDetailBO quoteExecOrderDetailBO = new QuoteExecOrderDetailBO();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
        Date date0 = new Date();
        log.info("dIqrInquiryMatePO.getValidStatus()=" + dIqrInquiryMatePO.getValidStatus());
        if (dIqrInquiryMatePO == null || dIqrInquiryMatePO.getValidStatus() == null || Constants.IS_VALID_Y != dIqrInquiryMatePO.getValidStatus()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u5df2\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        log.info("dIqrInquiryMatePO.getDocStatus().toString()=" + dIqrInquiryMatePO.getDocStatus().toString());
        log.info("date0.compareTo(dIqrInquiryMatePO.getQuoteEndDate())=" + date0.compareTo(dIqrInquiryMatePO.getQuoteEndDate()));
        log.info("date0.compareTo(dIqrInquiryMatePO.getLimitQuoteDate()=" + date0.compareTo(dIqrInquiryMatePO.getLimitQuoteDate()));
        if (date0.compareTo(dIqrInquiryMatePO.getQuoteEndDate()) >= 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u751f\u6210\u62a5\u4ef7\u5355");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        BeanUtils.copyProperties((Object)dIqrInquiryMatePO, (Object)quoteExecOrderDetailBO);
        if (dIqrInquiryMatePO.getQuoteEndDate() != null) {
            quoteExecOrderDetailBO.setQuoteEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (dIqrInquiryMatePO.getLimitQuoteDate() != null) {
            quoteExecOrderDetailBO.setLimitQuoteDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        quoteExecOrderDetailBO.setQuoteTimeLimit(Integer.valueOf(1));
        List<Object> dIqrRegistDocPOList = new ArrayList();
        if (reqBO.getRegistId() != null) {
            DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectByPrimaryKey(reqBO.getRegistId());
            dIqrRegistDocPOList.add(dIqrRegistDocPO);
        } else {
            dIqrRegistDocPOList = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(reqBO.getInquiryId());
        }
        ArrayList<Long> registIds = new ArrayList<Long>();
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        if (CollectionUtils.isEmpty(dIqrRegistDocPOList)) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u5df2\u62a5\u540d\u7684\u4f9b\u5e94\u5546\u4e0d\u53ef\u4ee5\u751f\u6210\u62a5\u4ef7\u5355");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocPOList) {
            registIds.add(dIqrRegistDocPO.getRegistId());
            supplierIds.add(dIqrRegistDocPO.getSupplierId());
        }
        DIqrQuotationPO record = new DIqrQuotationPO();
        record.setInquiryId(reqBO.getInquiryId());
        record.setValidStatus(Constants.IS_VALID_Y);
        record.setSupplierIds(supplierIds);
        List<DIqrQuotationPO> list = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
        if (CollectionUtils.isNotEmpty(list)) {
            String supplierNames = "";
            for (DIqrQuotationPO dIqrQuotationPO : list) {
                supplierNames = supplierNames + dIqrQuotationPO.getSupplierName() + ";";
            }
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u5bf9\u5e94\u7684\u4f9b\u5e94\u5546[" + supplierNames + "]\u5df2\u751f\u6210\u62a5\u4ef7\u5355\u4e0d\u53ef\u4ee5\u91cd\u590d\u751f\u6210\u62a5\u4ef7\u5355");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        List<DIqrRegistDetailPO> dIqrRegistDetailPOList = this.dIqrRegistDetailMapper.selectByRegistIds(registIds);
        List<DIqrInquiryDetailPO> dIqrInquiryDetailPOList = this.dIqrInquiryDetailMapper.selectByInquiryId(reqBO.getInquiryId());
        ArrayList<QuoteInquiryDatailBO> quoteInquiryDatailBOList = new ArrayList<QuoteInquiryDatailBO>();
        for (DIqrInquiryDetailPO dIqrInquiryDetailPO : dIqrInquiryDetailPOList) {
            QuoteInquiryDatailBO quoteInquiryDatailBO = new QuoteInquiryDatailBO();
            BeanUtils.copyProperties((Object)dIqrInquiryDetailPO, (Object)quoteInquiryDatailBO);
            try {
                quoteInquiryDatailBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getBudgetPrice()));
                quoteInquiryDatailBO.setGoodsNumber(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getGoodsNumber()));
                quoteInquiryDatailBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getBudgetAmount()));
            }
            catch (Exception exception) {
                log.error("\u91d1\u989d\u8f6c\u6362\u5931\u8d25:" + exception);
                throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u6362\u5931\u8d25:" + exception.getMessage());
            }
            quoteInquiryDatailBOList.add(quoteInquiryDatailBO);
        }
        ArrayList<BidsectionInfoBO> bidsectionInfoBOList = new ArrayList<BidsectionInfoBO>();
        List<DIqrInquiryBidsectionPO> bidsectionPOList = this.dIqrInquiryBidsectionMapper.selectByInquiryId(reqBO.getInquiryId());
        if (CollectionUtils.isNotEmpty(bidsectionPOList)) {
            for (DIqrInquiryBidsectionPO dIqrInquiryBidsectionPO : bidsectionPOList) {
                BidsectionInfoBO bidsectionInfoBO = new BidsectionInfoBO();
                BeanUtils.copyProperties((Object)dIqrInquiryBidsectionPO, (Object)bidsectionInfoBO);
                try {
                    bidsectionInfoBO.setMarginAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryBidsectionPO.getMarginAmount()));
                    bidsectionInfoBO.setBiddingPrice(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryBidsectionPO.getBiddingPrice()));
                    bidsectionInfoBO.setBidNumber(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryBidsectionPO.getBidNumber()));
                    bidsectionInfoBO.setDecreasePrice(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryBidsectionPO.getDecreasePrice()));
                }
                catch (Exception e) {
                    log.error("\u91d1\u989d\u8f6c\u6362\u5931\u8d25:" + e);
                    throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u6362\u5931\u8d25:" + e.getMessage());
                }
                bidsectionInfoBOList.add(bidsectionInfoBO);
            }
        }
        if (CollectionUtils.isNotEmpty(dIqrRegistDocPOList)) {
            for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocPOList) {
                ArrayList<QuoteRegistItemBO> quoteRegistItemBOList = new ArrayList<QuoteRegistItemBO>();
                QuoteRegistIqrDocBO quoteRegistIqrDocBO = new QuoteRegistIqrDocBO();
                BeanUtils.copyProperties((Object)dIqrRegistDocPO, (Object)quoteRegistIqrDocBO);
                if (dIqrRegistDocPO.getRegistTime() != null) {
                    quoteRegistIqrDocBO.setRegistTime(DateUtils.dateToStr((Date)dIqrRegistDocPO.getRegistTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                try {
                    quoteRegistIqrDocBO.setMarginAmount(MoneyUtils.Long2BigDecimal((Long)dIqrRegistDocPO.getMarginAmount()));
                }
                catch (Exception e) {
                    log.error("\u91d1\u989d\u8f6c\u6362\u5931\u8d25:", (Throwable)e);
                    throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u6362\u5931\u8d25:" + e.getMessage());
                }
                for (DIqrRegistDetailPO dIqrRegistDetailPO : dIqrRegistDetailPOList) {
                    if (dIqrRegistDetailPO.getRegistId().longValue() != dIqrRegistDocPO.getRegistId().longValue()) continue;
                    QuoteRegistItemBO quoteRegistItemBO = new QuoteRegistItemBO();
                    BeanUtils.copyProperties((Object)dIqrRegistDetailPO, (Object)quoteRegistItemBO);
                    quoteRegistItemBOList.add(quoteRegistItemBO);
                }
                CreateQuotationBillByRegistReqBO createQuotationBillByRegistReqBO = new CreateQuotationBillByRegistReqBO();
                createQuotationBillByRegistReqBO.setQuoteExecOrderDetailBO(quoteExecOrderDetailBO);
                createQuotationBillByRegistReqBO.setQuoteRegistIqrDocBO(quoteRegistIqrDocBO);
                createQuotationBillByRegistReqBO.setQuoteRegistItemBOList(quoteRegistItemBOList);
                createQuotationBillByRegistReqBO.setQuoteInquiryDatailBOList(quoteInquiryDatailBOList);
                createQuotationBillByRegistReqBO.setBidsectionInfoBOList(bidsectionInfoBOList);
                this.createQuotationBillByRegistService.CreateQuotationBillByRegist(createQuotationBillByRegistReqBO);
                registIds.add(dIqrRegistDocPO.getRegistId());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u751f\u6210\u62a5\u4ef7\u5355\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

