/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.github.pagehelper.util.StringUtil;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillItemReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillItemRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationItemBO;
import com.tydic.enquiry.api.quote.service.QryQuotationBillItemByRedisNoService;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMidMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrQuotationItemMidPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryQuotationBillItemByRedisNoService.class)
public class QryQuotationBillItemByRedisNoServiceImpl
implements QryQuotationBillItemByRedisNoService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationBillItemByRedisNoServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    private DIqrQuotationItemMidMapper dIqrQuotationItemMidMapper;

    public QryQuotationBillItemRspBO qryQuotationBillItemByRedisNo(QryQuotationBillItemReqBO reqBO) {
        QryQuotationBillItemRspBO rspBO = new QryQuotationBillItemRspBO();
        DIqrQuotationPO dIqrQuotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
        if (dIqrQuotationPO == null) {
            log.error("\u6b64\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        List<DIqrInquiryDetailPO> dIqrInquiryDetailPOs = this.dIqrInquiryDetailMapper.selectByInquiryId(dIqrQuotationPO.getInquiryId());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        DIqrQuotationItemMidPO record = new DIqrQuotationItemMidPO();
        if (StringUtil.isNotEmpty((String)reqBO.getInquiryPkgId())) {
            record.setInquiryPkgId(reqBO.getInquiryPkgId());
        }
        record.setQuotationId(reqBO.getQuotationId());
        record.setRedisNo(reqBO.getRedisNo());
        List<DIqrQuotationItemMidPO> dIqrQuotationItemMidPOList = this.dIqrQuotationItemMidMapper.selectByQuotationItemForPage(record, (Page<DIqrQuotationItemMidPO>)page);
        List<Object> quotationItemBOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(dIqrQuotationItemMidPOList)) {
            quotationItemBOList = dIqrQuotationItemMidPOList.stream().map(e -> {
                QuotationItemBO quotationItemBO = new QuotationItemBO();
                BeanUtils.copyProperties((Object)e, (Object)quotationItemBO);
                for (DIqrInquiryDetailPO dIqrInquiryDetailPO : dIqrInquiryDetailPOs) {
                    if (dIqrInquiryDetailPO.getInquiryItemId().longValue() != e.getInquiryItemId().longValue()) continue;
                    BeanUtils.copyProperties((Object)dIqrInquiryDetailPO, (Object)quotationItemBO);
                    try {
                        quotationItemBO.setEvalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getEvalAmount()));
                        quotationItemBO.setOriginalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getOriginalAmount()));
                        quotationItemBO.setShowAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getShowAmount()));
                        quotationItemBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getBudgetPrice()));
                        quotationItemBO.setGoodsNumber(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getGoodsNumber()));
                        quotationItemBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getBudgetAmount()));
                    }
                    catch (Exception e1) {
                        log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e1.getStackTrace());
                        rspBO.setRespCode("9999");
                        rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                    }
                    quotationItemBO.setMaterialClassName(this.qryDicAtomService.getDicCodeName("MATERIAL_CLASS_ID", dIqrInquiryDetailPO.getMaterialClassId() + ""));
                    break;
                }
                try {
                    Long quotePrice = e.getQuotePrice();
                    Long quoteAmount = e.getQuoteAmount();
                    if (StringUtils.isNotEmpty((CharSequence)e.getQuotePriceSec())) {
                        quotePrice = QuoteUtil.decode(e.getQuotePriceSec(), e.getQuotationId().toString());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)e.getQuoteAmountSec())) {
                        quoteAmount = QuoteUtil.decode(e.getQuoteAmountSec(), e.getQuotationId().toString());
                    }
                    quotationItemBO.setPurchaseNum(MoneyUtils.Long2BigDecimal((Long)e.getPurchaseNum()));
                    quotationItemBO.setQuotePrice(MoneyUtils.Long2BigDecimal((Long)quotePrice));
                    quotationItemBO.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quoteAmount));
                }
                catch (Exception e1) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e1.getStackTrace());
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                quotationItemBO.setSupplierId(dIqrQuotationPO.getSupplierId());
                quotationItemBO.setSupplierName(dIqrQuotationPO.getSupplierName());
                quotationItemBO.setQuoteRounds(dIqrQuotationPO.getQuoteRounds());
                quotationItemBO.setBrand(e.getBrand());
                quotationItemBO.setManufacturer(e.getManufacturer());
                quotationItemBO.setGoodsCode(e.getGoodsCode());
                quotationItemBO.setExtraGoodsCode(e.getExtraGoodsCode());
                return quotationItemBO;
            }).collect(Collectors.toList());
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(quotationItemBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

