/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.performlist.bo.HadRegistBO;
import com.tydic.enquiry.api.performlist.bo.IqrRegistInfoBO;
import com.tydic.enquiry.api.performlist.bo.QryHadRegistForDealReqBO;
import com.tydic.enquiry.api.performlist.bo.QryHadRegistForDealRspBO;
import com.tydic.enquiry.api.performlist.service.QryHadRegistForDealService;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrPurchaseNoticePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryHadRegistForDealService.class)
public class QryHadRegistForDealServiceImpl
implements QryHadRegistForDealService {
    private static final Logger log = LoggerFactory.getLogger(QryHadRegistForDealServiceImpl.class);
    @Autowired
    private DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    public QryHadRegistForDealRspBO qryHadRegistForDeal(QryHadRegistForDealReqBO reqBO) {
        log.info("QryHadRegistForDealReqBO\u5165\u53c2\u6570\u636e\u4fe1\u606f******************" + reqBO);
        QryHadRegistForDealRspBO rspBO = new QryHadRegistForDealRspBO();
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<DIqrPurchaseNoticePO> dIqrPurchaseNoticePOList = null;
        if (!"ALL".equals(reqBO.getPurchaseMethod())) {
            map.put("purchaseMethod", reqBO.getPurchaseMethod());
        }
        map.put("purchaseId", reqBO.getPurchaseId());
        map.put("inquiryCode", reqBO.getInquiryCode());
        map.put("inquiryName", reqBO.getInquiryName());
        map.put("busiType", reqBO.getBusiType());
        if ("Y".equals(reqBO.getIsPagination())) {
            try {
                dIqrPurchaseNoticePOList = this.dIqrPurchaseNoticeMapper.queryHadRegistForDealForPage(map, (Page<Map<String, Object>>)page);
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc(e.toString());
                log.error("\u5f02\u5e38\u4fe1\u606f\uff1ae=" + e.toString());
                return rspBO;
            }
        } else {
            dIqrPurchaseNoticePOList = this.dIqrPurchaseNoticeMapper.queryHadRegistForDealNoPage(map);
        }
        log.info("************ end");
        if (CollectionUtils.isNotEmpty(dIqrPurchaseNoticePOList)) {
            ArrayList<IqrRegistInfoBO> iqrRegistInfoBOList = new ArrayList<IqrRegistInfoBO>();
            for (DIqrPurchaseNoticePO po : dIqrPurchaseNoticePOList) {
                IqrRegistInfoBO iqrRegistInfoBO = new IqrRegistInfoBO();
                BeanUtils.copyProperties((Object)po, (Object)iqrRegistInfoBO);
                iqrRegistInfoBO.setRegistBeginDate(DateUtils.dateToStr((Date)po.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                iqrRegistInfoBO.setRegistEndDate(DateUtils.dateToStr((Date)po.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                iqrRegistInfoBO.setQuoteBeginDate(DateUtils.dateToStr((Date)po.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                iqrRegistInfoBO.setQuoteEndDate(DateUtils.dateToStr((Date)po.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                iqrRegistInfoBO.setRegistTimeReq(DateUtils.dateToStr((Date)po.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss") + " \u81f3 " + DateUtils.dateToStr((Date)po.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                iqrRegistInfoBO.setQuoteTimeReq(DateUtils.dateToStr((Date)po.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss") + " \u81f3 " + DateUtils.dateToStr((Date)po.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (po.getDocType() != null) {
                    iqrRegistInfoBO.setPurchaseMethod(Integer.valueOf(Integer.parseInt(po.getDocType())));
                }
                iqrRegistInfoBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("DOC_TYPE", po.getDocType()));
                HashMap<String, Object> maps = new HashMap<String, Object>();
                maps.put("inquiryId", po.getInquiryId());
                Date registTimeTemp = DateUtils.strToDate((String)reqBO.getRegistTime(), (String)"yyyyMMddHHmmss");
                maps.put("registTime", registTimeTemp);
                maps.put("payStatus", reqBO.getPayStatus());
                List<DIqrRegistDocPO> dIqrRegistDocPOList = this.dIqrRegistDocMapper.selectHadRegistByMaps(maps);
                if (CollectionUtils.isNotEmpty(dIqrRegistDocPOList)) {
                    List<DIqrRegistDocPO> sameIpList = this.dIqrRegistDocMapper.countRegistIpByMaps(maps);
                    iqrRegistInfoBO.setRegistNum(Integer.valueOf(dIqrRegistDocPOList.size()));
                    ArrayList<HadRegistBO> hadRegistBOList = new ArrayList<HadRegistBO>();
                    for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocPOList) {
                        HadRegistBO hadRegistBO = new HadRegistBO();
                        BeanUtils.copyProperties((Object)dIqrRegistDocPO, (Object)hadRegistBO);
                        hadRegistBO.setIsIpSameFlag("N");
                        if (CollectionUtils.isNotEmpty(sameIpList)) {
                            for (DIqrRegistDocPO sameIpPO : sameIpList) {
                                log.info("hadRegistBO.getRegistIpAddr()=" + hadRegistBO.getRegistIpAddr());
                                log.info("sameIpPO.getRegistIpAddr()=" + sameIpPO.getRegistIpAddr());
                                if (!hadRegistBO.getRegistIpAddr().equals(sameIpPO.getRegistIpAddr())) continue;
                                hadRegistBO.setIsIpSameFlag("Y");
                                break;
                            }
                        }
                        hadRegistBO.setRegistTime(DateUtils.dateToStr((Date)dIqrRegistDocPO.getRegistTime()));
                        hadRegistBO.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", dIqrRegistDocPO.getPayStatus()));
                        hadRegistBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", dIqrRegistDocPO.getDocStatus().toString()));
                        hadRegistBOList.add(hadRegistBO);
                    }
                    iqrRegistInfoBO.setHadRegistBOList(hadRegistBOList);
                }
                iqrRegistInfoBOList.add(iqrRegistInfoBO);
            }
            rspBO.setRows(iqrRegistInfoBOList);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

