/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.statistic;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.statistic.bo.EnquiryQryToDoReqBO;
import com.tydic.enquiry.api.statistic.bo.EnquiryQryToDoRspBO;
import com.tydic.enquiry.api.statistic.service.EnquiryQryToDoService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=EnquiryQryToDoService.class)
public class EnquiryQryToDoServiceImpl
implements EnquiryQryToDoService {
    private static final Logger log = LoggerFactory.getLogger(EnquiryQryToDoServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    public EnquiryQryToDoRspBO countList(EnquiryQryToDoReqBO reqBO) {
        EnquiryQryToDoRspBO rspBO = new EnquiryQryToDoRspBO();
        log.info("QryToDoService\u5165\u53c2:" + reqBO);
        if (StringUtils.isBlank((CharSequence)reqBO.getBtnCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6309\u94ae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        String btnCode = reqBO.getBtnCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("busiType", "RS1");
        if ("biddingToSubmit".equals(btnCode)) {
            map.put("operId", reqBO.getUserId());
            map.put("docStatus", "2001");
            rspBO.setTabsCount(Integer.valueOf(this.getCountRsp(map, Boolean.TRUE)));
        } else if ("biddingToNotice".equals(btnCode)) {
            map.put("docStatus", "2004");
            rspBO.setTabsCount(Integer.valueOf(this.getCountRsp(map, Boolean.TRUE)));
        } else if ("biddingToSureBond".equals(btnCode)) {
            map.put("operId", reqBO.getUserId());
            ArrayList<Integer> docStatusList = new ArrayList<Integer>();
            docStatusList.add(Integer.valueOf("2005"));
            map.put("docStatusList", docStatusList);
            map.put("payStatus", Integer.valueOf("1"));
            rspBO.setTabsCount(Integer.valueOf(this.dIqrInquiryMateMapper.countByRefundStatus(map)));
        } else if ("biddingToSureResult".equals(btnCode)) {
            map.put("operId", reqBO.getUserId());
            map.put("docStatus", "2007");
            rspBO.setTabsCount(Integer.valueOf(this.getCountRsp(map, Boolean.TRUE)));
        } else if ("biddingToReturnBond".equals(btnCode)) {
            map.put("operId", reqBO.getUserId());
            ArrayList<Integer> docStatusList = new ArrayList<Integer>();
            docStatusList.add(Integer.valueOf("2009"));
            docStatusList.add(Integer.valueOf("2011"));
            map.put("docStatusList", docStatusList);
            map.put("payStatus", Integer.valueOf("3"));
            rspBO.setTabsCount(Integer.valueOf(this.dIqrInquiryMateMapper.countByRefundStatus(map)));
        } else if ("biddingToResultPublicity".equals(btnCode)) {
            map.put("docStatus", "2008");
            rspBO.setTabsCount(Integer.valueOf(this.getCountRsp(map, Boolean.TRUE)));
        } else if ("biddingToSignup".equals(btnCode)) {
            map.put("supplierId", reqBO.getUserId());
            map.put("registEndDate", new Date());
            map.put("imDocStatus", Integer.valueOf("2005"));
            map.put("rdDocStatusList", Arrays.asList(Integer.valueOf("3001")));
            rspBO.setTabsCount(Integer.valueOf(this.getCountRsp(map, Boolean.FALSE)));
        } else if ("biddingToBid".equals(btnCode)) {
            List<Integer> statusList = Arrays.asList(Integer.valueOf("3002"), Integer.valueOf("3005"), Integer.valueOf("3006"));
            map.put("rdDocStatusList", statusList);
            List<Integer> imStatusList = Arrays.asList(Integer.valueOf("2005"), Integer.valueOf("2006"));
            map.put("imDocStatusList", imStatusList);
            rspBO.setTabsCount(Integer.valueOf(this.getCountRsp(map, Boolean.FALSE)));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("QryToDoService\u51fa\u53c2:" + rspBO);
        return rspBO;
    }

    private int getCountRsp(Map<String, Object> map, Boolean inquiry) {
        if (inquiry.booleanValue()) {
            return this.dIqrInquiryMateMapper.countInquiryMate(map);
        }
        return this.dIqrRegistDocMapper.countRegist(map);
    }
}

