/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.enquiry.base.EnquiryCallHttpSendMassageRspBO;
import com.tydic.enquiry.base.EnquiryRisunSendMassageReqBO;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.util.HttpSendUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class SendMsgUtil {
    private static final Log log = LogFactory.getLog(SendMsgUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMsg(String phoneNumbers, String noticeTitle, String purchaseName, String msgUrl, String msgCode, String templateParam) {
        log.info((Object)("\u77ed\u4fe1\u5730\u5740" + msgUrl));
        if (StringUtils.isNotBlank((CharSequence)phoneNumbers) && StringUtils.isNotBlank((CharSequence)msgUrl)) {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = null;
            try {
                if (StringUtils.isEmpty((CharSequence)msgCode)) {
                    msgCode = "SMS_207521302";
                }
                if (StringUtils.isEmpty((CharSequence)templateParam)) {
                    templateParam = "{\"unitName\":\"" + purchaseName + "\",\"bidName\":\"" + noticeTitle + "\"}";
                }
                String params = "{\"templateCode\":\"" + msgCode + "\",\"phoneNumbers\":\"" + phoneNumbers + "\",\"templateParam\":" + templateParam + "}";
                log.info((Object)("params=" + params));
                HttpPost httpPost = new HttpPost(msgUrl);
                StringEntity stringEntity = new StringEntity(params, "UTF-8");
                stringEntity.setContentType("text/plain");
                stringEntity.setContentEncoding((Header)new BasicHeader("Content-Type", "text/plain"));
                httpPost.setEntity((HttpEntity)stringEntity);
                httpPost.setHeader("Content-Type", "text/plain");
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity responseEntity = response.getEntity();
                String xmlContent = EntityUtils.toString((HttpEntity)responseEntity);
                log.info((Object)("-------\u8fd4\u56de\u539f\u503c:" + xmlContent));
            }
            catch (Exception e) {
                log.error((Object)"\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                try {
                    if (httpClient != null) {
                        httpClient.close();
                    }
                    if (response != null) {
                        response.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"httpClien\u91ca\u653e\u8d44\u6e90\u5f02\u5e38:", (Throwable)e);
                }
            }
        }
    }

    public static void sendMsgForAppr(String phoneNumber, String supplierName, String orgName, String bidName, String msgUrl) {
        String msgCode = "SMS_221080024";
        String templateParam = "{\"supplierName\":\"" + supplierName + "\",\"orgName\":\"" + orgName + "\",\"bidname\":\"" + bidName + "\"}";
        log.info((Object)("msgCode=" + msgCode));
        log.info((Object)("templateParam=" + templateParam));
        SendMsgUtil.sendMsg(phoneNumber, null, null, msgUrl, msgCode, templateParam);
    }

    public static EnquiryCallHttpSendMassageRspBO risunSendMassage(EnquiryRisunSendMassageReqBO reqBO, String msgUrl) {
        EnquiryCallHttpSendMassageRspBO rspBO = new EnquiryCallHttpSendMassageRspBO();
        if (StringUtils.isEmpty((CharSequence)msgUrl)) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u9879\u76ee\u77ed\u4fe1\u53d1\u9001\u8bf7\u6c42\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e");
            return rspBO;
        }
        String inStr = JSONObject.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        log.info((Object)("\u7ade\u4ef7\u9879\u76ee\u77ed\u4fe1\u53d1\u9001\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u77ed\u4fe1\u63a5\u53e3\u5730\u5740:{}" + msgUrl));
        log.info((Object)("\u7ade\u4ef7\u9879\u76ee\u77ed\u4fe1\u53d1\u9001\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u77ed\u4fe1\u63a5\u53e3\u5165\u53c2:{}" + inStr));
        String outStr = null;
        try {
            outStr = HttpSendUtils.sendPost(msgUrl, inStr);
        }
        catch (Exception e) {
            throw new EnqBusinessException("9999", "\u8c03\u7528\u7ade\u4ef7\u9879\u76ee\u521b\u5efa\u53d1\u9001\u77ed\u4fe1API\u5f02\u5e38:" + e);
        }
        log.info((Object)("\u7ade\u4ef7\u9879\u76ee\u77ed\u4fe1\u53d1\u9001\u8c03\u7528\u901a\u77e5\u4e2d\u5fc3\u77ed\u4fe1\u63a5\u53e3\u51fa\u53c2:{}" + outStr));
        if (StringUtils.isEmpty((CharSequence)outStr)) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u9879\u76ee\u77ed\u4fe1\u53d1\u9001\u672a\u8fd4\u56de\u7ed3\u679c");
            return rspBO;
        }
        EnquiryCallHttpSendMassageRspBO resultBO = (EnquiryCallHttpSendMassageRspBO)JSON.parseObject((String)outStr, EnquiryCallHttpSendMassageRspBO.class);
        if (resultBO == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u9879\u76ee\u77ed\u4fe1\u53d1\u9001\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff1a" + outStr);
            return rspBO;
        }
        if ("0".equals(resultBO.getCode())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7ade\u4ef7\u9879\u76ee\u77ed\u4fe1\u53d1\u9001\u6210\u529f");
        } else {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc(resultBO.getMessage());
        }
        rspBO.setCode(resultBO.getCode());
        rspBO.setMessage(resultBO.getMessage());
        return rspBO;
    }
}

