/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.ExecCreatePkgReqBO;
import com.tydic.enquiry.api.performlist.bo.ExecCreatePkgRspBO;
import com.tydic.enquiry.api.performlist.bo.InquiryDetailBO;
import com.tydic.enquiry.api.performlist.service.ExecCreatePkgService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryDetailMidMapper;
import com.tydic.enquiry.dao.DIqrInquiryPkgMidMapper;
import com.tydic.enquiry.dao.DPlanItemMaterialMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailMidPO;
import com.tydic.enquiry.po.DIqrInquiryPkgMidPO;
import com.tydic.enquiry.po.DPlanItemMaterialPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=ExecCreatePkgService.class)
public class ExecCreatePkgServiceImpl
implements ExecCreatePkgService {
    private static final Logger log = LoggerFactory.getLogger(ExecCreatePkgServiceImpl.class);
    @Autowired
    DIqrInquiryPkgMidMapper dIqrInquiryPkgMidMapper;
    @Autowired
    DIqrInquiryDetailMidMapper dIqrInquiryDetailMidMapper;
    @Autowired
    DPlanItemMaterialMapper dPlanItemMaterialMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD")
    SeqIdCreateService seqIdCreateService;

    public ExecCreatePkgRspBO createExecPkg(ExecCreatePkgReqBO execCreatePkgReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\uff1aexecCreatePkgReqBO.toString()=" + execCreatePkgReqBO.toString());
        ExecCreatePkgRspBO execCreatePkgRspBO = new ExecCreatePkgRspBO();
        if (CollectionUtils.isEmpty((Collection)execCreatePkgReqBO.getDetailList())) {
            execCreatePkgRspBO.setRespCode("9999");
            execCreatePkgRspBO.setRespDesc("\u5165\u53c2\u7f3a\u5c11\u660e\u7ec6\u6570\u636e");
            log.info("\u51fa\u53c2\u6570\u636e\uff1aexecCreatePkgRspBO.toString()=" + execCreatePkgRspBO.toString());
            return execCreatePkgRspBO;
        }
        Date operDate = new Date();
        BigDecimal amount = new BigDecimal(10000);
        Long sumAmount = 0L;
        List<DIqrInquiryDetailMidPO> detailMidPOList = this.dIqrInquiryDetailMidMapper.selectValidDetailByInquiryCode(execCreatePkgReqBO.getInquiryCode());
        if (CollectionUtils.isNotEmpty(detailMidPOList)) {
            for (DIqrInquiryDetailMidPO iqrDetailMidPO : detailMidPOList) {
                for (Object inquiryDetailBO : execCreatePkgReqBO.getDetailList()) {
                    if (!inquiryDetailBO.getPlanItemId().equals(iqrDetailMidPO.getPlanItemId())) continue;
                    execCreatePkgRspBO.setRespCode("9999");
                    execCreatePkgRspBO.setRespDesc(inquiryDetailBO.getMaterialName() + "\u7269\u6599\u6570\u636e\u5df2\u5728" + iqrDetailMidPO.getInquiryPkgId() + "\u5305\u4e2d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                    log.info("\u51fa\u53c2\u6570\u636e\uff1aexecCreatePkgRspBO.toString()=" + execCreatePkgRspBO.toString());
                    return execCreatePkgRspBO;
                }
            }
        }
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("ZH01");
        seqEnquiryReqBO.setSeqType("201");
        seqEnquiryReqBO.setDocCode(execCreatePkgReqBO.getInquiryCode());
        SeqEnquiryRspBO seqRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        ArrayList<DIqrInquiryDetailMidPO> inquiryDetailMidPOList = new ArrayList<DIqrInquiryDetailMidPO>();
        for (InquiryDetailBO inquiryDetailBO : execCreatePkgReqBO.getDetailList()) {
            DIqrInquiryDetailMidPO dIqrInquiryDetailMidPO = new DIqrInquiryDetailMidPO();
            BeanUtils.copyProperties((Object)inquiryDetailBO, (Object)dIqrInquiryDetailMidPO);
            seqEnquiryReqBO.setSystemId("ZH01");
            seqEnquiryReqBO.setSeqType("99");
            SeqEnquiryRspBO seqMidDetailBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
            dIqrInquiryDetailMidPO.setMidDetailId(seqMidDetailBO.getDocId());
            dIqrInquiryDetailMidPO.setValidStatus(Constants.IS_VALID_Y);
            dIqrInquiryDetailMidPO.setCreateTime(operDate);
            dIqrInquiryDetailMidPO.setInquiryCode(execCreatePkgReqBO.getInquiryCode());
            dIqrInquiryDetailMidPO.setInquiryPkgId(seqRspBO.getPkgDocId());
            dIqrInquiryDetailMidPO.setBudgetPrice(inquiryDetailBO.getBudgetPrice().multiply(amount).longValue());
            dIqrInquiryDetailMidPO.setGoodsNumber(inquiryDetailBO.getGoodsNumber().multiply(amount).longValue());
            dIqrInquiryDetailMidPO.setBudgetAmount(inquiryDetailBO.getBudgetPrice().multiply(inquiryDetailBO.getGoodsNumber()).multiply(amount).longValue());
            sumAmount = sumAmount + inquiryDetailBO.getBudgetPrice().multiply(inquiryDetailBO.getGoodsNumber()).multiply(amount).longValue();
            if ("2".equals(execCreatePkgReqBO.getBusiType())) {
                if (inquiryDetailBO.getProductionDate() != null && !"".equals(inquiryDetailBO.getProductionDate())) {
                    dIqrInquiryDetailMidPO.setProductionDate(DateUtils.strToDate((String)inquiryDetailBO.getProductionDate(), (String)"yyyyMMddHHmmss"));
                }
                if (inquiryDetailBO.getEvalAmount() != null) {
                    dIqrInquiryDetailMidPO.setEvalAmount(inquiryDetailBO.getEvalAmount().multiply(amount).longValue());
                }
                if (inquiryDetailBO.getOriginalAmount() != null) {
                    dIqrInquiryDetailMidPO.setOriginalAmount(inquiryDetailBO.getOriginalAmount().multiply(amount).longValue());
                }
                if (inquiryDetailBO.getShowAmount() != null) {
                    dIqrInquiryDetailMidPO.setShowAmount(inquiryDetailBO.getShowAmount().multiply(amount).longValue());
                }
            }
            inquiryDetailMidPOList.add(dIqrInquiryDetailMidPO);
        }
        int ret = this.dIqrInquiryDetailMidMapper.insertMidDetailBatch(inquiryDetailMidPOList);
        DIqrInquiryPkgMidPO dIqrInquiryPkgMidPO = new DIqrInquiryPkgMidPO();
        dIqrInquiryPkgMidPO.setInquiryPkgId(seqRspBO.getPkgDocId());
        dIqrInquiryPkgMidPO.setDetailNum(execCreatePkgReqBO.getDetailList().size());
        dIqrInquiryPkgMidPO.setCreateDate(operDate);
        dIqrInquiryPkgMidPO.setInquiryCode(execCreatePkgReqBO.getInquiryCode());
        dIqrInquiryPkgMidPO.setValidStatus(Constants.IS_VALID_Y);
        dIqrInquiryPkgMidPO.setPkgTotalAmount(sumAmount);
        ret = this.dIqrInquiryPkgMidMapper.insertSelective(dIqrInquiryPkgMidPO);
        ArrayList<InquiryDetailBO> returnDetailList = new ArrayList<InquiryDetailBO>();
        if ("1".equals(execCreatePkgReqBO.getBusiType()) && execCreatePkgReqBO.getPlanId() != null) {
            List<DPlanItemMaterialPO> allDetailList = this.dPlanItemMaterialMapper.selectItemMaterialByPlanId(execCreatePkgReqBO.getPlanId());
            if (CollectionUtils.isNotEmpty(allDetailList)) {
                for (DPlanItemMaterialPO dPlanItemMaterialPO : allDetailList) {
                    InquiryDetailBO inquiryDetailBO = new InquiryDetailBO();
                    BeanUtils.copyProperties((Object)dPlanItemMaterialPO, (Object)inquiryDetailBO);
                    try {
                        inquiryDetailBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)dPlanItemMaterialPO.getBudgetPrice()));
                        inquiryDetailBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)dPlanItemMaterialPO.getBudgetAmount()));
                        inquiryDetailBO.setGoodsNumber(MoneyUtils.Long2BigDecimal((Long)dPlanItemMaterialPO.getRequireNumber()));
                    }
                    catch (Exception e) {
                        log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                        execCreatePkgRspBO.setRespCode("9999");
                        execCreatePkgRspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                        return execCreatePkgRspBO;
                    }
                    for (DIqrInquiryDetailMidPO iqrDetailMidPO : detailMidPOList) {
                        if (!iqrDetailMidPO.getPlanItemId().equals(dPlanItemMaterialPO.getPlanItemId())) continue;
                        inquiryDetailBO.setInquiryPkgId(iqrDetailMidPO.getInquiryPkgId());
                        break;
                    }
                    for (InquiryDetailBO reqDetailBO : execCreatePkgReqBO.getDetailList()) {
                        if (!reqDetailBO.getPlanItemId().equals(dPlanItemMaterialPO.getPlanItemId())) continue;
                        inquiryDetailBO.setInquiryPkgId(seqRspBO.getPkgDocId());
                        break;
                    }
                    returnDetailList.add(inquiryDetailBO);
                }
            }
        } else {
            if (CollectionUtils.isNotEmpty(detailMidPOList)) {
                for (DIqrInquiryDetailMidPO iqrDetailMidPO : detailMidPOList) {
                    InquiryDetailBO inquiryDetailBO = new InquiryDetailBO();
                    BeanUtils.copyProperties((Object)iqrDetailMidPO, (Object)inquiryDetailBO);
                    if (iqrDetailMidPO.getProductionDate() != null && !"".equals(iqrDetailMidPO.getProductionDate())) {
                        inquiryDetailBO.setProductionDate(DateUtils.dateToStr((Date)iqrDetailMidPO.getProductionDate(), (String)"yyyyMMddHHmmss"));
                    }
                    try {
                        inquiryDetailBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)iqrDetailMidPO.getBudgetPrice()));
                        inquiryDetailBO.setGoodsNumber(MoneyUtils.Long2BigDecimal((Long)iqrDetailMidPO.getGoodsNumber()));
                        inquiryDetailBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)iqrDetailMidPO.getBudgetAmount()));
                        inquiryDetailBO.setEvalAmount(MoneyUtils.Long2BigDecimal((Long)iqrDetailMidPO.getEvalAmount()));
                        inquiryDetailBO.setOriginalAmount(MoneyUtils.Long2BigDecimal((Long)iqrDetailMidPO.getOriginalAmount()));
                        inquiryDetailBO.setShowAmount(MoneyUtils.Long2BigDecimal((Long)iqrDetailMidPO.getShowAmount()));
                    }
                    catch (Exception e) {
                        log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                        execCreatePkgRspBO.setRespCode("9999");
                        execCreatePkgRspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                        return execCreatePkgRspBO;
                    }
                    returnDetailList.add(inquiryDetailBO);
                }
            }
            for (InquiryDetailBO inquiryDetailBO : execCreatePkgReqBO.getDetailList()) {
                inquiryDetailBO.setInquiryPkgId(seqRspBO.getPkgDocId());
                returnDetailList.add(inquiryDetailBO);
            }
        }
        execCreatePkgRspBO.setIqrItemList(returnDetailList);
        execCreatePkgRspBO.setRespCode("0000");
        execCreatePkgRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\uff1aexecCreatePkgRspBO.toString()=" + execCreatePkgRspBO.toString());
        return execCreatePkgRspBO;
    }
}

