/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quoteFinish;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.quoteFinish.bo.RecoveryRisunQuoteReqBO;
import com.tydic.enquiry.api.quoteFinish.bo.RecoveryRisunQuoteRspBO;
import com.tydic.enquiry.api.quoteFinish.service.RecoveryRisunQuoteService;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.enquiry.vo.QuotationInfoVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=RecoveryRisunQuoteService.class)
public class RecoveryRisunQuoteServiceImpl
implements RecoveryRisunQuoteService {
    private static final Logger log = LoggerFactory.getLogger(RecoveryRisunQuoteServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;

    public RecoveryRisunQuoteRspBO recoveryRisunQuote(RecoveryRisunQuoteReqBO reqBO) {
        RecoveryRisunQuoteRspBO rspBO = new RecoveryRisunQuoteRspBO();
        List<DIqrInquiryBidsectionPO> bidsectionPOList = this.dIqrInquiryBidsectionMapper.queryEndBidsectionList(Integer.parseInt("2006"), new Date());
        if (!CollectionUtils.isEmpty(bidsectionPOList)) {
            for (DIqrInquiryBidsectionPO bidsectionPO : bidsectionPOList) {
                List<DIqrQuotationItemPO> list;
                HashSet<Long> supplierIdList = new HashSet<Long>();
                List<DIqrQuotationPO> quotationPOS = this.dIqrQuotationMapper.selectByBidsectionIdDocStatus(bidsectionPO.getBidsectionId(), "40014");
                if (!CollectionUtils.isEmpty(quotationPOS)) {
                    QuotationInfoVO vo = new QuotationInfoVO();
                    vo.setDocStatus(Integer.valueOf("40015"));
                    vo.setNodeStatus(Integer.valueOf("41014"));
                    ArrayList<Long> quotationIds = new ArrayList<Long>();
                    for (DIqrQuotationPO quotationPO : quotationPOS) {
                        quotationIds.add(quotationPO.getQuotationId());
                        supplierIdList.add(quotationPO.getSupplierId());
                    }
                    vo.setQuotationIds(quotationIds);
                    this.dIqrQuotationMapper.updateByQuotationIds(vo);
                }
                List<Integer> statusList = Arrays.asList(Integer.valueOf("40011"), Integer.valueOf("40012"), Integer.valueOf("40013"));
                List<DIqrQuotationPO> quoteList = this.dIqrQuotationMapper.selectByBidsectionIdDocStatusList(bidsectionPO.getBidsectionId(), statusList);
                if (!CollectionUtils.isEmpty(quoteList)) {
                    QuotationInfoVO vo = new QuotationInfoVO();
                    vo.setDocStatus(Integer.parseInt("40016"));
                    ArrayList<Long> quotationIds = new ArrayList<Long>();
                    for (DIqrQuotationPO dIqrQuotationPO : quoteList) {
                        quotationIds.add(dIqrQuotationPO.getQuotationId());
                        supplierIdList.add(dIqrQuotationPO.getSupplierId());
                    }
                    vo.setQuotationIds(quotationIds);
                    this.dIqrQuotationMapper.updateByQuotationIds(vo);
                }
                List<DIqrQuotationPO> allQuotationList = this.dIqrQuotationMapper.selectByBidsectionId(bidsectionPO.getBidsectionId());
                ArrayList<DIqrQuotationPO> updateQuotationList = new ArrayList<DIqrQuotationPO>();
                ArrayList<DIqrQuotationItemPO> updateQuotationItemList = new ArrayList<DIqrQuotationItemPO>();
                if (allQuotationList != null && allQuotationList.size() >= 0) {
                    for (Object dIqrQuotationPO : allQuotationList) {
                        if (!StringUtils.isNotEmpty((CharSequence)((DIqrQuotationPO)dIqrQuotationPO).getAmountSec())) continue;
                        Long amount = QuoteUtil.decode(((DIqrQuotationPO)dIqrQuotationPO).getAmountSec(), ((DIqrQuotationPO)dIqrQuotationPO).getQuotationId().toString());
                        DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
                        updateQuotationPO.setQuotationId(((DIqrQuotationPO)dIqrQuotationPO).getQuotationId());
                        updateQuotationPO.setAmountSec("");
                        updateQuotationPO.setAmount(amount);
                        updateQuotationList.add(updateQuotationPO);
                    }
                }
                if ((list = this.dIqrQuotationItemMapper.selectByBidsectionId(bidsectionPO.getBidsectionId())) != null && list.size() >= 0) {
                    Object dIqrQuotationPO;
                    dIqrQuotationPO = list.iterator();
                    while (dIqrQuotationPO.hasNext()) {
                        DIqrQuotationItemPO dIqrQuotationItemPO = (DIqrQuotationItemPO)dIqrQuotationPO.next();
                        if (StringUtils.isEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec()) && StringUtils.isEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) continue;
                        DIqrQuotationItemPO updateQuotationItemPO = new DIqrQuotationItemPO();
                        updateQuotationItemPO.setQuotationItemId(dIqrQuotationItemPO.getQuotationItemId());
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                            Long quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                            updateQuotationItemPO.setQuoteAmountSec("");
                            updateQuotationItemPO.setQuoteAmount(quoteAmount);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                            Long quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                            updateQuotationItemPO.setQuotePriceSec("");
                            updateQuotationItemPO.setQuotePrice(quotePrice);
                        }
                        updateQuotationItemList.add(updateQuotationItemPO);
                    }
                }
                if (!CollectionUtils.isEmpty(updateQuotationList)) {
                    this.dIqrQuotationMapper.updatePriceByIdList(updateQuotationList);
                }
                if (!CollectionUtils.isEmpty(updateQuotationItemList)) {
                    this.dIqrQuotationItemMapper.updatePriceByIdList(updateQuotationItemList);
                }
                DIqrInquiryBidsectionPO bidsectionUpdatePO = new DIqrInquiryBidsectionPO();
                bidsectionUpdatePO.setBidsectionId(bidsectionPO.getBidsectionId());
                bidsectionUpdatePO.setDocStatus(Integer.valueOf("2007"));
                this.dIqrInquiryBidsectionMapper.updateByPrimaryKeySelective(bidsectionUpdatePO);
                List<DIqrInquiryBidsectionPO> noEndBidsectionList = this.dIqrInquiryBidsectionMapper.queryNoEndBidsectionList(bidsectionPO.getInquiryId(), new Date());
                if (!CollectionUtils.isEmpty(noEndBidsectionList)) continue;
                DIqrInquiryMatePO dIqrInquiryMateUpdate = new DIqrInquiryMatePO();
                dIqrInquiryMateUpdate.setInquiryId(bidsectionPO.getInquiryId());
                dIqrInquiryMateUpdate.setDocStatus(Integer.valueOf("2007"));
                dIqrInquiryMateUpdate.setPublishTime(new Date());
                this.dIqrInquiryMateMapper.updateByInquiryId(dIqrInquiryMateUpdate);
                if (CollectionUtils.isEmpty(supplierIdList)) continue;
                this.updateStatus(supplierIdList, bidsectionPO.getInquiryId());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateStatus(Set<Long> supplierIdList, Long inquiryId) {
        log.info("\u5165\u53c2" + inquiryId + "\u4f9b\u5e94\u5546\uff1a" + supplierIdList);
        this.dIqrRegistDocMapper.updateStatusByInquiryIdAndSupplierList(new ArrayList<Long>(supplierIdList), inquiryId, Integer.valueOf("3004"));
    }
}

