/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.performlist.bo.ApproveRisunExceReqBO;
import com.tydic.enquiry.api.performlist.bo.ApproveRisunExceRspBO;
import com.tydic.enquiry.api.performlist.bo.ExecOrderStatusReqBO;
import com.tydic.enquiry.api.performlist.service.ApproveRisunExceOrderService;
import com.tydic.enquiry.api.performlist.service.UpExecOrderStatusService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.util.SendMsgUtil;
import com.tydic.osworkflow.engine.exception.OsworkflowDataException;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=ApproveRisunExceOrderService.class)
public class ApproveRisunExceOrderServiceImpl
implements ApproveRisunExceOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApproveRisunExceOrderServiceImpl.class);
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD")
    SeqIdCreateService seqIdCreateService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD")
    UpExecOrderStatusService upExecOrderStatusService;
    @Autowired(required=false)
    UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Value(value="${msg.center.url}")
    private String msgUrl;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;

    public ApproveRisunExceRspBO exceOrderApprove(ApproveRisunExceReqBO reqBO) {
        log.info("\u5165\u53c2ApproveRisunExceReqBO:" + reqBO.toString());
        ApproveRisunExceRspBO rspBO = new ApproveRisunExceRspBO();
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getApproveFlag())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5ba1\u6279\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
            if (null == dIqrInquiryMatePO) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u7ade\u4ef7\u5355\u4e3a\u7a7a\u6216\u8005\u7ade\u4ef7\u5355\u5ba1\u6279\u6d41\u7a0bID\u4e3a\u7a7a!");
                return rspBO;
            }
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            uacNoTaskAuditOrderAuditReqBO.setStepId(dIqrInquiryMatePO.getProcessInstId());
            uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getApproveOperId()));
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApproveComments());
            uacNoTaskAuditOrderAuditReqBO.setObjType(Integer.valueOf(111));
            if ("1".equals(reqBO.getApproveFlag())) {
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(0));
            } else {
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(1));
            }
            ArrayList<Long> objIdList = new ArrayList<Long>();
            objIdList.add(reqBO.getInquiryId());
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIdList);
            ExecOrderStatusReqBO execOrderStatusReqBO = new ExecOrderStatusReqBO();
            execOrderStatusReqBO.setInquiryId(reqBO.getInquiryId());
            String approveFlag = reqBO.getApproveFlag();
            if ("1".equals(approveFlag)) {
                if (Constants.PURCHASE_METHOD_INVITE.intValue() == dIqrInquiryMatePO.getPurchaseMethod().intValue()) {
                    execOrderStatusReqBO.setDocStatus(Integer.valueOf("2005"));
                    execOrderStatusReqBO.setNodeStatus("2005");
                } else {
                    execOrderStatusReqBO.setDocStatus(Integer.valueOf("2004"));
                    execOrderStatusReqBO.setNodeStatus("2004");
                }
            } else {
                execOrderStatusReqBO.setDocStatus(Integer.valueOf("2003"));
                execOrderStatusReqBO.setNodeStatus("2003");
            }
            execOrderStatusReqBO.setOperId(reqBO.getApproveOperId());
            execOrderStatusReqBO.setOperName(reqBO.getApproveOperName());
            execOrderStatusReqBO.setUpFlag("1");
            execOrderStatusReqBO.setProcessStatus(Integer.valueOf(2));
            this.upExecOrderStatusService.updateExecOrderStatus(execOrderStatusReqBO);
            this.insertOperLog(dIqrInquiryMatePO.getInquiryId(), "\u7ade\u4ef7\u5355\u5ba1\u6279", reqBO.getApproveOperId(), reqBO.getApproveOperName(), approveFlag);
            log.info("ApproveRisunExceOrderService:SendMsgUtil::dIqrInquiryMatePO.getPurchaseMethod()=" + dIqrInquiryMatePO.getPurchaseMethod());
            if ("1".equals(approveFlag) && Constants.PURCHASE_METHOD_INVITE.intValue() == dIqrInquiryMatePO.getPurchaseMethod().intValue()) {
                String phoneNumbers = null;
                List<DIqrRegistDocPO> dIqrRegistDocList = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(dIqrInquiryMatePO.getInquiryId());
                if (CollectionUtils.isNotEmpty(dIqrRegistDocList)) {
                    List phoneNumberList = dIqrRegistDocList.stream().map(DIqrRegistDocPO::getPhoneNumber).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(phoneNumberList)) {
                        phoneNumbers = StringUtils.join(phoneNumberList, (String)",");
                    }
                    log.info("ApproveRisunExceOrderService:SendMsgUtil::phoneNumbers=" + phoneNumbers);
                    if (StringUtils.isNotBlank((CharSequence)phoneNumbers)) {
                        String finalPhoneNumbers = phoneNumbers;
                        String noticeTitle = "\u9080\u8bf7\u60a8\u53c2\u4e0e\u7f16\u53f7\uff1a" + dIqrInquiryMatePO.getInquiryCode() + "\uff0c\u540d\u79f0\uff1a" + dIqrInquiryMatePO.getInquiryName() + "\u9879\u76ee\u62a5\u540d\u53ca\u7ade\u4ef7";
                        log.info("ApproveRisunExceOrderService:SendMsgUtil::noticeTitle=" + noticeTitle);
                        log.info("ApproveRisunExceOrderService:SendMsgUtil::dIqrInquiryMatePO.getPurchaseName()=" + dIqrInquiryMatePO.getPurchaseName());
                        new Thread(() -> SendMsgUtil.sendMsg(finalPhoneNumbers, noticeTitle, dIqrInquiryMatePO.getPurchaseName(), this.msgUrl)).start();
                    }
                }
            }
            rspBO.setDocId(dIqrInquiryMatePO.getInquiryId() + "");
            if (reqBO.getApproveDate() != null) {
                rspBO.setApproveDate(DateUtils.dateToStr((Date)reqBO.getApproveDate(), (String)"yyyyMMddHHmmss"));
            } else {
                rspBO.setApproveDate(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss"));
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7\u5355\u5ba1\u6279\u5f02\u5e38", (Throwable)e);
            if (e instanceof EnqBusinessException || e instanceof BusinessException || e instanceof OsworkflowDataException) {
                throw new EnqBusinessException("9999", e.getMessage());
            }
            throw new EnqBusinessException("9999", "\u7ade\u4ef7\u5355\u5ba1\u6279\u5f02\u5e38");
        }
        return rspBO;
    }

    private void insertOperLog(Long docId, String operLink, Long operUserId, String operUserName, String approveFlag) {
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("RISUN01");
        seqEnquiryReqBO.setSeqType("99");
        SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        cAllOperLogPO.setHisId(seqEnquiryPubRspBO.getDocId());
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        if ("1".equals(approveFlag)) {
            cAllOperLogPO.setOperBehavior("\u7ade\u4ef7\u5355\u5ba1\u6279\uff08\u901a\u8fc7\uff09");
        } else {
            cAllOperLogPO.setOperBehavior("\u7ade\u4ef7\u5355\u5ba1\u6279\uff08\u9a73\u56de\uff09");
        }
        cAllOperLogPO.setBusiStepId(2);
        cAllOperLogPO.setRemark("\u6210\u529f");
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }
}

