/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.performlist.bo.ChngQuotationRoundReqBO;
import com.tydic.enquiry.api.performlist.bo.ChngQuotationRoundRspBO;
import com.tydic.enquiry.api.performlist.service.ChngQuotationRoundService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=ChngQuotationRoundService.class)
public class ChngQuotationRoundServiceImpl
implements ChngQuotationRoundService {
    private static final Logger log = LoggerFactory.getLogger(ChngQuotationRoundServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    public ChngQuotationRoundRspBO chngQuotationRound(ChngQuotationRoundReqBO reqBO) {
        ChngQuotationRoundRspBO rspBO = new ChngQuotationRoundRspBO();
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(reqBO.getInquiryId());
        if (dIqrInquiryMatePO == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
            return rspBO;
        }
        log.error("\u6267\u884c\u5355\u6570\u636e :" + dIqrInquiryMatePO);
        if ("1".equals(dIqrInquiryMatePO.getBusiType()) && "22".equals(dIqrInquiryMatePO.getDocType())) {
            Date quoteEndDate = dIqrInquiryMatePO.getQuoteEndDate();
            Date nowDate = new Date();
            log.error("eq: " + "2003".equals(dIqrInquiryMatePO.getDocStatus().toString()));
            if (quoteEndDate.before(nowDate) || !"2003".equals(dIqrInquiryMatePO.getDocStatus().toString())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u5df2\u8fc7\u62a5\u4ef7\u65f6\u95f4\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7\uff01");
                return rspBO;
            }
            List<DIqrQuotationPO> quotationPOS = this.dIqrQuotationMapper.selectQuotationByInquiryId(reqBO.getInquiryId());
            if (CollectionUtils.isEmpty(quotationPOS)) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u672a\u6709\u5df2\u62a5\u4ef7\u7684\u6570\u636e\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u7c7b\u578b\u975e\u591a\u8f6e\u62a5\u4ef7\u4e0d\u53ef\u4ee5\u91cd\u65b0\u62a5\u4ef7\uff01");
            return rspBO;
        }
        this.dIqrQuotationMapper.updateTimeLimitByInquiryId(reqBO.getInquiryId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u91cd\u65b0\u62a5\u4ef7\u6210\u529f");
        return rspBO;
    }
}

