/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quoteFinish;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.quoteFinish.bo.RecoveryRisunQuoteReqBO;
import com.tydic.enquiry.api.quoteFinish.bo.RecoveryRisunQuoteRspBO;
import com.tydic.enquiry.api.quoteFinish.service.RecoveryRisunQuoteService;
import com.tydic.enquiry.api.registdoc.bo.UpMarginPayStatusReqBO;
import com.tydic.enquiry.api.registdoc.service.UpMarginPayStatusService;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.enquiry.vo.QuotationInfoVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=RecoveryRisunQuoteService.class)
public class RecoveryRisunQuoteServiceImpl
implements RecoveryRisunQuoteService {
    private static final Logger log = LoggerFactory.getLogger(RecoveryRisunQuoteServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD")
    UpMarginPayStatusService upMarginPayStatusService;

    public RecoveryRisunQuoteRspBO recoveryRisunQuote(RecoveryRisunQuoteReqBO reqBO) {
        RecoveryRisunQuoteRspBO rspBO = new RecoveryRisunQuoteRspBO();
        List<DIqrInquiryBidsectionPO> bidsectionPOList = this.dIqrInquiryBidsectionMapper.queryEndBidsectionList(Integer.parseInt("2006"), new Date());
        if (!CollectionUtils.isEmpty(bidsectionPOList)) {
            HashMap<Long, Integer> flowMarkMap = new HashMap<Long, Integer>();
            for (DIqrInquiryBidsectionPO bidsectionPO : bidsectionPOList) {
                List<DIqrQuotationItemPO> list;
                HashSet<Long> supplierIdList = new HashSet<Long>();
                List<DIqrQuotationPO> quotationPOS = this.dIqrQuotationMapper.selectByBidsectionIdDocStatus(bidsectionPO.getBidsectionId(), "40014");
                if (!CollectionUtils.isEmpty(quotationPOS)) {
                    QuotationInfoVO vo = new QuotationInfoVO();
                    vo.setDocStatus(Integer.valueOf("40015"));
                    vo.setNodeStatus(Integer.valueOf("41014"));
                    ArrayList<Long> quotationIds = new ArrayList<Long>();
                    for (DIqrQuotationPO quotationPO : quotationPOS) {
                        quotationIds.add(quotationPO.getQuotationId());
                        supplierIdList.add(quotationPO.getSupplierId());
                    }
                    vo.setQuotationIds(quotationIds);
                    this.dIqrQuotationMapper.updateByQuotationIds(vo);
                    DIqrInquiryBidsectionPO bidsectionUpdatePO = new DIqrInquiryBidsectionPO();
                    bidsectionUpdatePO.setBidsectionId(bidsectionPO.getBidsectionId());
                    bidsectionUpdatePO.setDocStatus(Integer.valueOf("2007"));
                    this.dIqrInquiryBidsectionMapper.updateByPrimaryKeySelective(bidsectionUpdatePO);
                    flowMarkMap.put(bidsectionPO.getInquiryId(), 0);
                } else {
                    int cntTemp = 0;
                    DIqrInquiryBidsectionPO bidsectionUpdatePO = new DIqrInquiryBidsectionPO();
                    bidsectionUpdatePO.setBidsectionId(bidsectionPO.getBidsectionId());
                    bidsectionUpdatePO.setDocStatus(Integer.valueOf("2011"));
                    this.dIqrInquiryBidsectionMapper.updateByPrimaryKeySelective(bidsectionUpdatePO);
                    cntTemp = flowMarkMap != null && !flowMarkMap.isEmpty() && flowMarkMap.containsKey(bidsectionPO.getInquiryId()) ? (Integer)flowMarkMap.get(bidsectionPO.getInquiryId()) + 1 : 1;
                    log.info("recoveryRisunQuote::\u6d41\u6807\u5904\u7406::bidsectionPO.getInquiryId()=" + bidsectionPO.getInquiryId() + ",cntTemp=" + cntTemp);
                    flowMarkMap.put(bidsectionPO.getInquiryId(), cntTemp);
                }
                List<Integer> statusList = Arrays.asList(Integer.valueOf("40011"), Integer.valueOf("40012"), Integer.valueOf("40013"));
                List<DIqrQuotationPO> quoteList = this.dIqrQuotationMapper.selectByBidsectionIdDocStatusList(bidsectionPO.getBidsectionId(), statusList);
                if (!CollectionUtils.isEmpty(quoteList)) {
                    QuotationInfoVO vo = new QuotationInfoVO();
                    vo.setDocStatus(Integer.parseInt("40016"));
                    ArrayList<Long> quotationIds = new ArrayList<Long>();
                    for (DIqrQuotationPO dIqrQuotationPO : quoteList) {
                        quotationIds.add(dIqrQuotationPO.getQuotationId());
                        supplierIdList.add(dIqrQuotationPO.getSupplierId());
                    }
                    vo.setQuotationIds(quotationIds);
                    this.dIqrQuotationMapper.updateByQuotationIds(vo);
                }
                List<DIqrQuotationPO> allQuotationList = this.dIqrQuotationMapper.selectByBidsectionId(bidsectionPO.getBidsectionId());
                ArrayList<DIqrQuotationPO> updateQuotationList = new ArrayList<DIqrQuotationPO>();
                ArrayList<DIqrQuotationItemPO> updateQuotationItemList = new ArrayList<DIqrQuotationItemPO>();
                if (allQuotationList != null && allQuotationList.size() >= 0) {
                    for (Object dIqrQuotationPO : allQuotationList) {
                        if (!StringUtils.isNotEmpty((CharSequence)((DIqrQuotationPO)dIqrQuotationPO).getAmountSec())) continue;
                        Long amount = QuoteUtil.decode(((DIqrQuotationPO)dIqrQuotationPO).getAmountSec(), ((DIqrQuotationPO)dIqrQuotationPO).getQuotationId().toString());
                        DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
                        updateQuotationPO.setQuotationId(((DIqrQuotationPO)dIqrQuotationPO).getQuotationId());
                        updateQuotationPO.setAmountSec("");
                        updateQuotationPO.setAmount(amount);
                        updateQuotationList.add(updateQuotationPO);
                    }
                }
                if ((list = this.dIqrQuotationItemMapper.selectByBidsectionId(bidsectionPO.getBidsectionId())) != null && list.size() >= 0) {
                    Object dIqrQuotationPO;
                    dIqrQuotationPO = list.iterator();
                    while (dIqrQuotationPO.hasNext()) {
                        DIqrQuotationItemPO dIqrQuotationItemPO = (DIqrQuotationItemPO)dIqrQuotationPO.next();
                        if (StringUtils.isEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec()) && StringUtils.isEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) continue;
                        DIqrQuotationItemPO updateQuotationItemPO = new DIqrQuotationItemPO();
                        updateQuotationItemPO.setQuotationItemId(dIqrQuotationItemPO.getQuotationItemId());
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                            Long quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                            updateQuotationItemPO.setQuoteAmountSec("");
                            updateQuotationItemPO.setQuoteAmount(quoteAmount);
                        }
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                            Long quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                            updateQuotationItemPO.setQuotePriceSec("");
                            updateQuotationItemPO.setQuotePrice(quotePrice);
                        }
                        updateQuotationItemList.add(updateQuotationItemPO);
                    }
                }
                if (!CollectionUtils.isEmpty(updateQuotationList)) {
                    this.dIqrQuotationMapper.updatePriceByIdList(updateQuotationList);
                }
                if (CollectionUtils.isEmpty(updateQuotationItemList)) continue;
                this.dIqrQuotationItemMapper.updatePriceByIdList(updateQuotationItemList);
            }
            if (flowMarkMap != null && !flowMarkMap.isEmpty()) {
                for (Long mapKey : flowMarkMap.keySet()) {
                    List<DIqrRegistDocPO> dIqrRegistDocList;
                    log.info("recoveryRisunQuote::flowMarkMap!=null::getInquiryId()=" + mapKey);
                    List<DIqrInquiryBidsectionPO> allBidsectionPOList = this.dIqrInquiryBidsectionMapper.selectByInquiryId(mapKey);
                    log.info("recoveryRisunQuote::flowMarkMap!=null::flowMarkMap.get(mapKey)=" + flowMarkMap.get(mapKey));
                    log.info("recoveryRisunQuote::flowMarkMap!=null::allBidsectionPOList.size()=" + allBidsectionPOList.size());
                    if (CollectionUtils.isEmpty(allBidsectionPOList)) continue;
                    String mateStatusTemp = "";
                    String mateNodeStatusTemp = "";
                    String registStatusTemp = "";
                    boolean updateFlag = false;
                    if (((Integer)flowMarkMap.get(mapKey)).intValue() == allBidsectionPOList.size()) {
                        log.info("recoveryRisunQuote::flowMarkMap.get(mapKey)==allBidsectionPOList.size()");
                        updateFlag = true;
                        mateStatusTemp = "2011";
                        mateNodeStatusTemp = "2105";
                        registStatusTemp = "3007";
                    } else {
                        log.info("recoveryRisunQuote::flowMarkMap.get(mapKey)!=allBidsectionPOList.size()");
                        List<DIqrInquiryBidsectionPO> noEndBidsectionList = this.dIqrInquiryBidsectionMapper.queryNoEndBidsectionList(mapKey, new Date());
                        if (CollectionUtils.isEmpty(noEndBidsectionList)) {
                            updateFlag = true;
                            mateStatusTemp = "2007";
                            mateNodeStatusTemp = "2107";
                            registStatusTemp = "3004";
                        }
                    }
                    log.info("recoveryRisunQuote::updateFlag=" + updateFlag);
                    if (!updateFlag || !CollectionUtils.isNotEmpty(dIqrRegistDocList = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(mapKey))) continue;
                    HashSet<Long> supplierIdList = new HashSet<Long>();
                    for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocList) {
                        supplierIdList.add(dIqrRegistDocPO.getSupplierId());
                        if (!"3007".equals(registStatusTemp) || !"2".equals(dIqrRegistDocPO.getPayStatus())) continue;
                        UpMarginPayStatusReqBO upMarginPayStatusReqBO = new UpMarginPayStatusReqBO();
                        upMarginPayStatusReqBO.setRegistId(dIqrRegistDocPO.getRegistId());
                        upMarginPayStatusReqBO.setSupplierId(dIqrRegistDocPO.getSupplierId());
                        upMarginPayStatusReqBO.setPayFlag("3");
                        this.upMarginPayStatusService.upMarginPayStatus(upMarginPayStatusReqBO);
                    }
                    DIqrInquiryMatePO dIqrInquiryMatePO = new DIqrInquiryMatePO();
                    dIqrInquiryMatePO.setDocStatus(Integer.valueOf(mateStatusTemp));
                    dIqrInquiryMatePO.setNodeStatus(Integer.valueOf(mateNodeStatusTemp));
                    dIqrInquiryMatePO.setInquiryId(mapKey);
                    this.dIqrInquiryMateMapper.updateByPrimaryKeySelective(dIqrInquiryMatePO);
                    if (CollectionUtils.isEmpty(supplierIdList)) continue;
                    this.updateStatus(supplierIdList, mapKey, registStatusTemp);
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateStatus(Set<Long> supplierIdList, Long inquiryId, String registStatus) {
        log.info("\u5165\u53c2" + inquiryId + "\u4f9b\u5e94\u5546\uff1a" + supplierIdList);
        this.dIqrRegistDocMapper.updateStatusByInquiryIdAndSupplierList(new ArrayList<Long>(supplierIdList), inquiryId, Integer.valueOf(registStatus));
    }
}

