/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.dealNotice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dealNotice.bo.DealNoticeInfoBO;
import com.tydic.enquiry.api.dealNotice.bo.QryDealNoticeListReqBO;
import com.tydic.enquiry.api.dealNotice.bo.QryDealNoticeListRspBO;
import com.tydic.enquiry.api.dealNotice.service.QryDealNoticeListService;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrDealNoticeMapper;
import com.tydic.enquiry.po.DIqrDealNoticePO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=QryDealNoticeListService.class)
public class QryDealNoticeListServiceImpl
implements QryDealNoticeListService {
    private static final Logger log = LoggerFactory.getLogger(QryDealNoticeListServiceImpl.class);
    @Autowired
    private DIqrDealNoticeMapper dIqrDealNoticeMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    public QryDealNoticeListRspBO qryDealNoticeList(QryDealNoticeListReqBO reqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aQryDealNoticeListReqBO=" + reqBO.toString());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        QryDealNoticeListRspBO rspBO = new QryDealNoticeListRspBO();
        List<DIqrDealNoticePO> dealNoticePOList = null;
        map.put("busiType", reqBO.getBusiType());
        map.put("confirmOperId", reqBO.getConfirmOperId());
        map.put("confirmOperNameLike", reqBO.getConfirmOperName());
        map.put("dealNoticeCode", reqBO.getDealNoticeCode());
        map.put("dealNoticeNameLike", reqBO.getDealNoticeNameLike());
        map.put("docStatus", reqBO.getDocStatus());
        map.put("purcharseId", reqBO.getPurcharseId());
        map.put("supplierId", reqBO.getSupplierId());
        Date billCreateTime = DateUtils.strToDateLong((String)reqBO.getBillCreateTime());
        map.put("billCreateTime", billCreateTime);
        log.info("billCreateTime=" + billCreateTime);
        Date supConfirmTime = DateUtils.strToDateLong((String)reqBO.getSupConfirmTime());
        map.put("supConfirmTime", supConfirmTime);
        log.info("supConfirmTime=" + supConfirmTime);
        map.put("validStatus", Constants.IS_VALID_Y);
        map.put("docType", reqBO.getDocType());
        map.put("dealNoticeIds", reqBO.getDealNoticeIds());
        map.put("confirmOperName", reqBO.getConfirmOperName());
        try {
            dealNoticePOList = this.dIqrDealNoticeMapper.queryDealNoticeForPage(map, (Page<DIqrDealNoticePO>)page);
        }
        catch (Exception e2) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc(e2.toString());
            log.error("\u5f02\u5e38\u4fe1\u606f\uff1ae=" + e2.toString());
            return rspBO;
        }
        log.info("queryInquiryMate end");
        List dealNoticeBOList = null;
        if (CollectionUtils.isNotEmpty(dealNoticePOList)) {
            log.info("dealNoticePOList.size()=" + dealNoticePOList.size());
            dealNoticeBOList = dealNoticePOList.stream().map(e -> {
                DealNoticeInfoBO dealNoticeInfoBO = new DealNoticeInfoBO();
                BeanUtils.copyProperties((Object)e, (Object)dealNoticeInfoBO);
                dealNoticeInfoBO.setInquiryId(e.getInquiryId().toString());
                dealNoticeInfoBO.setDealNoticeId(e.getDealNoticeId().toString());
                dealNoticeInfoBO.setQuotationId(e.getQuotationId().toString());
                if (e.getSupplierId() != null) {
                    dealNoticeInfoBO.setSupplierId(e.getSupplierId().toString());
                }
                if (e.getBillCreateUserId() != null) {
                    dealNoticeInfoBO.setBillCreateUserId(e.getBillCreateUserId().toString());
                }
                if (e.getPurchaseAccountId() != null) {
                    dealNoticeInfoBO.setPurchaseAccountId(e.getPurchaseAccountId().toString());
                }
                if (e.getPurchaseId() != null) {
                    dealNoticeInfoBO.setPurchaseId(e.getPurchaseId().toString());
                }
                if (e.getPlanId() != null) {
                    dealNoticeInfoBO.setPlanId(e.getPlanId().toString());
                }
                if (e.getConfirmOrgId() != null) {
                    dealNoticeInfoBO.setConfirmOrgId(e.getConfirmOrgId().toString());
                }
                try {
                    dealNoticeInfoBO.setFinalTotalAmount(MoneyUtils.Long2BigDecimal((Long)e.getFinalTotalAmount()));
                    dealNoticeInfoBO.setPurchaseAmount(MoneyUtils.Long2BigDecimal((Long)e.getPurchaseAmount()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                dealNoticeInfoBO.setBillCreateTime(DateUtils.dateToStr((Date)e.getBillCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                dealNoticeInfoBO.setSupConfirmTime(DateUtils.dateToStr((Date)e.getSupConfirmTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                dealNoticeInfoBO.setDocStatusDesc(this.qryDicAtomService.getDicCodeName("DNOTICE_DOC_STATUS", e.getDocStatus() + ""));
                dealNoticeInfoBO.setBusiTypeDesc(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", e.getBusiType() + ""));
                dealNoticeInfoBO.setDocTypeDesc(this.qryDicAtomService.getDicCodeName("DOC_TYPE", e.getDocType() + ""));
                dealNoticeInfoBO.setDeliveryMethodDesc(this.qryDicAtomService.getDicCodeName("DELIVERY_METHOD", e.getDeliveryMethod() + ""));
                dealNoticeInfoBO.setDisposalMethodDesc(this.qryDicAtomService.getDicCodeName("DISPOSAL_METHOD", e.getDisposalMethod() + ""));
                dealNoticeInfoBO.setSupConfirmEndTime(DateUtils.dateToStr((Date)e.getSupConfirmEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                return dealNoticeInfoBO;
            }).collect(Collectors.toList());
        }
        log.info("execOrderInfoBOList\u8d4b\u503c\u5b8c\u6210");
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(dealNoticeBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

