/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.QryQuotationPkgHistoryListReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationPkgHistoryListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationPackageBO;
import com.tydic.enquiry.api.quote.service.QryQuotationPkgHistoryListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryMateItemPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=QryQuotationPkgHistoryListService.class)
public class QryQuotationPkgHistoryListServiceImpl
implements QryQuotationPkgHistoryListService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationPkgHistoryListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;

    public QryQuotationPkgHistoryListRspBO qryQuotationPkgHistoryList(QryQuotationPkgHistoryListReqBO reqBO) {
        QryQuotationPkgHistoryListRspBO rspBO = new QryQuotationPkgHistoryListRspBO();
        ArrayList<QuotationPackageBO> quotePackageList = new ArrayList<QuotationPackageBO>();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
        if (dIqrInquiryMatePO == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrInquiryMateItemPO dIqrInquiryMateItemPO = this.dIqrInquiryMateItemMapper.selectByPrimaryKey(reqBO.getInquiryPkgId());
        if (dIqrInquiryMateItemPO == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u5305\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("4002"));
        docStatusList.add(Integer.valueOf("4004"));
        docStatusList.add(Integer.valueOf("4006"));
        dIqrQuotationPkgPO.setInquiryId(reqBO.getInquiryId());
        dIqrQuotationPkgPO.setInquiryPkgId(reqBO.getInquiryPkgId());
        dIqrQuotationPkgPO.setValidStatus(Constants.IS_VALID_Y);
        dIqrQuotationPkgPO.setHisStatus("1");
        dIqrQuotationPkgPO.setDocStatusList(docStatusList);
        dIqrQuotationPkgPO.setOrderBy("QUOTATION_SUBMIT_TIME DESC");
        List<DIqrQuotationPkgPO> dIqrQuotationPkgPOList = this.dIqrQuotationPkgMapper.selectByInquiryPkgId(dIqrQuotationPkgPO);
        if (CollectionUtils.isEmpty(dIqrQuotationPkgPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u5305\u6682\u65e0\u62a5\u4ef7");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        Long quotationPkgLowestAmount = dIqrQuotationPkgPOList.get(0).getAmount();
        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPkgPOList.get(0).getAmountSec())) {
            quotationPkgLowestAmount = QuoteUtil.decode(dIqrQuotationPkgPOList.get(0).getAmountSec(), dIqrQuotationPkgPOList.get(0).getQuotationId().toString());
        }
        String quotationLowestPkgId = dIqrQuotationPkgPOList.get(0).getQuotationPkgId();
        Long quotationPkgHighestAmount = dIqrQuotationPkgPOList.get(0).getAmount();
        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPkgPOList.get(0).getAmountSec())) {
            quotationPkgHighestAmount = QuoteUtil.decode(dIqrQuotationPkgPOList.get(0).getAmountSec(), dIqrQuotationPkgPOList.get(0).getQuotationId().toString());
        }
        String quotationHighestPkgId = dIqrQuotationPkgPOList.get(0).getQuotationPkgId();
        for (DIqrQuotationPkgPO quotationPkgPO : dIqrQuotationPkgPOList) {
            Long amount = quotationPkgPO.getAmount();
            if (StringUtils.isNotEmpty((CharSequence)quotationPkgPO.getAmountSec())) {
                amount = QuoteUtil.decode(quotationPkgPO.getAmountSec(), quotationPkgPO.getQuotationId().toString());
            }
            quotationPkgPO.setAmount(amount);
            if (quotationPkgLowestAmount > amount) {
                quotationPkgLowestAmount = amount;
                quotationLowestPkgId = quotationPkgPO.getQuotationPkgId();
            }
            if (quotationPkgHighestAmount >= amount) continue;
            quotationPkgHighestAmount = amount;
            quotationHighestPkgId = quotationPkgPO.getQuotationPkgId();
        }
        DIqrQuotationPO quotationPO = new DIqrQuotationPO();
        quotationPO.setInquiryId(reqBO.getInquiryId());
        quotationPO.setValidStatus(Constants.IS_VALID_Y);
        quotationPO.setHisStatus("1");
        quotationPO.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> effectiveQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(quotationPO);
        if (CollectionUtils.isEmpty(effectiveQuotationPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        HashMap<Long, DIqrQuotationPO> effectiveQuotationPOMap = new HashMap<Long, DIqrQuotationPO>();
        for (DIqrQuotationPO dIqrQuotationPO : effectiveQuotationPOList) {
            effectiveQuotationPOMap.put(dIqrQuotationPO.getQuotationId(), dIqrQuotationPO);
        }
        for (DIqrQuotationPkgPO quotationPkgPO : dIqrQuotationPkgPOList) {
            QuotationPackageBO quotationPackageBO = new QuotationPackageBO();
            DIqrQuotationPO dIqrQuotationPO = (DIqrQuotationPO)effectiveQuotationPOMap.get(quotationPkgPO.getQuotationId());
            quotationPackageBO.setInquiryId(dIqrInquiryMateItemPO.getInquiryId());
            quotationPackageBO.setInquiryPkgId(dIqrInquiryMateItemPO.getInquiryPkgId());
            quotationPackageBO.setPkgOrderNo(dIqrInquiryMateItemPO.getInquiryPkgId());
            quotationPackageBO.setDetailNum(dIqrInquiryMateItemPO.getDetailNum());
            quotationPackageBO.setQuotationId(quotationPkgPO.getQuotationId());
            if ("Y".equals(reqBO.getIsSupplier()) && reqBO.getSupplierId() != null && dIqrQuotationPO != null && dIqrQuotationPO.getSupplierId().longValue() == reqBO.getSupplierId().longValue()) {
                quotationPackageBO.setSupplierId(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierId() : null);
                quotationPackageBO.setSupplierName(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierName() : null);
            } else if ("Y".equals(reqBO.getIsSupplier())) {
                quotationPackageBO.setSupplierId(null);
                quotationPackageBO.setSupplierName("****");
            } else if (dIqrInquiryMatePO != null && dIqrInquiryMatePO.getDocStatus() != null && "2003".equals(dIqrInquiryMatePO.getDocStatus().toString())) {
                quotationPackageBO.setSupplierId(null);
                quotationPackageBO.setSupplierName("****");
            } else {
                quotationPackageBO.setSupplierId(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierId() : null);
                quotationPackageBO.setSupplierName(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierName() : null);
            }
            quotationPackageBO.setQuoteIpAddr(dIqrQuotationPO.getQuoteIpAddr());
            quotationPackageBO.setPkgCreateDate(DateUtils.dateToStr((Date)dIqrInquiryMateItemPO.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationPackageBO.setQuotationSubmitTime(dIqrQuotationPO != null ? DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
            if ("2".equals(dIqrInquiryMatePO.getBusiType()) && quotationPkgPO.getQuotationPkgId().equals(quotationHighestPkgId)) {
                quotationPackageBO.setQuotationStatus(Integer.valueOf(1));
                quotationPackageBO.setQuotationStatusName("\u9886\u5148");
            } else if (quotationPkgPO.getQuotationPkgId().equals(quotationLowestPkgId)) {
                quotationPackageBO.setQuotationStatus(Integer.valueOf(1));
                quotationPackageBO.setQuotationStatusName("\u9886\u5148");
            } else {
                quotationPackageBO.setQuotationStatus(Integer.valueOf(2));
                quotationPackageBO.setQuotationStatusName("\u51fa\u5c40");
            }
            try {
                quotationPackageBO.setPkgTotalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryMateItemPO.getPkgTotalAmount()));
                quotationPackageBO.setMostQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                quotationPackageBO.setAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                quotationPackageBO.setHighestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                quotationPackageBO.setLastTimeQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
            }
            quotePackageList.add(quotationPackageBO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u5305\u62a5\u4ef7\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        rspBO.setPackageList(quotePackageList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

