/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.dealNotice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dealNotice.bo.DealNoticeInfoBO;
import com.tydic.enquiry.api.dealNotice.bo.DealNoticeItemInfoBO;
import com.tydic.enquiry.api.dealNotice.bo.QryDealNoticeByIdReqBO;
import com.tydic.enquiry.api.dealNotice.bo.QryDealNoticeByIdRspBO;
import com.tydic.enquiry.api.dealNotice.bo.SummaryInfoBO;
import com.tydic.enquiry.api.dealNotice.service.QryDealNoticeByIdService;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.dao.DIqrDealNoticeItemMapper;
import com.tydic.enquiry.dao.DIqrDealNoticeMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrDealNoticePO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.RedisUtils;
import com.tydic.enquiry.vo.DealNoticeItemInfoVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=QryDealNoticeByIdService.class)
public class QryDealNoticeByIdServiceImpl
implements QryDealNoticeByIdService {
    private static final Logger log = LoggerFactory.getLogger(QryDealNoticeByIdServiceImpl.class);
    @Autowired
    private DIqrDealNoticeMapper dIqrDealNoticeMapper;
    @Autowired
    private DIqrDealNoticeItemMapper dIqrDealNoticeItemMapper;
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    private RedisUtils redisUtils;

    public QryDealNoticeByIdRspBO qryDealNoticeById(QryDealNoticeByIdReqBO reqBO) {
        QryDealNoticeByIdRspBO rspBO = new QryDealNoticeByIdRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<Object> itemList = new ArrayList();
        List<Object> itemInfoBOS = new ArrayList();
        DealNoticeInfoBO dealNoticeInfo = new DealNoticeInfoBO();
        SummaryInfoBO summaryInfo = new SummaryInfoBO();
        String quoteEndDate = "";
        try {
            DIqrDealNoticePO dIqrDealNoticePO = this.dIqrDealNoticeMapper.selectByPrimaryKey(reqBO.getDealNoticeId());
            log.error("dIqrDealNoticePO\u6210\u4ea4\u901a\u77e5\u4e66\u4fe1\u606f\uff1a==" + dIqrDealNoticePO.toString());
            BeanUtils.copyProperties((Object)dIqrDealNoticePO, (Object)dealNoticeInfo);
            dealNoticeInfo.setInquiryId(dIqrDealNoticePO.getInquiryId().toString());
            dealNoticeInfo.setDealNoticeId(dIqrDealNoticePO.getDealNoticeId().toString());
            dealNoticeInfo.setQuotationId(dIqrDealNoticePO.getQuotationId().toString());
            if (dIqrDealNoticePO.getBillCreateUserId() != null) {
                dealNoticeInfo.setBillCreateUserId(dIqrDealNoticePO.getBillCreateUserId().toString());
            }
            if (dIqrDealNoticePO.getPurchaseAccountId() != null) {
                dealNoticeInfo.setPurchaseAccountId(dIqrDealNoticePO.getPurchaseAccountId().toString());
            }
            if (dIqrDealNoticePO.getPurchaseId() != null) {
                dealNoticeInfo.setPurchaseId(dIqrDealNoticePO.getPurchaseId().toString());
            }
            if (dIqrDealNoticePO.getPlanId() != null) {
                dealNoticeInfo.setPlanId(dIqrDealNoticePO.getPlanId().toString());
            }
            if (dIqrDealNoticePO.getSupplierId() != null) {
                dealNoticeInfo.setSupplierId(dIqrDealNoticePO.getSupplierId().toString());
            }
            if (dIqrDealNoticePO.getConfirmOrgId() != null) {
                dealNoticeInfo.setConfirmOrgId(dIqrDealNoticePO.getConfirmOrgId().toString());
            }
            try {
                dealNoticeInfo.setFinalTotalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrDealNoticePO.getFinalTotalAmount()));
                dealNoticeInfo.setPurchaseAmount(MoneyUtils.Long2BigDecimal((Long)dIqrDealNoticePO.getPurchaseAmount()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            dealNoticeInfo.setDocStatusDesc(this.qryDicAtomService.getDicCodeName("DNOTICE_DOC_STATUS", dIqrDealNoticePO.getDocStatus() + ""));
            dealNoticeInfo.setBusiTypeDesc(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", dIqrDealNoticePO.getBusiType() + ""));
            dealNoticeInfo.setDocTypeDesc(this.qryDicAtomService.getDicCodeName("DOC_TYPE", dIqrDealNoticePO.getDocType() + ""));
            dealNoticeInfo.setDeliveryMethodDesc(this.qryDicAtomService.getDicCodeName("DELIVERY_METHOD", dIqrDealNoticePO.getDeliveryMethod() + ""));
            dealNoticeInfo.setDisposalMethodDesc(this.qryDicAtomService.getDicCodeName("DISPOSAL_METHOD", dIqrDealNoticePO.getDisposalMethod() + ""));
            dealNoticeInfo.setSupConfirmTime(DateUtils.dateToStr((Date)dIqrDealNoticePO.getSupConfirmTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            dealNoticeInfo.setBillCreateTime(DateUtils.dateToStr((Date)dIqrDealNoticePO.getBillCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            dealNoticeInfo.setSupConfirmEndTime(DateUtils.dateToStr((Date)dIqrDealNoticePO.getSupConfirmEndTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(dIqrDealNoticePO.getInquiryId());
            dealNoticeInfo.setContactCountryId(inquiryMatePO.getContactCountryId());
            dealNoticeInfo.setContactCountryName(inquiryMatePO.getContactCountryName());
            dealNoticeInfo.setContactProvinceId(inquiryMatePO.getContactProvinceId());
            dealNoticeInfo.setContactProvinceName(inquiryMatePO.getContactProvinceName());
            dealNoticeInfo.setContactCityId(inquiryMatePO.getContactCityId());
            dealNoticeInfo.setContactCityName(inquiryMatePO.getContactCityName());
            dealNoticeInfo.setContactCountyId(inquiryMatePO.getContactCountyId());
            dealNoticeInfo.setContactCountyName(inquiryMatePO.getContactCountyName());
            dealNoticeInfo.setContactTownId(inquiryMatePO.getContactTownId());
            dealNoticeInfo.setContactTown(inquiryMatePO.getContactTown());
            dealNoticeInfo.setTotalPriceFlag(inquiryMatePO.getTotalPriceFlag());
            dealNoticeInfo.setTotalPriceFlagDesc(this.qryDicAtomService.getDicCodeName("TOTAL_PRICE_FLAG", inquiryMatePO.getTotalPriceFlag()));
            log.error("dealNoticeInfo\u6210\u4ea4\u901a\u77e5\u4e66\u4fe1\u606f\uff1a==" + dealNoticeInfo.toString());
            itemList = this.dIqrDealNoticeItemMapper.selectByDealNoticeId(reqBO.getDealNoticeId(), (Page<DealNoticeItemInfoVO>)page);
            AtomicInteger detailNum = new AtomicInteger(0);
            AtomicLong amount = new AtomicLong(0L);
            if (CollectionUtils.isNotEmpty(itemList)) {
                if (inquiryMatePO.getQuoteEndDate() != null) {
                    quoteEndDate = DateUtils.dateToStr((Date)new Date(inquiryMatePO.getQuoteEndDate().getTime() + 86400000L), (String)"yyyy-MM-dd") + "\u524d";
                }
                String finalQuoteEndDate = quoteEndDate;
                itemInfoBOS = itemList.stream().map(e -> {
                    DealNoticeItemInfoBO dealNoticeInfoBO = new DealNoticeItemInfoBO();
                    BeanUtils.copyProperties((Object)e, (Object)dealNoticeInfoBO);
                    dealNoticeInfoBO.setQuoteEndDate(finalQuoteEndDate);
                    dealNoticeInfoBO.setQuotationId(e.getQuotationId().toString());
                    dealNoticeInfoBO.setSupplierId(e.getSupplierId().toString());
                    dealNoticeInfoBO.setDealNoticeId(e.getDealNoticeId().toString());
                    dealNoticeInfoBO.setInquiryItemId(e.getInquiryItemId().toString());
                    dealNoticeInfoBO.setQuotationItemId(e.getQuotationItemId().toString());
                    dealNoticeInfoBO.setDealNoticeItemId(e.getDealNoticeItemId().toString());
                    log.error("\u7f13\u5b58\u6570\u636e\uff1a" + e);
                    try {
                        dealNoticeInfoBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)e.getBudgetAmount()));
                        dealNoticeInfoBO.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)e.getQuoteAmount()));
                        dealNoticeInfoBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)e.getBudgetPrice()));
                        dealNoticeInfoBO.setQuotePrice(MoneyUtils.Long2BigDecimal((Long)e.getQuotePrice()));
                        dealNoticeInfoBO.setPurcharseNum(MoneyUtils.Long2BigDecimal((Long)e.getPurcharseNum()));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    dealNoticeInfoBO.setQuotationCreateTime(DateUtils.dateToStr((Date)e.getQuotationCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    dealNoticeInfoBO.setDeliveryDatePromise(DateUtils.dateToStr((Date)e.getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
                    dealNoticeInfoBO.setMaterialClassIdStr(this.qryDicAtomService.getDicCodeName("MATERIAL_CLASS_ID", e.getMaterialClassId() + ""));
                    dealNoticeInfoBO.setDocStatusDesc(this.qryDicAtomService.getDicCodeName("INQDT_DOC_STATUS", e.getDocStatus() + ""));
                    detailNum.getAndIncrement();
                    if (e.getQuoteAmount() != null) {
                        amount.addAndGet(e.getQuoteAmount());
                    }
                    return dealNoticeInfoBO;
                }).collect(Collectors.toList());
            }
            DIqrQuotationPO dIqrQuotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(dIqrDealNoticePO.getQuotationId());
            BeanUtils.copyProperties((Object)dIqrQuotationPO, (Object)summaryInfo);
            summaryInfo.setQuotationId(dIqrQuotationPO.getQuotationId().toString());
            summaryInfo.setSupplierId(dIqrQuotationPO.getSupplierId().toString());
            summaryInfo.setQuoteEndDate(quoteEndDate);
            if ("2".equals(dIqrQuotationPO.getQuoteMethod().toString())) {
                summaryInfo.setQuoteDetailNum(Integer.valueOf(detailNum.get()));
                summaryInfo.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)amount.get()));
            } else {
                summaryInfo.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationPO.getAmount()));
                summaryInfo.setQuoteDetailNum(dIqrQuotationPO.getQuoteDetailNum());
            }
            summaryInfo.setDealNoticeId(reqBO.getDealNoticeId().toString());
            summaryInfo.setQuoteMethodDesc(this.qryDicAtomService.getDicCodeName("QUOTE_METHOD", dIqrQuotationPO.getQuoteMethod() + ""));
            summaryInfo.setSupplierClassIdDesc(this.qryDicAtomService.getDicCodeName("SUPPLIER_CLASS_ID", dIqrQuotationPO.getSupplierClassId() + ""));
            summaryInfo.setBillCreateTime(dealNoticeInfo.getBillCreateTime());
            summaryInfo.setSupConfirmTime(dealNoticeInfo.getSupConfirmTime());
            summaryInfo.setQuotationCreateTime(DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            summaryInfo.setDeliveryDatePromise(DateUtils.dateToStr((Date)dIqrQuotationPO.getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setRows(itemInfoBOS);
            rspBO.setRedisNo(reqBO.getDealNoticeId() + "");
            rspBO.setDealNoticeInfo(dealNoticeInfo);
            rspBO.setSummaryInfo(summaryInfo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        }
        catch (Exception e2) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u67e5\u8be2\u5931\u8d25");
            e2.printStackTrace();
            return rspBO;
        }
        return rspBO;
    }
}

