/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.user.bo.QueryUserReqBO;
import com.tydic.enquiry.api.user.bo.QueryUserRspBO;
import com.tydic.enquiry.api.user.service.QueryUserListService;
import com.tydic.enquiry.dao.UserMapper;
import com.tydic.enquiry.po.UserPO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_PROD", serviceInterface=QueryUserListService.class)
public class QueryUserListServiceImpl
implements QueryUserListService {
    private static final Logger log = LoggerFactory.getLogger(QueryUserListServiceImpl.class);
    @Autowired
    private UserMapper userMapper;

    public RspPage<QueryUserRspBO> selectRoleInfo(QueryUserReqBO queryUserReqBO) {
        Page page = new Page(queryUserReqBO.getPageNo(), queryUserReqBO.getPageSize());
        List<UserPO> userList = this.userMapper.queryUserPageList(queryUserReqBO.getUserName(), page);
        RspPage rspPage = new RspPage();
        if (userList != null && userList.size() > 0) {
            List userRspBOS = userList.stream().map(userPO -> {
                QueryUserRspBO rspBO = new QueryUserRspBO();
                BeanUtils.copyProperties((Object)userPO, (Object)rspBO);
                return rspBO;
            }).collect(Collectors.toList());
            rspPage.setPageNo(queryUserReqBO.getPageNo());
            rspPage.setRows(userRspBOS);
            rspPage.setTotal(page.getTotalPages());
            rspPage.setRecordsTotal(page.getTotalCount());
        }
        return rspPage;
    }
}

