/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.performlist.bo.InquiryAttachmentBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationAttachmentBO;
import com.tydic.enquiry.api.quote.bo.QuotationBillBO;
import com.tydic.enquiry.api.quote.bo.QuotationPackageBO;
import com.tydic.enquiry.api.quote.bo.QuoteExecOrderDetailBO;
import com.tydic.enquiry.api.quote.bo.QuoteInquiryDealInfoBO;
import com.tydic.enquiry.api.quote.bo.QuoteRequireInfoBO;
import com.tydic.enquiry.api.quote.service.QryQuotationBillService;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationAttachMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMidMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.dao.DPlanMaterialMapper;
import com.tydic.enquiry.dao.RPlanAttachmentInfoMapper;
import com.tydic.enquiry.po.DIqrInquiryMateItemPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationAttachPO;
import com.tydic.enquiry.po.DIqrQuotationItemMidPO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.po.DPlanMaterialPO;
import com.tydic.enquiry.po.RPlanAttachmentInfoPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP_TEST/1.0.0/com.tydic.enquiry.api.quote.service.QryQuotationBillService"})
public class QryQuotationBillServiceImpl
implements QryQuotationBillService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationBillServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrQuotationItemMidMapper dIqrQuotationItemMidMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    private RPlanAttachmentInfoMapper rPlanAttachmentInfoMapper;
    @Autowired
    private DPlanMaterialMapper dPlanMaterialMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;
    @Autowired
    private DIqrQuotationAttachMapper dIqrQuotationAttachMapper;

    @PostMapping(value={"qryQuotationBillById"})
    public QryQuotationBillRspBO qryQuotationBillById(@RequestBody QryQuotationBillReqBO reqBO) {
        QryQuotationBillRspBO rspBO = new QryQuotationBillRspBO();
        DIqrQuotationPO dIqrQuotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(dIqrQuotationPO.getInquiryId());
        if (dIqrQuotationPO != null) {
            QuotationBillBO quotationBillInfo = new QuotationBillBO();
            BeanUtils.copyProperties((Object)dIqrQuotationPO, (Object)quotationBillInfo);
            try {
                quotationBillInfo.setAmount(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationPO.getAmount()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            quotationBillInfo.setQuotationCreateTime(DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationBillInfo.setQuotationSubmitTime(DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationBillInfo.setBusiTypeName(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", dIqrQuotationPO.getBusiType() + ""));
            quotationBillInfo.setDocTypeName(this.qryDicAtomService.getDicCodeName("DOC_TYPE", dIqrQuotationPO.getDocType() + ""));
            List<DIqrQuotationAttachPO> dIqrQuotationAttachPOList = this.dIqrQuotationAttachMapper.selectAttachByQuotationId(reqBO.getQuotationId(), null);
            ArrayList<QuotationAttachmentBO> quoteAttachmentInfoList = new ArrayList<QuotationAttachmentBO>();
            QuotationAttachmentBO quotationAttachmentBO = new QuotationAttachmentBO();
            if (CollectionUtils.isNotEmpty(dIqrQuotationAttachPOList)) {
                for (DIqrQuotationAttachPO dIqrQuotationAttachPO : dIqrQuotationAttachPOList) {
                    BeanUtils.copyProperties((Object)dIqrQuotationAttachPO, (Object)quotationAttachmentBO);
                    quotationAttachmentBO.setAttachmentId(dIqrQuotationAttachPO.getQuotationAttachmentId());
                    quotationAttachmentBO.setAttachmentName(dIqrQuotationAttachPO.getAttachmentName());
                    quotationAttachmentBO.setAttachmentBusiType(dIqrQuotationAttachPO.getAttachmentType());
                    quotationAttachmentBO.setAttachmentUrl(dIqrQuotationAttachPO.getAttachmentUrl());
                    quotationAttachmentBO.setOssPath(dIqrQuotationAttachPO.getOssPath());
                    quoteAttachmentInfoList.add(quotationAttachmentBO);
                }
                quotationBillInfo.setQuoteAttachmentInfoList(quoteAttachmentInfoList);
            }
            if (reqBO.getSelectType() != null && reqBO.getSelectType() == 2 && dIqrInquiryMatePO.getDocType() != null && "22".equals(dIqrInquiryMatePO.getDocType())) {
                quotationBillInfo.setQuoteRounds(quotationBillInfo.getQuoteTimeLimit() == null ? "1" : quotationBillInfo.getQuoteTimeLimit().toString());
            }
            if (reqBO.getSelectType() != null && reqBO.getSelectType() == 2 && dIqrInquiryMatePO.getDocType() != null && !"22".equals(dIqrInquiryMatePO.getDocType())) {
                Integer quoteRounds = quotationBillInfo.getQuoteRounds() == null ? 1 : Integer.valueOf(quotationBillInfo.getQuoteRounds()) + 1;
                quotationBillInfo.setQuoteRounds(quoteRounds.toString());
            }
            rspBO.setQuotationBillInfo(quotationBillInfo);
        }
        QuoteExecOrderDetailBO execOrderDetailBO = new QuoteExecOrderDetailBO();
        QuoteRequireInfoBO requireInfoBO = new QuoteRequireInfoBO();
        if (dIqrInquiryMatePO != null) {
            BeanUtils.copyProperties((Object)dIqrInquiryMatePO, (Object)execOrderDetailBO);
            execOrderDetailBO.setCreateDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (dIqrInquiryMatePO.getRegistBeginDate() != null) {
                execOrderDetailBO.setRegistBeginDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (dIqrInquiryMatePO.getRegistEndDate() != null) {
                execOrderDetailBO.setRegistEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (dIqrInquiryMatePO.getLimitQuoteDate() != null) {
                execOrderDetailBO.setLimitQuoteDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (dIqrInquiryMatePO.getQuoteEndDate() != null) {
                execOrderDetailBO.setQuoteEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            execOrderDetailBO.setBusiTypeName(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", execOrderDetailBO.getBusiType() + ""));
            execOrderDetailBO.setTotalPriceFlagName(this.qryDicAtomService.getDicCodeName("TOTAL_PRICE_FLAG", execOrderDetailBO.getTotalPriceFlag() + ""));
            execOrderDetailBO.setMarginFlagName(this.qryDicAtomService.getDicCodeName("MARGIN_FLAG", execOrderDetailBO.getMarginFlag() + ""));
            execOrderDetailBO.setOfferIncreaseTypeName(this.qryDicAtomService.getDicCodeName("OFFER_INCREASE_TYPE", execOrderDetailBO.getOfferIncreaseType() + ""));
            execOrderDetailBO.setComparedQuoteTypeName(this.qryDicAtomService.getDicCodeName("COMPARED_QUOTE_TYPE", execOrderDetailBO.getComparedQuoteType() + ""));
            execOrderDetailBO.setDelayBiddingFlagName(this.qryDicAtomService.getDicCodeName("DELAY_BIDDING_FLAG", execOrderDetailBO.getDelayBiddingFlag() + ""));
            execOrderDetailBO.setIsBudgetAnnounceName(this.qryDicAtomService.getDicCodeName("IS_BUDGET_ANNOUNCE", execOrderDetailBO.getIsBudgetAnnounce() + ""));
            execOrderDetailBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("INQ_DOC_STATUS", execOrderDetailBO.getDocStatus() + ""));
            execOrderDetailBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", execOrderDetailBO.getPurchaseMethod() + ""));
            execOrderDetailBO.setQuoteMethodName(this.qryDicAtomService.getDicCodeName("QUOTE_METHOD", execOrderDetailBO.getQuoteMethod() + ""));
            execOrderDetailBO.setCurrencyTypeName(this.qryDicAtomService.getDicCodeName("CURRENCY_TYPE", execOrderDetailBO.getCurrencyType() + ""));
            List<RPlanAttachmentInfoPO> inquiryAttachInfoList = this.rPlanAttachmentInfoMapper.selectAttachByInquiryId(dIqrInquiryMatePO.getInquiryId());
            ArrayList<InquiryAttachmentBO> inquiryAttachmentBOList = new ArrayList<InquiryAttachmentBO>();
            InquiryAttachmentBO inquiryAttachmentBO = new InquiryAttachmentBO();
            if (CollectionUtils.isNotEmpty(inquiryAttachInfoList)) {
                for (RPlanAttachmentInfoPO po : inquiryAttachInfoList) {
                    BeanUtils.copyProperties((Object)po, (Object)inquiryAttachmentBO);
                    inquiryAttachmentBO.setInquiryAttachmentId(po.getAttachmentId());
                    inquiryAttachmentBOList.add(inquiryAttachmentBO);
                }
                execOrderDetailBO.setInquiryAttachmentInfoList(inquiryAttachmentBOList);
            }
            if ("2".equals(dIqrInquiryMatePO.getBusiType())) {
                QuoteInquiryDealInfoBO quoteInquiryDealInfoBO = new QuoteInquiryDealInfoBO();
                quoteInquiryDealInfoBO.setDeliveryMethod(dIqrInquiryMatePO.getDeliveryMethod());
                quoteInquiryDealInfoBO.setDeliveryMethodName(this.qryDicAtomService.getDicCodeName("DELIVERY_METHOD", dIqrInquiryMatePO.getDeliveryMethod()));
                quoteInquiryDealInfoBO.setDisposalMethod(dIqrInquiryMatePO.getDisposalMethod());
                quoteInquiryDealInfoBO.setDisposalMethodName(this.qryDicAtomService.getDicCodeName("DISPOSAL_METHOD", dIqrInquiryMatePO.getDisposalMethod()));
                quoteInquiryDealInfoBO.setShippingAddr(dIqrInquiryMatePO.getShippingAddr());
                execOrderDetailBO.setQuoteInquiryDealInfoBO(quoteInquiryDealInfoBO);
            }
            rspBO.setExecOrderInfo(execOrderDetailBO);
            DPlanMaterialPO dPlanMaterialPO = this.dPlanMaterialMapper.selectByPrimaryKey(dIqrInquiryMatePO.getPlanId());
            if (dPlanMaterialPO != null) {
                BeanUtils.copyProperties((Object)dPlanMaterialPO, (Object)requireInfoBO);
                requireInfoBO.setDeliveryDateMethodName(this.qryDicAtomService.getDicCodeName("DELIVERY_DATE_METHOD", requireInfoBO.getDeliveryDateMethod() + ""));
                requireInfoBO.setPurchaseCategoryName(this.qryDicAtomService.getDicCodeName("PURCHASE_CATEGORY", requireInfoBO.getPurchaseCategory() + ""));
                requireInfoBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", requireInfoBO.getPurchaseMethod() + ""));
                requireInfoBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", requireInfoBO.getPurchaseMethod() + ""));
                requireInfoBO.setInvoiceTypeName(this.qryDicAtomService.getDicCodeName("INVOICE_TYPE", requireInfoBO.getInvoiceType() + ""));
                requireInfoBO.setPayTypeName(this.qryDicAtomService.getDicCodeName("PAY_TYPE", requireInfoBO.getPayType() + ""));
                requireInfoBO.setPayChannelName(this.qryDicAtomService.getDicCodeName("PAY_CHANNEL", requireInfoBO.getPayChannel() + ""));
                requireInfoBO.setIsApproveName(this.qryDicAtomService.getDicCodeName("IS_APPROVE", requireInfoBO.getIsApprove() + ""));
            }
            if (dPlanMaterialPO != null && dPlanMaterialPO.getCreateTime() != null) {
                requireInfoBO.setCreateDate(DateUtils.dateToStr((Date)dPlanMaterialPO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (dPlanMaterialPO != null && dPlanMaterialPO.getReqArrivalDate() != null) {
                requireInfoBO.setReqArrivalDate(DateUtils.dateToStr((Date)dPlanMaterialPO.getReqArrivalDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            rspBO.setRequireInfo(requireInfoBO);
            if ("2".equals(dIqrInquiryMatePO.getBusiType())) {
                QuoteInquiryDealInfoBO inquiryDealInfoBO = new QuoteInquiryDealInfoBO();
                inquiryDealInfoBO.setDeliveryMethod(dIqrInquiryMatePO.getDeliveryMethod());
                inquiryDealInfoBO.setDeliveryMethodName(this.qryDicAtomService.getDicCodeName("DELIVERY_METHOD", dIqrInquiryMatePO.getDeliveryMethod()));
                inquiryDealInfoBO.setDisposalMethod(dIqrInquiryMatePO.getDisposalMethod());
                inquiryDealInfoBO.setDisposalMethodName(this.qryDicAtomService.getDicCodeName("DISPOSAL_METHOD", dIqrInquiryMatePO.getDisposalMethod()));
                inquiryDealInfoBO.setShippingAddr(dIqrInquiryMatePO.getShippingAddr());
                rspBO.setInquiryDealInfoBO(inquiryDealInfoBO);
            }
        }
        List<DIqrQuotationPkgPO> dIqrQuotationPkgPOList = this.dIqrQuotationPkgMapper.selectByQuotationId(reqBO.getQuotationId());
        List<DIqrInquiryMateItemPO> dIqrInquiryMateItemPOList = this.dIqrInquiryMateItemMapper.selectInquiryItemByInquiryId(dIqrInquiryMatePO.getInquiryId());
        ArrayList<QuotationPackageBO> packageBOList = new ArrayList<QuotationPackageBO>();
        if (CollectionUtils.isNotEmpty(dIqrInquiryMateItemPOList) && CollectionUtils.isNotEmpty(dIqrQuotationPkgPOList)) {
            block6: for (DIqrQuotationPkgPO dIqrQuotationPkgPO : dIqrQuotationPkgPOList) {
                QuotationPackageBO packageBO = new QuotationPackageBO();
                for (DIqrInquiryMateItemPO dIqrInquiryMateItemPO : dIqrInquiryMateItemPOList) {
                    if (!dIqrInquiryMateItemPO.getInquiryPkgId().equals(dIqrQuotationPkgPO.getInquiryPkgId())) continue;
                    BeanUtils.copyProperties((Object)dIqrInquiryMateItemPO, (Object)packageBO);
                    packageBO.setInquiryId(dIqrInquiryMateItemPO.getInquiryId());
                    packageBO.setInquiryPkgId(dIqrInquiryMateItemPO.getInquiryPkgId());
                    packageBO.setPkgOrderNo(dIqrInquiryMateItemPO.getInquiryPkgId());
                    packageBO.setPkgCreateDate(DateUtils.dateToStr((Date)dIqrInquiryMateItemPO.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    try {
                        Long amount = dIqrQuotationPkgPO.getAmount();
                        if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPkgPO.getAmountSec())) {
                            amount = QuoteUtil.decode(dIqrQuotationPkgPO.getAmountSec(), dIqrQuotationPkgPO.getQuotationId().toString());
                        }
                        packageBO.setPkgTotalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryMateItemPO.getPkgTotalAmount()));
                        packageBO.setLastTimeQuoteAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                    }
                    catch (Exception e) {
                        log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38", (Throwable)e);
                        rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                    }
                    packageBO.setDetailNum(dIqrQuotationPkgPO.getQuotePkgDetailNum());
                    packageBO.setQuotationId(dIqrQuotationPkgPO.getQuotationId());
                    packageBO.setSupplierId(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierId() : null);
                    packageBO.setSupplierName(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierName() : null);
                    packageBO.setQuotationSubmitTime(dIqrQuotationPO != null ? DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
                    packageBOList.add(packageBO);
                    continue block6;
                }
            }
            rspBO.setPackageList(packageBOList);
        }
        if (reqBO.getSelectType() != null && reqBO.getSelectType() == 2) {
            List<DIqrQuotationItemPO> list = this.dIqrQuotationItemMapper.selectByQuotationId(reqBO.getQuotationId());
            log.info("\u67e5\u8be2\u62a5\u4ef7\u660e\u7ec6\u4e3a:" + JSON.toJSONString(list));
            ArrayList<DIqrQuotationItemMidPO> dIqrQuotationItemMidPOList = new ArrayList<DIqrQuotationItemMidPO>();
            String redisNo = UUID.randomUUID().toString();
            for (DIqrQuotationItemPO DIqrQuotationItemPO2 : list) {
                DIqrQuotationItemMidPO dIqrQuotationItemMidPO = new DIqrQuotationItemMidPO();
                BeanUtils.copyProperties((Object)DIqrQuotationItemPO2, (Object)dIqrQuotationItemMidPO);
                dIqrQuotationItemMidPO.setRedisNo(redisNo);
                dIqrQuotationItemMidPOList.add(dIqrQuotationItemMidPO);
            }
            int insertCount = this.dIqrQuotationItemMidMapper.insertBatch(dIqrQuotationItemMidPOList);
            log.info("\u63d2\u5165\u62a5\u4ef7\u660e\u7ec6\u6761\u6570:" + insertCount);
            rspBO.setRedisNo(redisNo);
        }
        log.info("\u62a5\u4ef7\u8be6\u60c5\uff1a" + JSON.toJSONString((Object)rspBO));
        return rspBO;
    }
}

