/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.GoodsDetailBO;
import com.tydic.enquiry.api.performlist.bo.InquiryAttachmentBO;
import com.tydic.enquiry.api.performlist.bo.InviteSupplierInfoBO;
import com.tydic.enquiry.api.performlist.bo.SaveRisunExecOrderReqBO;
import com.tydic.enquiry.api.performlist.bo.SaveRisunExecOrderRspBO;
import com.tydic.enquiry.api.performlist.service.SaveRisunExecOrderService;
import com.tydic.enquiry.api.registdoc.bo.CreateRisunRegistDocReqBO;
import com.tydic.enquiry.api.registdoc.bo.CreateRisunRegistDocRspBO;
import com.tydic.enquiry.api.registdoc.service.CreateRisunRegistDocService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.RPlanAttachmentInfoMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.RPlanAttachmentInfoPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP_TEST/1.0.0/com.tydic.enquiry.api.performlist.service.SaveRisunExecOrderService"})
public class SaveRisunExecOrderServiceImpl
implements SaveRisunExecOrderService {
    private static final Logger log = LoggerFactory.getLogger(SaveRisunExecOrderServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private RPlanAttachmentInfoMapper rPlanAttachmentInfoMapper;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;
    @Autowired
    SeqIdCreateService seqIdCreateService;
    @Autowired
    CreateRisunRegistDocService createRisunRegistDocService;

    @Transactional(rollbackFor={Exception.class})
    @PostMapping(value={"saveRisunExecOrder"})
    public SaveRisunExecOrderRspBO saveRisunExecOrder(@RequestBody SaveRisunExecOrderReqBO reqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aSaveRisunExecOrderReqBO=" + reqBO.toString());
        SaveRisunExecOrderRspBO rspBO = this.initParam(reqBO);
        if ("9999".equals(rspBO.getRespCode())) {
            return rspBO;
        }
        try {
            DIqrInquiryMatePO dIqrInquiryMatePO1 = this.dIqrInquiryMateMapper.queryInquiryMateByCode(reqBO.getInquiryCode(), Constants.IS_VALID_Y);
            if (null != dIqrInquiryMatePO1) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u9879\u76ee\u7f16\u53f7\u5df2\u5b58\u5728!");
                return rspBO;
            }
            DIqrInquiryMatePO dIqrInquiryMatePO = new DIqrInquiryMatePO();
            BeanUtils.copyProperties((Object)reqBO, (Object)dIqrInquiryMatePO);
            dIqrInquiryMatePO.setInquiryId(this.getDocId("RISUN01", "2"));
            dIqrInquiryMatePO.setValidStatus(Constants.IS_VALID_Y);
            dIqrInquiryMatePO.setDocStatus(Integer.valueOf("2001"));
            dIqrInquiryMatePO.setPurchaseName(reqBO.getPlanUnitName());
            dIqrInquiryMatePO.setPurchaseIdJson(reqBO.getPlanUnit() + "");
            dIqrInquiryMatePO.setLimitQuoteDate(DateUtils.strToDateyyyyMMddHHmmss((String)reqBO.getLimitQuoteDate()));
            dIqrInquiryMatePO.setQuoteEndDate(DateUtils.strToDateyyyyMMddHHmmss((String)reqBO.getQuoteEndDate()));
            dIqrInquiryMatePO.setCreateTime(new Date());
            dIqrInquiryMatePO.setMarginAmount(MoneyUtils.BigDecimal2Long((BigDecimal)reqBO.getMarginAmount()));
            this.dIqrInquiryMateMapper.insertSelective(dIqrInquiryMatePO);
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsDetailList())) {
                for (GoodsDetailBO bmGoodsDetailBO : reqBO.getGoodsDetailList()) {
                    DIqrInquiryDetailPO dIqrInquiryDetailPO = new DIqrInquiryDetailPO();
                    BeanUtils.copyProperties((Object)bmGoodsDetailBO, (Object)dIqrInquiryDetailPO);
                    dIqrInquiryDetailPO.setInquiryItemId(this.getDocId("RISUN01", "21"));
                    dIqrInquiryDetailPO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                    dIqrInquiryDetailPO.setGoodsNumber(MoneyUtils.BigDecimal2Long((BigDecimal)bmGoodsDetailBO.getGoodsNumber()));
                    dIqrInquiryDetailPO.setBudgetPrice(MoneyUtils.BigDecimal2Long((BigDecimal)bmGoodsDetailBO.getBudgetPrice()));
                    dIqrInquiryDetailPO.setBudgetAmount(MoneyUtils.BigDecimal2Long((BigDecimal)bmGoodsDetailBO.getBudgetAmount()));
                    dIqrInquiryDetailPO.setMinGoodsNumber(MoneyUtils.BigDecimal2Long((BigDecimal)bmGoodsDetailBO.getMinGoodsNumber()));
                    dIqrInquiryDetailPO.setValidStatus(Constants.IS_VALID_Y);
                    dIqrInquiryDetailPO.setCreateUserId(reqBO.getCreateUserId());
                    dIqrInquiryDetailPO.setCreateUserName(reqBO.getCreateUserName());
                    dIqrInquiryDetailPO.setCreateTime(new Date());
                    this.dIqrInquiryDetailMapper.insertSelective(dIqrInquiryDetailPO);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getAttachmentInfoList())) {
                log.info("reqBO.getInquiryAttachmentInfoList().size=" + reqBO.getAttachmentInfoList().size());
                for (InquiryAttachmentBO attachmentBO : reqBO.getAttachmentInfoList()) {
                    RPlanAttachmentInfoPO rPlanAttachmentInfoPO = new RPlanAttachmentInfoPO();
                    BeanUtils.copyProperties((Object)attachmentBO, (Object)rPlanAttachmentInfoPO);
                    rPlanAttachmentInfoPO.setAttachmentId(this.getDocId("RISUN01", "99"));
                    rPlanAttachmentInfoPO.setObjectId(dIqrInquiryMatePO.getInquiryId());
                    rPlanAttachmentInfoPO.setCreateUserId(reqBO.getCreateUserId());
                    rPlanAttachmentInfoPO.setCreateUserName(reqBO.getCreateUserName());
                    rPlanAttachmentInfoPO.setCreateTime(new Date());
                    rPlanAttachmentInfoPO.setObjectType(Constants.OBJECT_TYPE_2);
                    rPlanAttachmentInfoPO.setValidFlag(String.valueOf(Constants.IS_VALID_Y));
                    this.rPlanAttachmentInfoMapper.insertSelective(rPlanAttachmentInfoPO);
                }
            }
            if (Constants.PURCHASE_METHOD_INVITE.equals(reqBO.getPurchaseMethod()) && CollectionUtils.isNotEmpty((Collection)reqBO.getInviteSupplierList())) {
                this.createRegistDoc(reqBO.getInviteSupplierList(), dIqrInquiryMatePO.getInquiryId(), dIqrInquiryMatePO.getPurchaseMethod());
            }
            this.insertOperLog(dIqrInquiryMatePO.getInquiryId(), "\u7ade\u4ef7\u5355\u521b\u5efa", "\u7ade\u4ef7\u5355\u521b\u5efa", reqBO.getCreateUserId(), reqBO.getCreateUserName(), "\u6210\u529f");
            rspBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
            rspBO.setInquiryCode(reqBO.getInquiryCode());
            rspBO.setInquiryName(reqBO.getInquiryName());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u6267\u884c\u5355\u5f02\u5e38", (Throwable)e);
            throw new EnqBusinessException("9999", "\u5931\u8d25");
        }
        log.info("\u51fa\u53c2\u4fe1\u606f\uff1aSaveRisunExecOrderReqBO=" + rspBO.toString());
        return rspBO;
    }

    private void createRegistDoc(List<InviteSupplierInfoBO> inviteSupplierList, Long inquiryId, Integer purchaseMethod) {
        for (InviteSupplierInfoBO inviteSupplierInfoBO : inviteSupplierList) {
            CreateRisunRegistDocReqBO createRisunRegistDocReqBO = new CreateRisunRegistDocReqBO();
            createRisunRegistDocReqBO.setInquiryId(inquiryId);
            createRisunRegistDocReqBO.setPurchaseMethod(purchaseMethod);
            createRisunRegistDocReqBO.setSupplierId(inviteSupplierInfoBO.getSupplierId());
            createRisunRegistDocReqBO.setSupplierName(inviteSupplierInfoBO.getSupplierName());
            createRisunRegistDocReqBO.setSupplierContactName(inviteSupplierInfoBO.getSupplierContactName());
            createRisunRegistDocReqBO.setSupplierContactTele(inviteSupplierInfoBO.getSupplierContactTele());
            createRisunRegistDocReqBO.setPhoneNumber(inviteSupplierInfoBO.getPhoneNumber());
            createRisunRegistDocReqBO.setCreditNo(inviteSupplierInfoBO.getCreditNo());
            CreateRisunRegistDocRspBO createRisunRegistDocRspBO = this.createRisunRegistDocService.risunRegistDocCreate(createRisunRegistDocReqBO);
            log.info("\u4fdd\u5b58\u62a5\u540d\u5355\u4fe1\u606f\u751f\u6210\u8fd4\u56de\uff1a" + createRisunRegistDocRspBO);
        }
    }

    private void insertOperLog(Long docId, String operLink, String behavior, Long operUserId, String operUserName, String remark) {
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        cAllOperLogPO.setHisId(this.getDocId("RISUN01", "99"));
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperBehavior(behavior);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        cAllOperLogPO.setRemark(remark);
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }

    private Long getDocId(String systemId, String type) {
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId(systemId);
        seqEnquiryReqBO.setSeqType(type);
        return this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId();
    }

    private SaveRisunExecOrderRspBO initParam(SaveRisunExecOrderReqBO reqBO) {
        SaveRisunExecOrderRspBO rspBO = new SaveRisunExecOrderRspBO();
        if (StringUtils.isBlank((CharSequence)reqBO.getInquiryCode())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u5355CODE\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInquiryName())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getPurchaseMethod() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getLimitQuoteDate())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInquiryName())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBusiType())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        return rspBO;
    }
}

