/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.tydic.enquiry.api.quote.bo.CheckUpdateQuotationBillReqBO;
import com.tydic.enquiry.api.quote.bo.CheckUpdateQuotationBillRspBO;
import com.tydic.enquiry.api.quote.service.CheckUpdateQuotationBillService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP_TEST/1.0.0/com.tydic.enquiry.api.quote.service.CheckUpdateQuotationBillService"})
public class CheckUpdateQuotationBillServiceImpl
implements CheckUpdateQuotationBillService {
    private static final Logger log = LoggerFactory.getLogger(CheckUpdateQuotationBillServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;

    @PostMapping(value={"checkUpdateQuotationBill"})
    public CheckUpdateQuotationBillRspBO checkUpdateQuotationBill(@RequestBody CheckUpdateQuotationBillReqBO reqBO) {
        CheckUpdateQuotationBillRspBO rspBO = new CheckUpdateQuotationBillRspBO();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
        if (dIqrInquiryMatePO == null || dIqrInquiryMatePO.getDocType() == null) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        Date date0 = new Date();
        if (!dIqrInquiryMatePO.getDocStatus().toString().equals("2006") || date0.compareTo(dIqrInquiryMatePO.getQuoteEndDate()) >= 0 || date0.compareTo(dIqrInquiryMatePO.getLimitQuoteDate()) < 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPO qryQuotationPO = new DIqrQuotationPO();
        qryQuotationPO.setInquiryId(reqBO.getInquiryId());
        qryQuotationPO.setHisStatus("1");
        qryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        qryQuotationPO.setSupplierId(reqBO.getSupplierId());
        List<DIqrQuotationPO> quotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryQuotationPO);
        if (quotationPOs == null || quotationPOs.size() <= 0) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPO dIqrQuotationPO = quotationPOs.get(0);
        if (dIqrQuotationPO.getPayStatus() == null || "1".equals(dIqrQuotationPO.getPayStatus())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u7ade\u4ef7\u5355\u672a\u7f34\u7eb3\u4fdd\u8bc1\u91d1\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (dIqrQuotationPO.getQuoteRounds() != null && dIqrInquiryMatePO.getLimitBargainNum() != null && Integer.valueOf(dIqrQuotationPO.getQuoteRounds()) >= dIqrInquiryMatePO.getLimitBargainNum()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u62a5\u4ef7\u5df2\u63d0\u4ea4\u6216\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\u4e0d\u53ef\u518d\u6b21\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6821\u9a8c\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

