/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.registdoc.bo.UpMarginPayStatusReqBO;
import com.tydic.enquiry.api.registdoc.bo.UpMarginPayStatusRspBO;
import com.tydic.enquiry.api.registdoc.service.UpMarginPayStatusService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP_TEST/1.0.0/com.tydic.enquiry.api.registdoc.service.UpMarginPayStatusService"})
public class UpMarginPayStatusServiceImpl
implements UpMarginPayStatusService {
    private static final Logger log = LoggerFactory.getLogger(UpMarginPayStatusServiceImpl.class);
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;
    @Autowired
    SeqIdCreateService seqIdCreateService;
    @Autowired
    QryDicAtomService qryDicAtomService;

    @PostMapping(value={"upMarginPayStatus"})
    public UpMarginPayStatusRspBO upMarginPayStatus(@RequestBody UpMarginPayStatusReqBO reqBO) {
        log.info("\u4fdd\u8bc1\u91d1\u7f34\u7eb3\u4fe1\u606f\u53d8\u66f4\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aUpMarginPayStatusReqBO=" + reqBO.toString());
        UpMarginPayStatusRspBO upMarginPayStatusRspBO = new UpMarginPayStatusRspBO();
        String payFlag = reqBO.getPayFlag();
        if (StringUtils.isBlank((CharSequence)payFlag)) {
            upMarginPayStatusRspBO.setRespCode("9999");
            upMarginPayStatusRspBO.setRespDesc("\u4fdd\u8bc1\u7f34\u7eb3\u53d8\u66f4\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
            return upMarginPayStatusRspBO;
        }
        if (null == reqBO.getSupplierId()) {
            upMarginPayStatusRspBO.setRespCode("9999");
            upMarginPayStatusRspBO.setRespDesc("\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return upMarginPayStatusRspBO;
        }
        if (null == reqBO.getRegistId()) {
            upMarginPayStatusRspBO.setRespCode("9999");
            upMarginPayStatusRspBO.setRespDesc("\u62a5\u540d\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return upMarginPayStatusRspBO;
        }
        try {
            DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectByPrimaryKey(reqBO.getRegistId());
            if (null != dIqrRegistDocPO) {
                if ("5".equals(dIqrRegistDocPO.getPayStatus()) || "4".equals(dIqrRegistDocPO.getPayStatus())) {
                    upMarginPayStatusRspBO.setRespCode("9999");
                    upMarginPayStatusRspBO.setRespDesc("\u4fdd\u8bc1\u91d1\u72b6\u6001\u5df2\u7ecf\u4e3a\u5df2\u7f5a\u6ca1\u6216\u8005\u5df2\u9000\u8d39!");
                    return upMarginPayStatusRspBO;
                }
                if ("1".equals(payFlag)) {
                    dIqrRegistDocPO.setPayStatus("1");
                } else if ("2".equals(payFlag)) {
                    dIqrRegistDocPO.setPayStatus("2");
                    dIqrRegistDocPO.setPayDate(new Date());
                } else if ("3".equals(payFlag)) {
                    dIqrRegistDocPO.setPayStatus("3");
                } else if ("4".equals(payFlag)) {
                    dIqrRegistDocPO.setPayStatus("4");
                    BigDecimal subtract = MoneyUtils.Long2BigDecimal((Long)dIqrRegistDocPO.getMarginAmount()).subtract(reqBO.getRefundAmount());
                    dIqrRegistDocPO.setConfiscaAmount(MoneyUtils.BigDecimal2Long((BigDecimal)subtract));
                } else if ("5".equals(payFlag)) {
                    dIqrRegistDocPO.setPayStatus("5");
                    dIqrRegistDocPO.setConfiscaAmount(dIqrRegistDocPO.getMarginAmount());
                }
            } else {
                upMarginPayStatusRspBO.setRespCode("9999");
                upMarginPayStatusRspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4f9b\u5e94\u5546\u6570\u636e!");
                return upMarginPayStatusRspBO;
            }
            dIqrRegistDocPO.setModifyTime(new Date());
            dIqrRegistDocPO.setModifyUserId(reqBO.getOperId());
            dIqrRegistDocPO.setModifyUserName(reqBO.getOperName());
            this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocPO);
            upMarginPayStatusRspBO.setDocId(reqBO.getRegistId());
            String dicCodeName = this.qryDicAtomService.getDicCodeName("PAY_STATUS", dIqrRegistDocPO.getPayStatus() + "");
            this.insertOperLog(reqBO.getRegistId(), "\u4fdd\u8bc1\u91d1\u72b6\u6001\u53d8\u66f4", "\u4fdd\u8bc1\u91d1\u72b6\u6001\u53d8\u66f4(" + dicCodeName + ")", reqBO.getOperId(), reqBO.getOperName(), "\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u4fdd\u8bc1\u91d1\u4fe1\u606f\u53d8\u66f4\u5f02\u5e38", (Throwable)e);
            throw new EnqBusinessException("9999", "\u4fdd\u8bc1\u91d1\u72b6\u6001\u53d8\u66f4\u5f02\u5e38!");
        }
        upMarginPayStatusRspBO.setRespCode("0000");
        upMarginPayStatusRspBO.setRespDesc("\u6210\u529f");
        return upMarginPayStatusRspBO;
    }

    private void insertOperLog(Long docId, String operLink, String behavior, Long operUserId, String operUserName, String remark) {
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("RISUN01");
        seqEnquiryReqBO.setSeqType("99");
        SeqEnquiryRspBO seqOperLogRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        cAllOperLogPO.setHisId(seqOperLogRspBO.getDocId());
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperBehavior(behavior);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        cAllOperLogPO.setRemark(remark);
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }
}

