/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.performlist.bo.ApproveRisunExceReqBO;
import com.tydic.enquiry.api.performlist.bo.ApproveRisunExceRspBO;
import com.tydic.enquiry.api.performlist.bo.ExecOrderStatusReqBO;
import com.tydic.enquiry.api.performlist.service.ApproveRisunExceOrderService;
import com.tydic.enquiry.api.performlist.service.UpExecOrderStatusService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.osworkflow.engine.exception.OsworkflowDataException;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.exception.BusinessException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP_TEST/1.0.0/com.tydic.enquiry.api.performlist.service.ApproveRisunExceOrderService"})
public class ApproveRisunExceOrderServiceImpl
implements ApproveRisunExceOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApproveRisunExceOrderServiceImpl.class);
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;
    @Autowired
    SeqIdCreateService seqIdCreateService;
    @Autowired
    UpExecOrderStatusService upExecOrderStatusService;
    @Autowired(required=false)
    UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;

    @PostMapping(value={"exceOrderApprove"})
    public ApproveRisunExceRspBO exceOrderApprove(@RequestBody ApproveRisunExceReqBO reqBO) {
        log.info("\u5165\u53c2ApproveRisunExceReqBO:" + reqBO.toString());
        ApproveRisunExceRspBO rspBO = new ApproveRisunExceRspBO();
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getApproveFlag())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5ba1\u6279\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
            if (null == dIqrInquiryMatePO || StringUtils.isBlank((CharSequence)dIqrInquiryMatePO.getProcessInstId())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u7ade\u4ef7\u5355\u4e3a\u7a7a\u6216\u8005\u7ade\u4ef7\u5355\u5ba1\u6279\u6d41\u7a0bID\u4e3a\u7a7a!");
                return rspBO;
            }
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            uacNoTaskAuditOrderAuditReqBO.setStepId(dIqrInquiryMatePO.getProcessInstId());
            uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getApproveOperId()));
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApproveComments());
            uacNoTaskAuditOrderAuditReqBO.setObjType(Integer.valueOf(111));
            if ("1".equals(reqBO.getApproveFlag())) {
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(0));
            } else {
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(1));
            }
            ArrayList<Long> objIdList = new ArrayList<Long>();
            objIdList.add(reqBO.getInquiryId());
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIdList);
            UacNoTaskAuditOrderAuditRspBO uacNoTaskAuditOrderAuditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(uacNoTaskAuditOrderAuditReqBO);
            log.info("\u7ade\u4ef7\u5355\u5ba1\u6279\u5904\u7406\u51fa\u53c2", (Object)uacNoTaskAuditOrderAuditRspBO);
            if (!"0000".equals(uacNoTaskAuditOrderAuditRspBO.getRespCode())) {
                throw new EnqBusinessException("9999", uacNoTaskAuditOrderAuditRspBO.getRespDesc());
            }
            ExecOrderStatusReqBO execOrderStatusReqBO = new ExecOrderStatusReqBO();
            execOrderStatusReqBO.setInquiryId(reqBO.getInquiryId());
            String approveFlag = reqBO.getApproveFlag();
            if ("1".equals(approveFlag)) {
                execOrderStatusReqBO.setDocStatus(Integer.valueOf("2004"));
                execOrderStatusReqBO.setNodeStatus("2004");
            } else {
                execOrderStatusReqBO.setDocStatus(Integer.valueOf("2003"));
                execOrderStatusReqBO.setNodeStatus("2003");
            }
            execOrderStatusReqBO.setOperId(reqBO.getApproveOperId());
            execOrderStatusReqBO.setOperName(reqBO.getApproveOperName());
            execOrderStatusReqBO.setUpFlag("1");
            execOrderStatusReqBO.setProcessStatus(Integer.valueOf(2));
            this.upExecOrderStatusService.updateExecOrderStatus(execOrderStatusReqBO);
            this.insertOperLog(dIqrInquiryMatePO.getInquiryId(), "\u7ade\u4ef7\u5355\u5ba1\u6279", reqBO.getApproveOperId(), reqBO.getApproveOperName(), approveFlag);
            rspBO.setApproveDate(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss"));
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7\u5355\u5ba1\u6279\u5f02\u5e38", (Throwable)e);
            if (e instanceof EnqBusinessException || e instanceof BusinessException || e instanceof OsworkflowDataException) {
                throw new EnqBusinessException("9999", e.getMessage());
            }
            throw new EnqBusinessException("9999", "\u7ade\u4ef7\u5355\u5ba1\u6279\u5f02\u5e38");
        }
        return rspBO;
    }

    private void insertOperLog(Long docId, String operLink, Long operUserId, String operUserName, String approveFlag) {
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("RISUN01");
        seqEnquiryReqBO.setSeqType("99");
        SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        cAllOperLogPO.setHisId(seqEnquiryPubRspBO.getDocId());
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        if ("1".equals(approveFlag)) {
            cAllOperLogPO.setOperBehavior("\u7ade\u4ef7\u5355\u5ba1\u6279\uff08\u901a\u8fc7\uff09");
        } else {
            cAllOperLogPO.setOperBehavior("\u7ade\u4ef7\u5355\u5ba1\u6279\uff08\u9a73\u56de\uff09");
        }
        cAllOperLogPO.setBusiStepId(2);
        cAllOperLogPO.setRemark("\u6210\u529f");
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }
}

