/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.demandlist;

import com.tydic.enquiry.api.demandlist.bo.DelReqOrderInfoBO;
import com.tydic.enquiry.api.demandlist.bo.DelRequireOrderReqBO;
import com.tydic.enquiry.api.demandlist.bo.DelRequireOrderRspBO;
import com.tydic.enquiry.api.demandlist.service.DelRequireOrderService;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.CPlanStatusNodeLogMapper;
import com.tydic.enquiry.dao.DPlanItemMaterialMapper;
import com.tydic.enquiry.dao.DPlanMaterialMapper;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.CPlanStatusNodeLogPO;
import com.tydic.enquiry.po.DPlanItemMaterialPO;
import com.tydic.enquiry.po.DPlanMaterialPO;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP_TEST/1.0.0/com.tydic.enquiry.api.demandlist.service.DelRequireOrderService"})
public class DelRequireOrderServiceImpl
implements DelRequireOrderService {
    private static final Logger log = LoggerFactory.getLogger(DelRequireOrderServiceImpl.class);
    @Autowired
    private DPlanMaterialMapper dPlanMaterialMapper;
    @Autowired
    private DPlanItemMaterialMapper dPlanItemMaterialMapper;
    @Autowired
    private CPlanStatusNodeLogMapper cPlanStatusNodeLogMapper;
    @Autowired
    SeqIdCreateService seqIdCreateService;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    private CAllOperLogMapper cAllOperLogMapper;

    @PostMapping(value={"delRequireOrder"})
    public DelRequireOrderRspBO delRequireOrder(@RequestBody DelRequireOrderReqBO reqBO) {
        List delReqOrderInfoList;
        DelRequireOrderRspBO rspBO = new DelRequireOrderRspBO();
        DelRequireOrderRspBO initParamRsqBO = this.initParam(reqBO);
        if (!"\u6210\u529f".equals(initParamRsqBO.getRespCode())) {
            rspBO.setRespCode(initParamRsqBO.getRespCode());
            rspBO.setRespDesc(initParamRsqBO.getRespDesc());
        }
        if ((delReqOrderInfoList = reqBO.getDelReqOrderInfoList()).isEmpty()) {
            log.error("\u9700\u6c42\u5355\u5220\u9664\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            for (DelReqOrderInfoBO delReqOrderInfoBO : delReqOrderInfoList) {
                Long planId = delReqOrderInfoBO.getPlanId();
                DPlanMaterialPO dPlanMaterialPO = this.dPlanMaterialMapper.selectByPrimaryKey(planId);
                if (dPlanMaterialPO == null) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u8be5\u9700\u6c42\u5355\u4e0d\u5b58\u5728");
                } else {
                    DPlanMaterialPO dPlanMaterialreqPO = new DPlanMaterialPO();
                    dPlanMaterialreqPO.setPlanId(planId);
                    dPlanMaterialreqPO.setModifyUserId(reqBO.getOperId());
                    dPlanMaterialreqPO.setModifyUserName(reqBO.getOperName());
                    dPlanMaterialreqPO.setModifyTime(new Date());
                    dPlanMaterialreqPO.setNodeStatus("1108");
                    dPlanMaterialreqPO.setValidStatus(Constants.IS_VALID_N);
                    int result = this.dPlanMaterialMapper.updateByPrimaryKeySelective(dPlanMaterialreqPO);
                    if (result < 0) {
                        rspBO.setRespCode("9999");
                        rspBO.setRespDesc("\u9700\u6c42\u5355\u4fe1\u606f\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
                    }
                }
                List<DPlanItemMaterialPO> itemMaterialPOList = this.dPlanItemMaterialMapper.selectItemMaterialByPlanId(planId);
                if (CollectionUtils.isEmpty(itemMaterialPOList)) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u8be5\u9700\u6c42\u660e\u7ec6\u5355\u4e0d\u5b58\u5728");
                } else {
                    DPlanItemMaterialPO dPlanItemMaterialPO = new DPlanItemMaterialPO();
                    dPlanItemMaterialPO.setPlanId(planId);
                    dPlanItemMaterialPO.setValidStatus(Constants.IS_VALID_N);
                    dPlanItemMaterialPO.setNodeStatus("1108");
                    dPlanItemMaterialPO.setModifyUserId(reqBO.getOperId());
                    dPlanItemMaterialPO.setModifyUserName(reqBO.getOperName());
                    dPlanItemMaterialPO.setModifyTime(new Date());
                    int resultItem = this.dPlanItemMaterialMapper.updateByPlanIdSelective(dPlanItemMaterialPO);
                    if (resultItem < 0) {
                        rspBO.setRespCode("9999");
                        rspBO.setRespDesc("\u5220\u9664\u9700\u6c42\u5355\u660e\u7ec6\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                    }
                }
                CPlanStatusNodeLogPO cPlanStatusNodeLogPO = new CPlanStatusNodeLogPO();
                SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("99");
                SeqEnquiryRspBO seqEnquiryRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                cPlanStatusNodeLogPO.setPlanNodeRelId(seqEnquiryRspBO.getDocId());
                cPlanStatusNodeLogPO.setPlanProType(Integer.parseInt("1001"));
                cPlanStatusNodeLogPO.setNodeStatus(Integer.parseInt("1103"));
                cPlanStatusNodeLogPO.setBusiStatusId(Integer.parseInt("1208"));
                cPlanStatusNodeLogPO.setDocStatusName(this.qryDicAtomService.getDicCodeName("REQ_DOC_STATUS", "1001"));
                cPlanStatusNodeLogPO.setNodeName(this.qryDicAtomService.getDicCodeName("REQ_NODE_STATUS", "1103"));
                cPlanStatusNodeLogPO.setBusiStatusName(this.qryDicAtomService.getDicCodeName("BUSI_STATUS", "1208"));
                cPlanStatusNodeLogPO.setPlanId(dPlanMaterialPO.getPlanId());
                cPlanStatusNodeLogPO.setPlanCode(dPlanMaterialPO.getPlanCode());
                cPlanStatusNodeLogPO.setOperId(reqBO.getOperId());
                cPlanStatusNodeLogPO.setOperName(reqBO.getOperName());
                cPlanStatusNodeLogPO.setOperTime(new Date());
                cPlanStatusNodeLogPO.setCreateTime(new Date());
                cPlanStatusNodeLogPO.setRemark("\u9700\u6c42\u5355\u5220\u9664");
                int resultstatus = this.cPlanStatusNodeLogMapper.insertSelective(cPlanStatusNodeLogPO);
                if (resultstatus < 0) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u65b0\u589e\u8ba1\u5212\u8282\u70b9\u5173\u7cfb\u8bb0\u5f55\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                }
                CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
                cAllOperLogPO.setOperLink("\u9700\u6c42\u5355\u5220\u9664");
                cAllOperLogPO.setOperBehavior("\u9700\u6c42\u5355\u5220\u9664");
                cAllOperLogPO.setRemark("\u5220\u9664\u9700\u6c42\u5355\u6210\u529f");
                cAllOperLogPO.setOperId(reqBO.getOrgId());
                cAllOperLogPO.setOperName(reqBO.getOrgName());
                cAllOperLogPO.setHisId(this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId());
                cAllOperLogPO.setDocId(planId);
                cAllOperLogPO.setOperOrgId(dPlanMaterialPO.getPlanDepart());
                cAllOperLogPO.setOperOrgName(dPlanMaterialPO.getPlanDepartName());
                cAllOperLogPO.setOperTime(new Date());
                cAllOperLogPO.setArrivalTime(dPlanMaterialPO.getReqArrivalDate());
                int resultstatus1 = this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
                if (resultstatus1 >= 0) continue;
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u65b0\u589e\u8bb0\u5f55\u64cd\u4f5c\u8868\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private DelRequireOrderRspBO initParam(DelRequireOrderReqBO reqBO) {
        DelRequireOrderRspBO rspBO = new DelRequireOrderRspBO();
        rspBO.setRespCode("0000");
        if (null == reqBO) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u64cd\u4f5c\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperName()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getDelReqOrderInfoList()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u9700\u6c42\u5355\u5220\u9664\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            for (DelReqOrderInfoBO delReqOrderInfoBO : reqBO.getDelReqOrderInfoList()) {
                if (delReqOrderInfoBO.getPlanId() != null) continue;
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u9700\u6c42\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        return rspBO;
    }
}

