/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.enquiry.api.performlist.bo.QryNoticeDetailReqBO;
import com.tydic.enquiry.api.performlist.bo.QryNoticeDetailRspBO;
import com.tydic.enquiry.api.performlist.service.QryNoticeDetailService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrConfirmNoticeMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.po.DIqrConfirmNoticePO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrPurchaseNoticePO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.HtmlUtils;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP_TEST/1.0.0/com.tydic.enquiry.api.performlist.service.QryNoticeDetailService"})
public class QryNoticeDetailServiceImpl
implements QryNoticeDetailService {
    private static final Logger log = LoggerFactory.getLogger(QryNoticeDetailServiceImpl.class);
    @Autowired
    private DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrConfirmNoticeMapper dIqrConfirmNoticeMapper;

    @PostMapping(value={"qryNoticeDetail"})
    public QryNoticeDetailRspBO qryNoticeDetail(@RequestBody QryNoticeDetailReqBO reqBO) {
        QryNoticeDetailRspBO rspBO = new QryNoticeDetailRspBO();
        if (null == reqBO.getType()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getBusiType())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (null == reqBO.getNoticeId()) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u516c\u544aID\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            DIqrConfirmNoticePO dIqrConfirmNoticePO;
            DIqrInquiryMatePO inquiryInfo;
            DIqrPurchaseNoticePO dIqrPurchaseNoticePO;
            if (Constants.NOTICE_TYPE_1.equals(reqBO.getType()) && null != (dIqrPurchaseNoticePO = this.dIqrPurchaseNoticeMapper.selectValid(reqBO.getNoticeId(), Constants.IS_VALID_Y, reqBO.getBusiType()))) {
                BeanUtils.copyProperties((Object)dIqrPurchaseNoticePO, (Object)rspBO);
                rspBO.setNoticeContent(HtmlUtils.htmlUnescape((String)dIqrPurchaseNoticePO.getNoticeContent()));
                rspBO.setPublishTime(DateUtils.dateToStrLong((Date)dIqrPurchaseNoticePO.getPublishTime()));
                inquiryInfo = this.getInquiryInfo(dIqrPurchaseNoticePO.getInquiryId(), dIqrPurchaseNoticePO.getPurchaseMethod(), reqBO.getBusiType());
                if (null != inquiryInfo) {
                    rspBO.setDocStatus(inquiryInfo.getDocStatus());
                }
            }
            if (Constants.NOTICE_TYPE_2.equals(reqBO.getType()) && null != (dIqrConfirmNoticePO = this.dIqrConfirmNoticeMapper.selectValid(reqBO.getNoticeId(), Constants.IS_VALID_Y, reqBO.getBusiType()))) {
                BeanUtils.copyProperties((Object)dIqrConfirmNoticePO, (Object)rspBO);
                rspBO.setNoticeContent(HtmlUtils.htmlUnescape((String)dIqrConfirmNoticePO.getNoticeContent()));
                rspBO.setPublishTime(DateUtils.dateToStrLong((Date)dIqrConfirmNoticePO.getPublishTime()));
                inquiryInfo = this.getInquiryInfo(dIqrConfirmNoticePO.getInquiryId(), dIqrConfirmNoticePO.getPurchaseMethod(), reqBO.getBusiType());
                if (null != inquiryInfo) {
                    rspBO.setDocStatus(inquiryInfo.getDocStatus());
                }
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.info("\u67e5\u8be2\u516c\u544a\u8be6\u60c5\u5931\u8d25!", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5931\u8d25");
        }
        return rspBO;
    }

    private DIqrInquiryMatePO getInquiryInfo(Long inquiryId, Integer purchaseMethod, String busiType) {
        return this.dIqrInquiryMateMapper.queryByIdAndPurchaseMethod(inquiryId, purchaseMethod, Constants.IS_VALID_Y, busiType);
    }
}

