/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.tydic.enquiry.api.registdoc.bo.UpdateRisunRegistDocReqBO;
import com.tydic.enquiry.api.registdoc.bo.UpdateRisunRegistDocRspBO;
import com.tydic.enquiry.api.registdoc.service.UpdateRisunRegistDocService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ENQUIRY_GROUP_TEST/1.0.0/com.tydic.enquiry.api.registdoc.service.UpdateRisunRegistDocService"})
public class UpdateRisunRegistDocServiceImpl
implements UpdateRisunRegistDocService {
    private static final Logger log = LoggerFactory.getLogger(UpdateRisunRegistDocServiceImpl.class);
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;
    @Autowired
    SeqIdCreateService seqIdCreateService;

    @PostMapping(value={"risunRegistDocUpdate"})
    public UpdateRisunRegistDocRspBO risunRegistDocUpdate(@RequestBody UpdateRisunRegistDocReqBO reqBO) {
        log.info("\u62a5\u540d\u5355\u4fee\u6539\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aUpdateRisunRegistDocReqBO=" + reqBO.toString());
        if (reqBO.getRegistId() == null) {
            this.gerRspInfo("9999", "\u62a5\u540d\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        try {
            DIqrRegistDocPO dIqrRegistDocUpdate = new DIqrRegistDocPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)dIqrRegistDocUpdate);
            int ret = this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocUpdate);
            if (ret > 0 && Constants.IS_VALID_N.equals(reqBO.getValidStatus())) {
                this.dIqrRegistDetailMapper.updateValidStatusByRegistId(reqBO.getRegistId(), Constants.IS_VALID_N);
            }
            this.insertOperLog(reqBO.getRegistId(), "\u4f9b\u5e94\u5546\u62a5\u540d", "\u4f9b\u5e94\u5546\u62a5\u540d\u4fe1\u606f\u4fee\u6539", reqBO.getRegistUserId(), reqBO.getRegistUserName(), "\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u62a5\u540d\u5355\u4fee\u6539\u5f02\u5e38", (Throwable)e);
            throw new EnqBusinessException("9999", "\u62a5\u540d\u5355\u4fee\u6539\u5f02\u5e38!");
        }
        log.info("\u62a5\u540d\u5355\u4fee\u6539\u5b8c\u6210");
        return this.gerRspInfo("0000", "\u6210\u529f");
    }

    private void insertOperLog(Long docId, String operLink, String behavior, Long operUserId, String operUserName, String remark) {
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("RISUN01");
        seqEnquiryReqBO.setSeqType("99");
        SeqEnquiryRspBO seqOperLogRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        cAllOperLogPO.setHisId(seqOperLogRspBO.getDocId());
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperBehavior(behavior);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        cAllOperLogPO.setRemark(remark);
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }

    private UpdateRisunRegistDocRspBO gerRspInfo(String respCode, String respDesc) {
        UpdateRisunRegistDocRspBO updateRisunRegistDocRspBO = new UpdateRisunRegistDocRspBO();
        updateRisunRegistDocRspBO.setRespCode(respCode);
        updateRisunRegistDocRspBO.setRespDesc(respDesc);
        return updateRisunRegistDocRspBO;
    }
}

