/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.performlist.bo.InquiryDetailBO;
import com.tydic.enquiry.api.registdoc.bo.QryRegistDetailReqBO;
import com.tydic.enquiry.api.registdoc.bo.QryRegistDetailRspBO;
import com.tydic.enquiry.api.registdoc.bo.RegistDetailBO;
import com.tydic.enquiry.api.registdoc.bo.RegistDetailInfoBO;
import com.tydic.enquiry.api.registdoc.service.QryRegistDetailService;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=QryRegistDetailService.class)
public class QryRegistDetailServiceImpl
implements QryRegistDetailService {
    private static final Logger log = LoggerFactory.getLogger(QryRegistDetailServiceImpl.class);
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @Autowired
    DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    public QryRegistDetailRspBO qryRegistDetail(QryRegistDetailReqBO qryRegistDetailReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryRegistDetailReqBO=" + qryRegistDetailReqBO.toString());
        QryRegistDetailRspBO qryRegistDetailRspBO = new QryRegistDetailRspBO();
        DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectByPrimaryKey(qryRegistDetailReqBO.getRegistId());
        RegistDetailInfoBO registDetailInfo = new RegistDetailInfoBO();
        BeanUtils.copyProperties((Object)dIqrRegistDocPO, (Object)registDetailInfo);
        registDetailInfo.setRegistTime(DateUtils.dateToStr((Date)dIqrRegistDocPO.getRegistTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        BigDecimal amount = new BigDecimal(10000);
        if (dIqrRegistDocPO.getMarginAmount() != null) {
            BigDecimal marginAmountTemp = new BigDecimal(dIqrRegistDocPO.getMarginAmount());
            log.info("marginAmountTemp=" + marginAmountTemp);
            registDetailInfo.setMarginAmount(marginAmountTemp.divide(amount).setScale(2, RoundingMode.HALF_UP));
        }
        log.info("registDetailInfo.getMarginAmount()=" + registDetailInfo.getMarginAmount());
        if (dIqrRegistDocPO.getPayStatus() != null && !"".equals(dIqrRegistDocPO.getPayStatus())) {
            registDetailInfo.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", dIqrRegistDocPO.getPayStatus() + ""));
        }
        registDetailInfo.setComArriveOffset(dIqrRegistDocPO.getDeliveryIntPromise());
        qryRegistDetailRspBO.setRegistDetailInfo(registDetailInfo);
        qryRegistDetailRspBO.setInquiryPkgIds(dIqrRegistDocPO.getInquiryPkgIds());
        List<DIqrRegistDetailPO> iqrRegistDetailPOList = this.dIqrRegistDetailMapper.selectByRegistId(qryRegistDetailReqBO.getRegistId());
        if (CollectionUtils.isNotEmpty(iqrRegistDetailPOList)) {
            ArrayList registIqrDetailList = new ArrayList();
            List registDetailList = iqrRegistDetailPOList.stream().map(e -> {
                RegistDetailBO registDetailBO = new RegistDetailBO();
                InquiryDetailBO inquiryDetailBO = new InquiryDetailBO();
                BeanUtils.copyProperties((Object)e, (Object)registDetailBO);
                DIqrInquiryDetailPO dIqrInquiryDetailPO = this.dIqrInquiryDetailMapper.selectByPrimaryKey(e.getInquiryItemId());
                BeanUtils.copyProperties((Object)dIqrInquiryDetailPO, (Object)inquiryDetailBO);
                try {
                    inquiryDetailBO.setGoodsNumber(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getGoodsNumber()));
                    inquiryDetailBO.setBudgetPrice(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getBudgetPrice()));
                    inquiryDetailBO.setBudgetAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getBudgetAmount()));
                    inquiryDetailBO.setEvalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getEvalAmount()));
                    inquiryDetailBO.setOriginalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getOriginalAmount()));
                    inquiryDetailBO.setShowAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryDetailPO.getShowAmount()));
                }
                catch (Exception exc) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + exc.getStackTrace());
                    qryRegistDetailRspBO.setRespCode("9999");
                    qryRegistDetailRspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                inquiryDetailBO.setProductionDate(DateUtils.dateToStr((Date)dIqrInquiryDetailPO.getProductionDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                registIqrDetailList.add(inquiryDetailBO);
                return registDetailBO;
            }).collect(Collectors.toList());
            qryRegistDetailRspBO.setRegistDetailList(registDetailList);
            qryRegistDetailRspBO.setRegistIqrDetailList(registIqrDetailList);
        }
        qryRegistDetailRspBO.setRespCode("0000");
        qryRegistDetailRspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryRegistDetailRspBO=" + qryRegistDetailRspBO.toString());
        return qryRegistDetailRspBO;
    }
}

