/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryQuotationItemByIdReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationItemByIdRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationItemBO;
import com.tydic.enquiry.api.quote.service.QryQuotationItemByIdService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryQuotationItemByIdService.class)
public class QryQuotationItemByIdServiceImpl
implements QryQuotationItemByIdService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationItemByIdServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;
    @Autowired
    private DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    public QryQuotationItemByIdRspBO qryQuotationItemById(QryQuotationItemByIdReqBO qryQuotationItemByIdReqBO) {
        QryQuotationItemByIdRspBO rspBO = new QryQuotationItemByIdRspBO();
        ArrayList<QuotationItemBO> quotationItemInfoList = new ArrayList<QuotationItemBO>();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(qryQuotationItemByIdReqBO.getInquiryId());
        if (dIqrInquiryMatePO == null) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrInquiryBidsectionPO bidsectionPO = this.dIqrInquiryBidsectionMapper.selectByPrimaryKey(qryQuotationItemByIdReqBO.getBidsectionId());
        if (bidsectionPO == null) {
            log.error("\u5f53\u524d\u6807\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6807\u6bb5\u4fe1\u606f\u4e0d\u5b58\u5728");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPO qryQuotationPO = new DIqrQuotationPO();
        qryQuotationPO.setInquiryId(qryQuotationItemByIdReqBO.getInquiryId());
        qryQuotationPO.setHisStatus("1");
        qryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("40014"));
        docStatusList.add(Integer.valueOf("40015"));
        qryQuotationPO.setDocStatusList(docStatusList);
        qryQuotationPO.setSupplierId(qryQuotationItemByIdReqBO.getSupplierId());
        qryQuotationPO.setBidsectionId(qryQuotationItemByIdReqBO.getBidsectionId());
        List<DIqrQuotationPO> quotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryQuotationPO);
        if (quotationPOs == null || quotationPOs.size() <= 0) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectRegistDocByInquiryIdSupId(qryQuotationItemByIdReqBO.getInquiryId(), qryQuotationItemByIdReqBO.getSupplierId());
            DIqrRegistDetailPO dIqrRegistDetailPO = this.dIqrRegistDetailMapper.selectByRegistAndBidId(dIqrRegistDocPO.getRegistId(), qryQuotationItemByIdReqBO.getBidsectionId());
            if (dIqrRegistDetailPO != null) {
                if ("2".equals(dIqrRegistDocPO.getPayStatus())) {
                    if (bidsectionPO.getLimitTimes() != null && bidsectionPO.getLimitTimes() != 0) {
                        rspBO.setSurplusQuotationTimes(bidsectionPO.getLimitTimes());
                        rspBO.setSurplusQuotationTimesStr(rspBO.getSurplusQuotationTimes() + "");
                    } else if (bidsectionPO.getLimitTimes() == 0) {
                        rspBO.setSurplusQuotationTimesStr("-");
                    }
                    rspBO.setMyQuotePriceStr("\u672a\u51fa\u4ef7");
                } else if ("1".equals(dIqrRegistDocPO.getPayStatus())) {
                    rspBO.setSurplusQuotationTimesStr("-");
                    rspBO.setMyQuotePriceStr("\u672a\u7f34\u7eb3\u4fdd\u8bc1\u91d1");
                    rspBO.setQuoteExplain("nomargin");
                }
            } else {
                rspBO.setSurplusQuotationTimesStr("-");
                rspBO.setMyQuotePriceStr("\u672a\u62a5\u540d\u6b64\u6807\u6bb5");
                rspBO.setQuoteExplain("noregist");
            }
            rspBO.setBidsectionId(bidsectionPO.getBidsectionId());
            rspBO.setRespCode("0000");
            rspBO.setQuotationItemInfoList(quotationItemInfoList);
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPO quotationPO = quotationPOs.get(0);
        List<DIqrQuotationItemPO> dIqrQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationId(quotationPO.getQuotationId());
        BeanUtils.copyProperties((Object)quotationPO, (Object)rspBO);
        try {
            Long amount = quotationPO.getAmount();
            if (StringUtils.isNotEmpty((CharSequence)quotationPO.getAmountSec())) {
                amount = QuoteUtil.decode(quotationPO.getAmountSec(), quotationPO.getQuotationId().toString());
            }
            rspBO.setAmount(MoneyUtils.Long2BigDecimal((Long)amount));
        }
        catch (Exception e) {
            log.error("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
        }
        rspBO.setBidsectionId(bidsectionPO.getBidsectionId());
        rspBO.setReviewResultName(this.qryDicAtomService.getDicCodeName("REVIEW_RESULT", quotationPO.getReviewResult() + ""));
        rspBO.setMyQuotePriceStr(rspBO.getAmount() + "(" + rspBO.getReviewResultName() + ")");
        rspBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("QUOTE_DOC_STATUS", quotationPO.getDocStatus() + ""));
        rspBO.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", quotationPO.getPayStatus()));
        if (bidsectionPO.getLimitTimes() != null && bidsectionPO.getLimitTimes() != 0 && StringUtils.isNotBlank((CharSequence)quotationPO.getQuoteRounds())) {
            rspBO.setSurplusQuotationTimes(Integer.valueOf(bidsectionPO.getLimitTimes() - Integer.valueOf(quotationPO.getQuoteRounds())));
            rspBO.setSurplusQuotationTimesStr(rspBO.getSurplusQuotationTimes() + "");
        } else if (bidsectionPO.getLimitTimes() == 0) {
            rspBO.setSurplusQuotationTimesStr("-");
        }
        rspBO.setQuotationSubmitTime(DateUtils.dateToStr((Date)quotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOList) {
            QuotationItemBO quotationItemBO = new QuotationItemBO();
            BeanUtils.copyProperties((Object)dIqrQuotationItemPO, (Object)quotationItemBO);
            try {
                Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                Long quoteAmount = dIqrQuotationItemPO.getQuoteAmount();
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                    quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                }
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuoteAmountSec())) {
                    quoteAmount = QuoteUtil.decode(dIqrQuotationItemPO.getQuoteAmountSec(), dIqrQuotationItemPO.getQuotationId().toString());
                }
                quotationItemBO.setPurchaseNum(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum()));
                quotationItemBO.setQuotePrice(MoneyUtils.Long2BigDecimal((Long)quotePrice));
                quotationItemBO.setQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quoteAmount));
            }
            catch (Exception e) {
                log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
            }
            quotationItemBO.setSupplierId(quotationPO.getSupplierId());
            quotationItemBO.setSupplierName(quotationPO.getSupplierName());
            quotationItemBO.setQuoteRounds(quotationPO.getQuoteRounds());
            quotationItemBO.setQuotationCode(quotationPO.getQuotationCode());
            quotationItemBO.setReviewResult(quotationPO.getReviewResult());
            quotationItemBO.setReviewResultName(this.qryDicAtomService.getDicCodeName("REVIEW_RESULT", quotationPO.getReviewResult() + ""));
            quotationItemBO.setSurplusQuotationTimesStr(rspBO.getSurplusQuotationTimesStr());
            quotationItemBO.setMyQuotePriceStr(quotationItemBO.getQuotePrice() + "(" + quotationItemBO.getReviewResultName() + ")");
            quotationItemInfoList.add(quotationItemBO);
        }
        rspBO.setQuotationItemInfoList(quotationItemInfoList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u62a5\u4ef7\u4fe1\u606f\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

