/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONArray;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.AdduotationBillReqBO;
import com.tydic.enquiry.api.quote.bo.AdduotationBillRspBO;
import com.tydic.enquiry.api.quote.bo.SubmitQuotationBillRspBO;
import com.tydic.enquiry.api.quote.service.AddQuotationBillService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=AddQuotationBillService.class)
public class AddQuotationBillServiceImpl
implements AddQuotationBillService {
    private static final Logger log = LoggerFactory.getLogger(AddQuotationBillServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private SeqIdCreateService seqIdCreateService;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;

    public AdduotationBillRspBO addQuotationBill(AdduotationBillReqBO adduotationBillReqBO) {
        log.info("addQuotationBill::  adduotationBillReqBO=" + adduotationBillReqBO.toString());
        AdduotationBillRspBO rspBO = new AdduotationBillRspBO();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(adduotationBillReqBO.getInquiryId());
        List<DIqrInquiryDetailPO> dIqrInquiryDetailPOList = this.dIqrInquiryDetailMapper.selectByInquiryId(adduotationBillReqBO.getInquiryId());
        DIqrQuotationPO qryQuotationPO = new DIqrQuotationPO();
        qryQuotationPO.setInquiryId(adduotationBillReqBO.getInquiryId());
        qryQuotationPO.setHisStatus("1");
        qryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        qryQuotationPO.setSupplierId(adduotationBillReqBO.getSupplierId());
        qryQuotationPO.setBidsectionId(adduotationBillReqBO.getBidsectionId());
        log.info("addQuotationBill::adduotationBillReqBO.getSupplierId()=" + adduotationBillReqBO.getSupplierId());
        List<DIqrQuotationPO> quotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryQuotationPO);
        if (dIqrInquiryMatePO == null || dIqrInquiryDetailPOList == null || dIqrInquiryDetailPOList.size() <= 0 || dIqrInquiryMatePO.getDocType() == null) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u5b58\u5728\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        log.info("addQuotationBill::adduotationBillReqBO.getDocStatus()=" + adduotationBillReqBO.getDocStatus());
        log.info("addQuotationBill::dIqrInquiryMatePO.getQuoteEndDate()=" + dIqrInquiryMatePO.getQuoteEndDate());
        DIqrInquiryBidsectionPO bidsectionPO = this.dIqrInquiryBidsectionMapper.selectByPrimaryKey(adduotationBillReqBO.getBidsectionId());
        log.info("addQuotationBill::bidsectionPO.getQuoteEndDate()=" + bidsectionPO.getQuoteEndDate());
        Date date0 = new Date();
        if (!dIqrInquiryMatePO.getDocStatus().toString().equals("2006") || date0.compareTo(bidsectionPO.getQuoteEndDate()) >= 0 || date0.compareTo(dIqrInquiryMatePO.getLimitQuoteDate()) < 0) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (quotationPOs == null || quotationPOs.size() <= 0) {
            log.error("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u6ca1\u6709\u5bf9\u5e94\u7684\u62a5\u4ef7\u6570\u636e");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPO quotationPO = quotationPOs.get(0);
        log.info("addQuotationBill::quotationPO.getPayStatus()=" + quotationPO.getPayStatus());
        if (quotationPO.getPayStatus() == null || "1".equals(quotationPO.getPayStatus())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u7ade\u4ef7\u5355\u672a\u7f34\u7eb3\u4fdd\u8bc1\u91d1\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (quotationPOs != null && quotationPOs.size() > 0 && quotationPOs.get(0).getQuoteRounds() != null && bidsectionPO.getLimitTimes() != null && bidsectionPO.getLimitTimes() != 0 && Integer.valueOf(quotationPOs.get(0).getQuoteRounds()) >= bidsectionPO.getLimitTimes()) {
            log.error("\u5f53\u524d\u62a5\u4ef7\u5df2\u63d0\u4ea4\u6216\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\u4e0d\u53ef\u518d\u6b21\u62a5\u4ef7");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u62a5\u4ef7\u5df2\u63d0\u4ea4\u6216\u6b21\u6570\u5df2\u8fbe\u5230\u4e0a\u9650\u4e0d\u53ef\u518d\u6b21\u62a5\u4ef7");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        log.info("addQuotationBill::quotationPO.getQuotationId()=" + quotationPO.getQuotationId());
        List<DIqrQuotationItemPO> dIqrQuotationItemPOList = this.dIqrQuotationItemMapper.selectByQuotationId(quotationPO.getQuotationId());
        DIqrQuotationPO qryInquiryQuotationPO = new DIqrQuotationPO();
        qryInquiryQuotationPO.setInquiryId(adduotationBillReqBO.getInquiryId());
        qryInquiryQuotationPO.setBidsectionId(adduotationBillReqBO.getBidsectionId());
        qryInquiryQuotationPO.setHisStatus("1");
        qryInquiryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
        qryInquiryQuotationPO.setDocStatus(Integer.valueOf("40014"));
        List<DIqrQuotationPO> inquiryQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryInquiryQuotationPO);
        Long mostQuotationId = null;
        List<Object> quotationItemPOs = new ArrayList();
        if (inquiryQuotationPOs != null && inquiryQuotationPOs.size() > 0) {
            BigDecimal price;
            Long quoteAmount = inquiryQuotationPOs.get(0).getAmount();
            log.info("addQuotationBill::quoteAmount=" + quoteAmount);
            if (StringUtils.isNotEmpty((CharSequence)inquiryQuotationPOs.get(0).getAmountSec())) {
                quoteAmount = QuoteUtil.decode(inquiryQuotationPOs.get(0).getAmountSec(), inquiryQuotationPOs.get(0).getQuotationId().toString());
            }
            mostQuotationId = inquiryQuotationPOs.get(0).getQuotationId();
            log.info("addQuotationBill::mostQuotationId=" + mostQuotationId);
            for (DIqrQuotationPO dIqrQuotationPO : inquiryQuotationPOs) {
                Long amount = dIqrQuotationPO.getAmount();
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationPO.getAmountSec())) {
                    amount = QuoteUtil.decode(dIqrQuotationPO.getAmountSec(), dIqrQuotationPO.getQuotationId().toString());
                }
                log.info("addQuotationBill::quoteAmount=" + quoteAmount);
                log.info("addQuotationBill::amount=" + amount);
                if (quoteAmount <= amount) continue;
                mostQuotationId = dIqrQuotationPO.getQuotationId();
            }
            DIqrQuotationItemPO qryQuotationItemPO = new DIqrQuotationItemPO();
            qryQuotationItemPO.setQuotationId(mostQuotationId);
            quotationItemPOs = this.dIqrQuotationItemMapper.selectByQuotationItem(qryQuotationItemPO);
            log.info("addQuotationBill::bidsectionPO.getDecreasePrice()=" + bidsectionPO.getDecreasePrice());
            try {
                price = MoneyUtils.Long2BigDecimal((Long)bidsectionPO.getDecreasePrice());
            }
            catch (Exception e2) {
                log.error("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e2);
                throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e2);
            }
            log.info("addQuotationBill:BigDecimal:price=" + price);
            block7: for (DIqrQuotationItemPO dIqrQuotationItemPO : quotationItemPOs) {
                Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                BigDecimal quotationItemQrice = new BigDecimal("0");
                BigDecimal quotationItemAmount = new BigDecimal("0");
                if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                    quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                }
                log.info("addQuotationBill:quotationItemPOs:quotePrice=" + quotePrice);
                try {
                    if (!"2".equals(dIqrInquiryMatePO.getBusiType()) || !"1".equals(dIqrInquiryMatePO.getOfferIncreaseType())) {
                        if ("2".equals(dIqrInquiryMatePO.getBusiType()) && "2".equals(dIqrInquiryMatePO.getOfferIncreaseType())) {
                            quotationItemQrice = MoneyUtils.Long2BigDecimal((Long)quotePrice).add(price);
                        } else if ("2".equals(dIqrInquiryMatePO.getBusiType()) || !"1".equals(dIqrInquiryMatePO.getOfferIncreaseType())) {
                            log.info("addQuotationBill:MoneyUtils.Long2BigDecimal(quotePrice):quotePrice=" + quotePrice);
                            log.info("addQuotationBill:MoneyUtils.Long2BigDecimal(price):price=" + price);
                            if (MoneyUtils.Long2BigDecimal((Long)quotePrice).compareTo(price) < 0) {
                                log.error("\u5f53\u524d\u62a5\u4ef7\u5df2\u8fbe\u5230\u6700\u4f4e\u4e0d\u53ef\u7ee7\u7eed\u62a5\u4ef7");
                                rspBO.setRespCode("9999");
                                rspBO.setRespDesc("\u5f53\u524d\u62a5\u4ef7\u5df2\u8fbe\u5230\u6700\u4f4e\u4e0d\u53ef\u7ee7\u7eed\u62a5\u4ef7");
                                log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
                                return rspBO;
                            }
                            quotationItemQrice = MoneyUtils.Long2BigDecimal((Long)quotePrice).subtract(price);
                            log.info("addQuotationBill:MoneyUtils.Long2BigDecimal(quotePrice):quotationItemQrice=" + quotationItemQrice);
                        }
                    }
                    log.info("addQuotationBill:dIqrQuotationItemPO.getPurchaseNum()=" + dIqrQuotationItemPO.getPurchaseNum());
                    quotationItemAmount = quotationItemQrice.multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    log.info("addQuotationBill:MoneyUtils.Long2BigDecimal(price):quotationItemAmount=" + quotationItemAmount);
                    for (DIqrQuotationItemPO quotationItemPO : dIqrQuotationItemPOList) {
                        log.info("addQuotationBill:dIqrQuotationItemPO.getInquiryItemId()=" + dIqrQuotationItemPO.getInquiryItemId());
                        log.info("addQuotationBill:quotationItemPO.getInquiryItemId()=" + quotationItemPO.getInquiryItemId());
                        if (quotationItemPO.getInquiryItemId().longValue() != dIqrQuotationItemPO.getInquiryItemId().longValue() || quotationItemPO.getBidsectionId().longValue() != dIqrQuotationItemPO.getBidsectionId().longValue()) continue;
                        log.info(dIqrQuotationItemPO.getInquiryItemId() + "\u62a5\u4ef7\u660e\u7ec6\u62a5\u4ef7\u91d1\u989d\u4e3a\uff1a" + quotationItemQrice);
                        quotationItemPO.setQuoteAmount(0L);
                        quotationItemPO.setQuoteAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationItemAmount), quotationItemPO.getQuotationId().toString()));
                        quotationItemPO.setQuotePrice(0L);
                        quotationItemPO.setQuotePriceSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)quotationItemQrice), quotationItemPO.getQuotationId().toString()));
                        continue block7;
                    }
                }
                catch (Exception e3) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                    log.error("\u62a5\u4ef7\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e3);
                    throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e3);
                }
            }
        } else {
            log.info("addQuotationBill:dIqrInquiryDetailPOList=" + dIqrInquiryDetailPOList);
            if (bidsectionPO != null) {
                log.info("addQuotationBill:bidsectionPO.getBiddingPrice()=" + bidsectionPO.getBiddingPrice());
                log.info("addQuotationBill:bidsectionPO.getBiddingAmount()=" + bidsectionPO.getBiddingAmount());
                Long quotePrice = bidsectionPO.getBiddingPrice();
                Long quoteAmount = bidsectionPO.getBiddingAmount();
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOList) {
                    if (dIqrQuotationItemPO.getBidsectionId().longValue() != bidsectionPO.getBidsectionId().longValue()) continue;
                    log.info(dIqrQuotationItemPO.getBidsectionId() + "\u62a5\u4ef7\u660e\u7ec6\u62a5\u4ef7\u91d1\u989d\u4e3a\uff1a" + quotePrice);
                    dIqrQuotationItemPO.setQuoteAmount(0L);
                    dIqrQuotationItemPO.setQuoteAmountSec(QuoteUtil.encode(quoteAmount, dIqrQuotationItemPO.getQuotationId().toString()));
                    dIqrQuotationItemPO.setQuotePrice(0L);
                    dIqrQuotationItemPO.setQuotePriceSec(QuoteUtil.encode(quotePrice, dIqrQuotationItemPO.getQuotationId().toString()));
                    break;
                }
            }
        }
        adduotationBillReqBO.setQuotationId(quotationPO.getQuotationId());
        DIqrQuotationPO updateStatusPO = new DIqrQuotationPO();
        updateStatusPO.setReviewResult(Constants.REVIEW_RESULT_2);
        updateStatusPO.setInquiryId(quotationPO.getInquiryId());
        updateStatusPO.setBidsectionId(adduotationBillReqBO.getBidsectionId());
        this.dIqrQuotationMapper.updateStatusByInquiryId(updateStatusPO);
        log.info("\u62a5\u4ef7\u660e\u7ec6\u4e3a\uff1a" + JSON.toJSONString(dIqrQuotationItemPOList));
        log.info("\u539f\u59cb\u62a5\u4ef7\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)quotationPO));
        log.info("\u62a5\u4ef7\u4fe1\u606f\u4e3a\uff1a" + JSON.toJSONString((Object)adduotationBillReqBO));
        if (!"40014".equals(quotationPO.getDocStatus().toString())) {
            this.updateQuotationBill(adduotationBillReqBO, dIqrInquiryMatePO.getDocType(), dIqrQuotationItemPOList, dIqrInquiryMatePO.getTotalPriceFlag(), quotationPO);
        } else {
            this.addQuotationBill(adduotationBillReqBO, dIqrInquiryMatePO.getDocType(), dIqrQuotationItemPOList, dIqrInquiryMatePO.getTotalPriceFlag(), quotationPO);
        }
        try {
            Calendar nowTime = Calendar.getInstance();
            nowTime.add(12, bidsectionPO.getDelayEachTime());
            long m = bidsectionPO.getDelayEachTime() * 60 * 1000;
            if (bidsectionPO.getDelayEachTime() != null && nowTime.getTime().after(bidsectionPO.getQuoteEndDate())) {
                DIqrQuotationPO dIqrQuotationPO = new DIqrQuotationPO();
                Date quoteEndDate = new Date(bidsectionPO.getQuoteEndDate().getTime() + m);
                dIqrQuotationPO.setQuoteEndDate(quoteEndDate);
                dIqrQuotationPO.setInquiryId(quotationPO.getInquiryId());
                dIqrQuotationPO.setBidsectionId(quotationPO.getBidsectionId());
                this.dIqrQuotationMapper.updateQuoteEndTimeByInquiryId(dIqrQuotationPO);
            }
            DIqrQuotationPO dIqrQuotationPO = new DIqrQuotationPO();
            dIqrQuotationPO.setInquiryId(adduotationBillReqBO.getInquiryId());
            dIqrQuotationPO.setDocStatus(Integer.valueOf("40014"));
            dIqrQuotationPO.setValidStatus(Constants.IS_VALID_Y);
            dIqrQuotationPO.setHisStatus("1");
            dIqrQuotationPO.setBidsectionId(adduotationBillReqBO.getBidsectionId());
            List<DIqrQuotationPO> dIqrQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(dIqrQuotationPO);
            List<Object> quotationIds = new ArrayList();
            if (!CollectionUtils.isEmpty(dIqrQuotationPOs)) {
                quotationIds = dIqrQuotationPOs.stream().map(e -> e.getQuotationId()).collect(Collectors.toList());
            }
            DIqrInquiryBidsectionPO updateBidsectionPO = new DIqrInquiryBidsectionPO();
            updateBidsectionPO.setQuotationIdsJson(JSONArray.toJSONString(quotationIds));
            updateBidsectionPO.setQuotationNum(quotationIds.size());
            updateBidsectionPO.setInquiryId(adduotationBillReqBO.getInquiryId());
            updateBidsectionPO.setBidsectionId(adduotationBillReqBO.getBidsectionId());
            if (bidsectionPO.getDelayEachTime() != null && nowTime.getTime().after(bidsectionPO.getQuoteEndDate())) {
                Date quoteEndDate = new Date(bidsectionPO.getQuoteEndDate().getTime() + m);
                updateBidsectionPO.setQuoteEndDate(quoteEndDate);
                updateBidsectionPO.setDelayLengthTime(bidsectionPO.getDelayLengthTime() == null ? bidsectionPO.getDelayEachTime() : bidsectionPO.getDelayLengthTime() + bidsectionPO.getDelayEachTime());
                updateBidsectionPO.setDelayCnt(bidsectionPO.getDelayCnt() == null ? 1 : bidsectionPO.getDelayCnt() + 1);
            }
            this.dIqrInquiryBidsectionMapper.updateEndTimeByInqAndBidsectionId(updateBidsectionPO);
        }
        catch (Exception e4) {
            log.error("\u66f4\u65b0\u8be2\u4ef7\u5355\u62a5\u4ef7\u5bb6\u6570\u5931\u8d25:" + e4);
            throw new BusinessException("9999", "\u66f4\u65b0\u8be2\u4ef7\u5355\u62a5\u4ef7\u5bb6\u6570\u5931\u8d25:" + e4.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u63d0\u4ea4\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }

    public SubmitQuotationBillRspBO updateQuotationBill(AdduotationBillReqBO adduotationBillReqBO, String docType, List<DIqrQuotationItemPO> dIqrQuotationItemPOs, String totalPriceFlag, DIqrQuotationPO quotationPO) {
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
        Long quoteAmount = 0L;
        if (!"Y".equals(totalPriceFlag)) {
            try {
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                    BigDecimal itemQuoteAmount = new BigDecimal("0");
                    Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                        quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    itemQuoteAmount = MoneyUtils.Long2BigDecimal((Long)quotePrice).multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    dIqrQuotationItemPO.setQuoteAmount(0L);
                    dIqrQuotationItemPO.setQuoteAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount), dIqrQuotationItemPO.getQuotationId().toString()));
                    quoteAmount = MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount) + quoteAmount;
                }
                updateQuotationPO.setAmount(0L);
                updateQuotationPO.setAmountSec(QuoteUtil.encode(quoteAmount, adduotationBillReqBO.getQuotationId().toString()));
            }
            catch (Exception e) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38," + e);
                throw new BusinessException("9999", "\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            }
        }
        try {
            updateQuotationPO.setAmount(0L);
            updateQuotationPO.setAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)adduotationBillReqBO.getAmount()), adduotationBillReqBO.getQuotationId().toString()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        updateQuotationPO.setSupplierContactName(adduotationBillReqBO.getSupplierContactName());
        updateQuotationPO.setSupplierContactTele(adduotationBillReqBO.getSupplierContactTele());
        updateQuotationPO.setDeliveryDatePromise(DateUtils.strToDateLong((String)adduotationBillReqBO.getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
        updateQuotationPO.setDeliveryIntPromise(adduotationBillReqBO.getDeliveryIntPromise());
        updateQuotationPO.setQuoteExplain(adduotationBillReqBO.getQuoteExplain());
        updateQuotationPO.setQuotationSubmitTime(new Date());
        updateQuotationPO.setDocStatus(Integer.valueOf("40014"));
        updateQuotationPO.setNodeStatus(Integer.valueOf("41013"));
        updateQuotationPO.setQuotationId(adduotationBillReqBO.getQuotationId());
        updateQuotationPO.setQuoteIpAddr(adduotationBillReqBO.getQuoteIpAddr());
        if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
            updateQuotationPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
        } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
            Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
            updateQuotationPO.setQuoteRounds(quoteRounds.toString());
        } else {
            updateQuotationPO.setQuoteRounds("1");
        }
        updateQuotationPO.setQuotationCreateUserId(adduotationBillReqBO.getUserId());
        updateQuotationPO.setQuotationCreateUserName(adduotationBillReqBO.getUsername());
        updateQuotationPO.setReviewResult(Constants.REVIEW_RESULT_1);
        try {
            this.dIqrQuotationMapper.updateByPrimaryKeySelective(updateQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            this.dIqrQuotationItemMapper.updateByIdList(dIqrQuotationItemPOs, adduotationBillReqBO.getQuotationId());
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25:", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u660e\u7ec6\u5355\u5931\u8d25:", (Throwable)e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u66f4\u65b0\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }

    public SubmitQuotationBillRspBO addQuotationBill(AdduotationBillReqBO submitQuotationBillReqBO, String docType, List<DIqrQuotationItemPO> dIqrQuotationItemPOs, String totalPriceFlag, DIqrQuotationPO quotationPO) {
        SubmitQuotationBillRspBO rspBO = new SubmitQuotationBillRspBO();
        DIqrQuotationPO addQuotationPO = new DIqrQuotationPO();
        BeanUtils.copyProperties((Object)quotationPO, (Object)addQuotationPO);
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("RISUN01");
        seqEnquiryReqBO.setSeqType("4");
        SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        Long quotationId = seqEnquiryPubRspBO.getDocId();
        HashMap<String, Long> pkgQuoteAmountMap = new HashMap<String, Long>();
        Long quoteAmount = 0L;
        if (!"Y".equals(totalPriceFlag)) {
            try {
                for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                    BigDecimal itemQuoteAmount = new BigDecimal("0");
                    Long quotePrice = dIqrQuotationItemPO.getQuotePrice();
                    if (StringUtils.isNotEmpty((CharSequence)dIqrQuotationItemPO.getQuotePriceSec())) {
                        quotePrice = QuoteUtil.decode(dIqrQuotationItemPO.getQuotePriceSec(), dIqrQuotationItemPO.getQuotationId().toString());
                    }
                    itemQuoteAmount = MoneyUtils.Long2BigDecimal((Long)quotePrice).multiply(MoneyUtils.Long2BigDecimal((Long)dIqrQuotationItemPO.getPurchaseNum())).setScale(2, 4);
                    dIqrQuotationItemPO.setQuoteAmount(0L);
                    dIqrQuotationItemPO.setQuoteAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount), dIqrQuotationItemPO.getQuotationId().toString()));
                    quoteAmount = MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount) + quoteAmount;
                    if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.size() <= 0) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount));
                    } else if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId()) && pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId()) == null) {
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount));
                    } else if (StringUtils.isNotBlank((CharSequence)dIqrQuotationItemPO.getInquiryPkgId())) {
                        Long pkgQuoteAmount = (Long)pkgQuoteAmountMap.get(dIqrQuotationItemPO.getInquiryPkgId());
                        pkgQuoteAmount = pkgQuoteAmount + MoneyUtils.BigDecimal2Long((BigDecimal)itemQuoteAmount);
                        pkgQuoteAmountMap.put(dIqrQuotationItemPO.getInquiryPkgId(), pkgQuoteAmount);
                    }
                    dIqrQuotationItemPO.setQuotationId(quotationId);
                }
                addQuotationPO.setAmount(0L);
                addQuotationPO.setAmountSec(QuoteUtil.encode(quoteAmount, quotationId.toString()));
            }
            catch (Exception e) {
                log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
                throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        try {
            addQuotationPO.setAmount(MoneyUtils.BigDecimal2Long((BigDecimal)submitQuotationBillReqBO.getAmount()));
            addQuotationPO.setAmount(0L);
            addQuotationPO.setAmountSec(QuoteUtil.encode(MoneyUtils.BigDecimal2Long((BigDecimal)submitQuotationBillReqBO.getAmount()), quotationId.toString()));
        }
        catch (Exception e) {
            log.error("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u6216\u8ba1\u7b97\u5f02\u5e38");
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5355\u5931\u8d25\uff1a", (Throwable)e);
        }
        addQuotationPO.setSupplierContactName(submitQuotationBillReqBO.getSupplierContactName());
        addQuotationPO.setSupplierContactTele(submitQuotationBillReqBO.getSupplierContactTele());
        addQuotationPO.setDeliveryDatePromise(DateUtils.strToDateLong((String)submitQuotationBillReqBO.getDeliveryDatePromise(), (String)"yyyy-MM-dd HH:mm:ss"));
        addQuotationPO.setDeliveryIntPromise(submitQuotationBillReqBO.getDeliveryIntPromise());
        addQuotationPO.setQuoteExplain(submitQuotationBillReqBO.getQuoteExplain());
        addQuotationPO.setQuotationSubmitTime(new Date());
        addQuotationPO.setDocStatus(Integer.valueOf("40014"));
        addQuotationPO.setNodeStatus(Integer.valueOf("41013"));
        addQuotationPO.setQuotationId(quotationId);
        addQuotationPO.setQuoteIpAddr(submitQuotationBillReqBO.getQuoteIpAddr());
        if ("22".equals(docType) && quotationPO.getQuoteTimeLimit() != null) {
            addQuotationPO.setQuoteRounds(quotationPO.getQuoteTimeLimit().toString());
        } else if (StringUtils.isNotEmpty((CharSequence)quotationPO.getQuoteRounds())) {
            Integer quoteRounds = Integer.valueOf(quotationPO.getQuoteRounds()) + 1;
            addQuotationPO.setQuoteRounds(quoteRounds.toString());
        } else {
            addQuotationPO.setQuoteRounds("1");
        }
        addQuotationPO.setQuotationCreateUserId(submitQuotationBillReqBO.getUserId());
        addQuotationPO.setQuotationCreateUserName(submitQuotationBillReqBO.getUsername());
        addQuotationPO.setLastRoundQuotationId(submitQuotationBillReqBO.getQuotationId());
        addQuotationPO.setReviewResult(Constants.REVIEW_RESULT_1);
        try {
            for (DIqrQuotationItemPO dIqrQuotationItemPO : dIqrQuotationItemPOs) {
                dIqrQuotationItemPO.setQuotationId(quotationId);
            }
            this.dIqrQuotationItemMapper.insertBatch(dIqrQuotationItemPOs);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25");
            log.error("\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u62a5\u4ef7\u660e\u7ec6\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            this.dIqrQuotationMapper.insertSelective(addQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25");
            log.error("\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
        }
        try {
            DIqrQuotationPO updateQuotationPO = new DIqrQuotationPO();
            updateQuotationPO.setHisStatus("2");
            updateQuotationPO.setQuotationId(submitQuotationBillReqBO.getQuotationId());
            this.dIqrQuotationMapper.updateByPrimaryKeySelective(updateQuotationPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25");
            log.error("\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
            throw new BusinessException("9999", "\u66f4\u65b0\u62a5\u4ef7\u5931\u8d25\uff1a", (Throwable)e);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u5355\u65b0\u589e\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

