/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.QryMostQuotationBillPkgListReqBO;
import com.tydic.enquiry.api.quote.bo.QryMostQuotationBillPkgListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationPackageBO;
import com.tydic.enquiry.api.quote.service.QryMostQuotationBillPkgListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=QryMostQuotationBillPkgListService.class)
public class QryMostQuotationBillPkgListServiceImpl
implements QryMostQuotationBillPkgListService {
    private static final Logger log = LoggerFactory.getLogger(QryMostQuotationBillPkgListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;

    public QryMostQuotationBillPkgListRspBO qryMostQuotationBillPkgList(QryMostQuotationBillPkgListReqBO reqBO) {
        QuotationPackageBO quotationPackageBO;
        QryMostQuotationBillPkgListRspBO rspBO = new QryMostQuotationBillPkgListRspBO();
        ArrayList<QuotationPackageBO> quotePackageList = new ArrayList<QuotationPackageBO>();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
        if (dIqrInquiryMatePO == null || dIqrInquiryMatePO.getDocType() == null || !"23".equals(dIqrInquiryMatePO.getDocType())) {
            log.error("\u6b64\u6267\u884c\u5355\u4e0d\u5b58\u5728");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u4e0d\u5b58\u5728\u6216\u8005\u6b64\u6267\u884c\u5355\u4e0d\u4e3a\u7ade\u4ef7\u5355\u4e0d\u5b58\u5728\u5305\u62a5\u4ef7\u4fe1\u606f");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
        dIqrQuotationPkgPO.setInquiryId(reqBO.getInquiryId());
        dIqrQuotationPkgPO.setHisStatus("1");
        dIqrQuotationPkgPO.setDocStatus(Integer.valueOf("4002"));
        dIqrQuotationPkgPO.setValidStatus(Constants.IS_VALID_Y);
        List<DIqrQuotationPkgPO> dIqrQuotationPkgPOList = this.dIqrQuotationPkgMapper.selectByInquiryIdStatusForList(dIqrQuotationPkgPO);
        if (CollectionUtils.isEmpty(dIqrQuotationPkgPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u5bf9\u5e94\u7684\u5206\u5305\u6682\u65e0\u62a5\u4ef7");
            rspBO.setQuotePackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        HashMap<String, DIqrQuotationPkgPO> pkgLowestAmountMap = new HashMap<String, DIqrQuotationPkgPO>();
        HashMap<String, DIqrQuotationPkgPO> pkgHighestAmountMap = new HashMap<String, DIqrQuotationPkgPO>();
        for (DIqrQuotationPkgPO quotationPkgPO : dIqrQuotationPkgPOList) {
            Long amount = quotationPkgPO.getAmount();
            if (StringUtils.isNotEmpty((CharSequence)quotationPkgPO.getAmountSec())) {
                amount = QuoteUtil.decode(quotationPkgPO.getAmountSec(), quotationPkgPO.getQuotationId().toString());
            }
            quotationPkgPO.setAmount(amount);
            if (pkgLowestAmountMap == null || pkgLowestAmountMap.size() <= 0 || pkgLowestAmountMap.get(quotationPkgPO.getInquiryPkgId()) == null) {
                pkgLowestAmountMap.put(quotationPkgPO.getInquiryPkgId(), quotationPkgPO);
            } else if (((DIqrQuotationPkgPO)pkgLowestAmountMap.get(quotationPkgPO.getInquiryPkgId())).getAmount() > amount) {
                pkgLowestAmountMap.put(quotationPkgPO.getInquiryPkgId(), quotationPkgPO);
            }
            if (pkgHighestAmountMap == null || pkgHighestAmountMap.size() <= 0 || pkgHighestAmountMap.get(quotationPkgPO.getInquiryPkgId()) == null) {
                pkgHighestAmountMap.put(quotationPkgPO.getInquiryPkgId(), quotationPkgPO);
                continue;
            }
            if (((DIqrQuotationPkgPO)pkgHighestAmountMap.get(quotationPkgPO.getInquiryPkgId())).getAmount() >= amount) continue;
            pkgHighestAmountMap.put(quotationPkgPO.getInquiryPkgId(), quotationPkgPO);
        }
        if (reqBO.getTypeId() != null && reqBO.getTypeId() == 1) {
            for (DIqrQuotationPkgPO quotationPkgPO : pkgHighestAmountMap.values()) {
                quotationPackageBO = new QuotationPackageBO();
                BeanUtils.copyProperties((Object)quotationPkgPO, (Object)quotationPackageBO);
                quotationPackageBO.setInquiryId(quotationPkgPO.getInquiryId());
                quotationPackageBO.setInquiryPkgId(quotationPkgPO.getInquiryPkgId());
                quotationPackageBO.setPkgOrderNo(quotationPkgPO.getInquiryPkgId());
                try {
                    quotationPackageBO.setLastTimeQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                    quotationPackageBO.setHighestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                }
                catch (Exception e1) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38", (Throwable)e1);
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                quotationPackageBO.setDetailNum(quotationPkgPO.getQuotePkgDetailNum());
                quotationPackageBO.setQuotationId(quotationPkgPO.getQuotationId());
                quotePackageList.add(quotationPackageBO);
            }
        } else {
            for (DIqrQuotationPkgPO quotationPkgPO : pkgLowestAmountMap.values()) {
                quotationPackageBO = new QuotationPackageBO();
                BeanUtils.copyProperties((Object)quotationPkgPO, (Object)quotationPackageBO);
                quotationPackageBO.setInquiryId(quotationPkgPO.getInquiryId());
                quotationPackageBO.setInquiryPkgId(quotationPkgPO.getInquiryPkgId());
                quotationPackageBO.setPkgOrderNo(quotationPkgPO.getInquiryPkgId());
                try {
                    quotationPackageBO.setLastTimeQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                    quotationPackageBO.setLowestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                    quotationPackageBO.setAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                }
                catch (Exception e1) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38", (Throwable)e1);
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                quotationPackageBO.setDetailNum(quotationPkgPO.getQuotePkgDetailNum());
                quotationPackageBO.setQuotationId(quotationPkgPO.getQuotationId());
                quotePackageList.add(quotationPackageBO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u67e5\u8be2\u6210\u529f");
        rspBO.setQuotePackageList(quotePackageList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

