/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.BidsectionInfoBO;
import com.tydic.enquiry.api.quote.bo.CreateQuotationBillByRegistReqBO;
import com.tydic.enquiry.api.quote.bo.CreateQuotationBillByRegistRspBO;
import com.tydic.enquiry.api.quote.bo.QuoteInquiryDatailBO;
import com.tydic.enquiry.api.quote.bo.QuoteRegistItemBO;
import com.tydic.enquiry.api.quote.service.CreateQuotationBillByRegistService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=CreateQuotationBillByRegistService.class)
public class CreateQuotationBillByRegistServiceImpl
implements CreateQuotationBillByRegistService {
    private static final Logger log = LoggerFactory.getLogger(CreateQuotationBillByRegistServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private SeqIdCreateService seqIdCreateService;

    public CreateQuotationBillByRegistRspBO CreateQuotationBillByRegist(CreateQuotationBillByRegistReqBO reqBO) {
        CreateQuotationBillByRegistRspBO rspBO = new CreateQuotationBillByRegistRspBO();
        Date date0 = new Date();
        if (date0.compareTo(DateUtils.strToDateLong((String)reqBO.getQuoteExecOrderDetailBO().getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss")) >= 0) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f53\u524d\u6267\u884c\u5355\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            log.error("\u5f53\u524d\u6267\u884c\u5355\u4e0d\u4e3a\u62a5\u4ef7\u4e2d\u6216\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
            throw new BusinessException("9999", "\u5f53\u524d\u6267\u884c\u5355\u5df2\u8fc7\u62a5\u4ef7\u622a\u6b62\u65f6\u95f4\u4e0d\u53ef\u4ee5\u62a5\u4ef7");
        }
        try {
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getQuoteRegistItemBOList())) {
                ArrayList<DIqrQuotationPO> quotationPOList = new ArrayList<DIqrQuotationPO>();
                ArrayList<DIqrQuotationItemPO> record = new ArrayList<DIqrQuotationItemPO>();
                for (QuoteRegistItemBO quoteRegistItemBO : reqBO.getQuoteRegistItemBOList()) {
                    DIqrQuotationPO dIqrQuotationPO = new DIqrQuotationPO();
                    BeanUtils.copyProperties((Object)reqBO.getQuoteExecOrderDetailBO(), (Object)dIqrQuotationPO);
                    BeanUtils.copyProperties((Object)reqBO.getQuoteRegistIqrDocBO(), (Object)dIqrQuotationPO);
                    if (StringUtils.isNotEmpty((CharSequence)reqBO.getQuoteExecOrderDetailBO().getQuoteEndDate())) {
                        dIqrQuotationPO.setQuoteEndDate(DateUtils.strToDateLong((String)reqBO.getQuoteExecOrderDetailBO().getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)reqBO.getQuoteExecOrderDetailBO().getLimitQuoteDate())) {
                        dIqrQuotationPO.setLimitQuoteDate(DateUtils.strToDateLong((String)reqBO.getQuoteExecOrderDetailBO().getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)reqBO.getQuoteRegistIqrDocBO().getRegistTime())) {
                        dIqrQuotationPO.setLimitQuoteDate(DateUtils.strToDateLong((String)reqBO.getQuoteRegistIqrDocBO().getRegistTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                    }
                    SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                    seqEnquiryReqBO.setSystemId("RISUN01");
                    seqEnquiryReqBO.setSeqType("4");
                    SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                    Long quotationId = seqEnquiryPubRspBO.getDocId();
                    dIqrQuotationPO.setQuotationId(quotationId);
                    dIqrQuotationPO.setHisStatus("1");
                    dIqrQuotationPO.setValidStatus(Constants.IS_VALID_Y);
                    dIqrQuotationPO.setNodeStatus(Integer.valueOf("41011"));
                    dIqrQuotationPO.setDocStatus(Integer.valueOf("40011"));
                    dIqrQuotationPO.setQuoteRounds("0");
                    dIqrQuotationPO.setQuotationCreateTime(new Date());
                    dIqrQuotationPO.setQuoteTimeLimit(reqBO.getQuoteExecOrderDetailBO().getQuoteTimeLimit());
                    int i = (int)(Math.random() * 900.0 + 100.0);
                    String quotationCode = Integer.toString(i);
                    dIqrQuotationPO.setQuotationCode(quotationCode);
                    dIqrQuotationPO.setBidsectionId(quoteRegistItemBO.getBidsectionId());
                    SeqEnquiryReqBO seqEnquiryReq = new SeqEnquiryReqBO();
                    seqEnquiryReq.setSystemId("RISUN01");
                    seqEnquiryReq.setSeqType("42");
                    SeqEnquiryRspBO seqEnquiryPubRsp = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                    DIqrQuotationItemPO dIqrQuotationItemPO = new DIqrQuotationItemPO();
                    for (QuoteInquiryDatailBO quoteInquiryDatailBO : reqBO.getQuoteInquiryDatailBOList()) {
                        if (quoteInquiryDatailBO.getInquiryItemId().longValue() != quoteRegistItemBO.getInquiryItemId().longValue()) continue;
                        BeanUtils.copyProperties((Object)quoteInquiryDatailBO, (Object)dIqrQuotationItemPO);
                        break;
                    }
                    dIqrQuotationItemPO.setQuotationItemId(seqEnquiryPubRsp.getDocId());
                    dIqrQuotationItemPO.setBidsectionId(quoteRegistItemBO.getBidsectionId());
                    dIqrQuotationItemPO.setQuotationId(quotationId);
                    if (CollectionUtils.isNotEmpty((Collection)reqBO.getBidsectionInfoBOList())) {
                        for (BidsectionInfoBO bidsectionInfoBO : reqBO.getBidsectionInfoBOList()) {
                            if (!bidsectionInfoBO.getBidsectionId().equals(quoteRegistItemBO.getBidsectionId())) continue;
                            dIqrQuotationPO.setMarginAmount(MoneyUtils.BigDecimal2Long((BigDecimal)bidsectionInfoBO.getMarginAmount()));
                            dIqrQuotationItemPO.setBudgetPrice(MoneyUtils.BigDecimal2Long((BigDecimal)bidsectionInfoBO.getBiddingPrice()));
                            dIqrQuotationItemPO.setPurchaseNum(MoneyUtils.BigDecimal2Long((BigDecimal)bidsectionInfoBO.getBidNumber()));
                            dIqrQuotationItemPO.setBudgetAmount(MoneyUtils.BigDecimal2Long((BigDecimal)bidsectionInfoBO.getBiddingPrice().multiply(bidsectionInfoBO.getBidNumber())));
                            break;
                        }
                    }
                    quotationPOList.add(dIqrQuotationPO);
                    record.add(dIqrQuotationItemPO);
                }
                this.dIqrQuotationMapper.insertBatch(quotationPOList);
                this.dIqrQuotationItemMapper.insertBatch(record);
            }
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u62a5\u4ef7\u4fe1\u606f\u5931\u8d25:" + e);
            throw new BusinessException("9999", "\u65b0\u589e\u62a5\u4ef7\u4fe1\u606f\u5931\u8d25:" + e.getMessage());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u62a5\u4ef7\u751f\u6210\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

