/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.quote.bo.QryDemanderQuotationBillPkgListReqBO;
import com.tydic.enquiry.api.quote.bo.QryDemanderQuotationBillPkgListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationPackageBO;
import com.tydic.enquiry.api.quote.service.QryDemanderQuotationBillPkgListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateItemMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryMateItemPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=QryDemanderQuotationBillPkgListService.class)
public class QryDemanderQuotationBillPkgListServiceImpl
implements QryDemanderQuotationBillPkgListService {
    private static final Logger log = LoggerFactory.getLogger(QryDemanderQuotationBillPkgListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryMateItemMapper dIqrInquiryMateItemMapper;

    public QryDemanderQuotationBillPkgListRspBO qryDemanderQuotationBillPkgList(QryDemanderQuotationBillPkgListReqBO reqBO) {
        QryDemanderQuotationBillPkgListRspBO rspBO = new QryDemanderQuotationBillPkgListRspBO();
        ArrayList<QuotationPackageBO> quotePackageList = new ArrayList<QuotationPackageBO>();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
        if (dIqrInquiryMatePO == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        if (dIqrInquiryMatePO.getDelayCnt() != null && dIqrInquiryMatePO.getDelayCnt() > 0) {
            rspBO.setIsDelay(Integer.valueOf(1));
        }
        rspBO.setDelayCnt(dIqrInquiryMatePO.getDelayCnt());
        rspBO.setDelayLengthTime(dIqrInquiryMatePO.getDelayLengthTime());
        rspBO.setLimitQuoteDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        rspBO.setQuoteEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        List<DIqrInquiryMateItemPO> dIqrInquiryMateItemPOList = this.dIqrInquiryMateItemMapper.selectInquiryItemByInquiryId(reqBO.getInquiryId());
        if (CollectionUtils.isEmpty(dIqrInquiryMateItemPOList)) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u4e0d\u5b58\u5728\u5305\u4fe1\u606f\uff01\uff01\uff01");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        for (DIqrInquiryMateItemPO dIqrInquiryMateItemPO : dIqrInquiryMateItemPOList) {
            QuotationPackageBO quotationPackageBO = new QuotationPackageBO();
            quotationPackageBO.setInquiryId(dIqrInquiryMateItemPO.getInquiryId());
            quotationPackageBO.setInquiryPkgId(dIqrInquiryMateItemPO.getInquiryPkgId());
            quotationPackageBO.setPkgOrderNo(dIqrInquiryMateItemPO.getInquiryPkgId());
            quotationPackageBO.setPkgCreateDate(DateUtils.dateToStr((Date)dIqrInquiryMateItemPO.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            try {
                quotationPackageBO.setPkgTotalAmount(MoneyUtils.Long2BigDecimal((Long)dIqrInquiryMateItemPO.getPkgTotalAmount()));
            }
            catch (Exception e) {
                log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
            }
            quotationPackageBO.setDetailNum(dIqrInquiryMateItemPO.getDetailNum());
            quotePackageList.add(quotationPackageBO);
        }
        DIqrQuotationPO quotationPO = new DIqrQuotationPO();
        ArrayList<Integer> docStatusList = new ArrayList<Integer>();
        docStatusList.add(Integer.valueOf("4002"));
        docStatusList.add(Integer.valueOf("4004"));
        docStatusList.add(Integer.valueOf("4006"));
        quotationPO.setInquiryId(reqBO.getInquiryId());
        quotationPO.setValidStatus(Constants.IS_VALID_Y);
        quotationPO.setHisStatus("1");
        quotationPO.setDocStatusList(docStatusList);
        List<DIqrQuotationPO> effectiveQuotationPOList = this.dIqrQuotationMapper.selectQuotationByPrimary(quotationPO);
        if (CollectionUtils.isEmpty(effectiveQuotationPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        HashMap<Long, DIqrQuotationPO> effectiveQuotationPOMap = new HashMap<Long, DIqrQuotationPO>();
        for (DIqrQuotationPO dIqrQuotationPO : effectiveQuotationPOList) {
            effectiveQuotationPOMap.put(dIqrQuotationPO.getQuotationId(), dIqrQuotationPO);
        }
        DIqrQuotationPkgPO dIqrQuotationPkgPO = new DIqrQuotationPkgPO();
        dIqrQuotationPkgPO.setInquiryId(reqBO.getInquiryId());
        dIqrQuotationPkgPO.setValidStatus(Constants.IS_VALID_Y);
        dIqrQuotationPkgPO.setHisStatus("1");
        dIqrQuotationPkgPO.setDocStatusList(docStatusList);
        List<DIqrQuotationPkgPO> dIqrQuotationPkgPOList = this.dIqrQuotationPkgMapper.selectByInquiryIdStatusForList(dIqrQuotationPkgPO);
        if (CollectionUtils.isEmpty(dIqrQuotationPkgPOList)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u6682\u65e0\u62a5\u4ef7");
            rspBO.setPackageList(quotePackageList);
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        HashMap<String, DIqrQuotationPkgPO> pkgLowestAmountMap = new HashMap<String, DIqrQuotationPkgPO>();
        HashMap<String, DIqrQuotationPkgPO> pkgHighestAmountMap = new HashMap<String, DIqrQuotationPkgPO>();
        for (DIqrQuotationPkgPO quotationPkgPO : dIqrQuotationPkgPOList) {
            Long amount = quotationPkgPO.getAmount();
            if (StringUtils.isNotEmpty((CharSequence)quotationPkgPO.getAmountSec())) {
                amount = QuoteUtil.decode(quotationPkgPO.getAmountSec(), quotationPkgPO.getQuotationId().toString());
            }
            quotationPkgPO.setAmount(amount);
            if (pkgLowestAmountMap == null || pkgLowestAmountMap.size() <= 0 || pkgLowestAmountMap.get(quotationPkgPO.getInquiryPkgId()) == null) {
                pkgLowestAmountMap.put(quotationPkgPO.getInquiryPkgId(), quotationPkgPO);
            } else if (((DIqrQuotationPkgPO)pkgLowestAmountMap.get(quotationPkgPO.getInquiryPkgId())).getAmount() > amount) {
                pkgLowestAmountMap.put(quotationPkgPO.getInquiryPkgId(), quotationPkgPO);
            }
            if (pkgHighestAmountMap == null || pkgHighestAmountMap.size() <= 0 || pkgHighestAmountMap.get(quotationPkgPO.getInquiryPkgId()) == null) {
                pkgHighestAmountMap.put(quotationPkgPO.getInquiryPkgId(), quotationPkgPO);
                continue;
            }
            if (((DIqrQuotationPkgPO)pkgHighestAmountMap.get(quotationPkgPO.getInquiryPkgId())).getAmount() >= amount) continue;
            pkgHighestAmountMap.put(quotationPkgPO.getInquiryPkgId(), quotationPkgPO);
        }
        for (QuotationPackageBO quotationPackageBO : quotePackageList) {
            DIqrQuotationPkgPO quotationPkgPO;
            DIqrQuotationPO dIqrQuotationPO;
            if ("2".equals(dIqrInquiryMatePO.getDocType()) && pkgHighestAmountMap.get(quotationPackageBO.getInquiryPkgId()) != null) {
                dIqrQuotationPO = (DIqrQuotationPO)effectiveQuotationPOMap.get(quotationPackageBO.getQuotationId());
                quotationPkgPO = (DIqrQuotationPkgPO)pkgHighestAmountMap.get(quotationPackageBO.getInquiryPkgId());
                try {
                    quotationPackageBO.setInquiryId(quotationPkgPO.getInquiryId());
                    quotationPackageBO.setMostQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                    quotationPackageBO.setAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                    quotationPackageBO.setHighestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                    quotationPackageBO.setLastTimeQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                    quotationPackageBO.setQuotationId(quotationPkgPO.getQuotationId());
                    quotationPackageBO.setSupplierId(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierId() : null);
                    quotationPackageBO.setSupplierName(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierName() : null);
                    quotationPackageBO.setQuoteIpAddr(dIqrQuotationPO.getQuoteIpAddr());
                    quotationPackageBO.setQuotationSubmitTime(dIqrQuotationPO != null ? DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
                }
                catch (Exception e) {
                    log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                    rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
                }
                continue;
            }
            if (pkgLowestAmountMap.get(quotationPackageBO.getInquiryPkgId()) == null) continue;
            dIqrQuotationPO = (DIqrQuotationPO)effectiveQuotationPOMap.get(quotationPackageBO.getQuotationId());
            quotationPkgPO = (DIqrQuotationPkgPO)pkgLowestAmountMap.get(quotationPackageBO.getInquiryPkgId());
            try {
                quotationPackageBO.setInquiryId(quotationPkgPO.getInquiryId());
                quotationPackageBO.setMostQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                quotationPackageBO.setAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                quotationPackageBO.setLowestQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                quotationPackageBO.setLastTimeQuoteAmount(MoneyUtils.Long2BigDecimal((Long)quotationPkgPO.getAmount()));
                quotationPackageBO.setQuotationId(quotationPkgPO.getQuotationId());
                quotationPackageBO.setSupplierId(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierId() : null);
                quotationPackageBO.setSupplierName(dIqrQuotationPO != null ? dIqrQuotationPO.getSupplierName() : null);
                quotationPackageBO.setQuoteIpAddr(dIqrQuotationPO.getQuoteIpAddr());
                quotationPackageBO.setQuotationSubmitTime(dIqrQuotationPO != null ? DateUtils.dateToStr((Date)dIqrQuotationPO.getQuotationSubmitTime(), (String)"yyyy-MM-dd HH:mm:ss") : null);
            }
            catch (Exception e) {
                log.error("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38" + e.getStackTrace());
                rspBO.setRespDesc("\u91d1\u989d\u8f6c\u5316\u5f02\u5e38");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6b64\u6267\u884c\u5355\u5305\u62a5\u4ef7\u4fe1\u606f\u67e5\u8be2\u6210\u529f");
        rspBO.setPackageList(quotePackageList);
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

