/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillListReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationBillBO;
import com.tydic.enquiry.api.quote.service.QrySupBidEndListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=QrySupBidEndListService.class)
public class QrySupBidEndListServiceImpl
implements QrySupBidEndListService {
    private static final Logger log = LoggerFactory.getLogger(QrySupBidEndListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    public QryQuotationBillListRspBO qrySupBidEndList(QryQuotationBillListReqBO qryQuotationBillListReqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aqryQuotationBillListReqBO=" + qryQuotationBillListReqBO.toString());
        Page page = new Page(qryQuotationBillListReqBO.getPageNo().intValue(), qryQuotationBillListReqBO.getPageSize().intValue());
        QryQuotationBillListRspBO rspBO = new QryQuotationBillListRspBO();
        ArrayList<QuotationBillBO> quotationBillBOList = new ArrayList<QuotationBillBO>();
        Date nowDate = new Date();
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("inquiryCode", qryQuotationBillListReqBO.getInquiryCode());
        map.put("inquiryName", qryQuotationBillListReqBO.getInquiryName());
        Date limitQuoteDate = DateUtils.strToDate((String)qryQuotationBillListReqBO.getLimitQuoteDate(), (String)"yyyyMMddHHmmss");
        map.put("limitQuoteDate", limitQuoteDate);
        map.put("quoteEndDate", nowDate);
        map.put("supplierId", qryQuotationBillListReqBO.getSupplierId());
        List<DIqrInquiryMatePO> inquiryMatePOList = this.dIqrInquiryMateMapper.qryInquiryListForBidEnd(map, (Page<DIqrInquiryMatePO>)page);
        for (DIqrInquiryMatePO matePO : inquiryMatePOList) {
            QuotationBillBO quotationBillBO = new QuotationBillBO();
            quotationBillBO.setInquiryId(matePO.getInquiryId());
            quotationBillBO.setInquiryCode(matePO.getInquiryCode());
            quotationBillBO.setInquiryName(matePO.getInquiryName());
            quotationBillBO.setLimitQuoteDate(DateUtils.dateToStr((Date)matePO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationBillBO.setQuoteEndDate(DateUtils.dateToStr((Date)matePO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            quotationBillBO.setDocStatusName(this.qryDicAtomService.getDicCodeName("QUOTE_DOC_STATUS", matePO.getDocStatus() + ""));
            quotationBillBO.setBusiTypeName(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", matePO.getBusiType() + ""));
            quotationBillBO.setDocTypeName(this.qryDicAtomService.getDicCodeName("DOC_TYPE", matePO.getDocType() + ""));
            DIqrRegistDocPO dIqrRegistDocPO = this.dIqrRegistDocMapper.selectRegistDocByInquiryIdSupId(matePO.getInquiryId(), qryQuotationBillListReqBO.getSupplierId());
            if (dIqrRegistDocPO != null) {
                quotationBillBO.setPayStatusName(this.qryDicAtomService.getDicCodeName("PAY_STATUS", dIqrRegistDocPO.getPayStatus() + ""));
                int registBidCnt = 0;
                int successBidCnt = 0;
                List<DIqrRegistDetailPO> registDetailPOList = this.dIqrRegistDetailMapper.selectByRegistId(dIqrRegistDocPO.getRegistId());
                if (CollectionUtils.isNotEmpty(registDetailPOList)) {
                    registBidCnt = registDetailPOList.size();
                }
                DIqrQuotationPO qryQuotationPO = new DIqrQuotationPO();
                qryQuotationPO.setInquiryId(matePO.getInquiryId());
                qryQuotationPO.setHisStatus("1");
                qryQuotationPO.setValidStatus(Constants.IS_VALID_Y);
                qryQuotationPO.setSupplierId(qryQuotationBillListReqBO.getSupplierId());
                qryQuotationPO.setReviewResult(Constants.REVIEW_RESULT_1);
                List<DIqrQuotationPO> quotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(qryQuotationPO);
                if (CollectionUtils.isNotEmpty(quotationPOs)) {
                    successBidCnt = quotationPOs.size();
                }
                if (successBidCnt == 0) {
                    quotationBillBO.setReviewResultName("\u975e\u6301\u6709");
                } else if (successBidCnt == registBidCnt) {
                    quotationBillBO.setReviewResultName("\u6301\u6709");
                } else {
                    quotationBillBO.setReviewResultName("\u90e8\u5206\u6301\u6709");
                }
            }
            quotationBillBOList.add(quotationBillBO);
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(quotationBillBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
        return rspBO;
    }
}

