/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.dealNotice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.dealNotice.bo.CreateDealNoticeReqBO;
import com.tydic.enquiry.api.dealNotice.bo.CreateDealNoticeRspBO;
import com.tydic.enquiry.api.dealNotice.service.CreateDealNoticeService;
import com.tydic.enquiry.api.quoteFinish.bo.CompareIpAddrReqBO;
import com.tydic.enquiry.api.quoteFinish.bo.CompareIpAddrRspBO;
import com.tydic.enquiry.api.quoteFinish.service.CompareIpAddrService;
import com.tydic.enquiry.api.sequence.bo.CodeEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.CodeEnquiryRspBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqCodeCreateService;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrDealNoticeItemMapper;
import com.tydic.enquiry.dao.DIqrDealNoticeMapper;
import com.tydic.enquiry.dao.DIqrDealNoticePkgMapper;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrDealNoticeItemPO;
import com.tydic.enquiry.po.DIqrDealNoticePO;
import com.tydic.enquiry.po.DIqrDealNoticePkgPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrQuotationPkgPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=CreateDealNoticeService.class)
public class CreateDealNoticeServiceImpl
implements CreateDealNoticeService {
    private static final Logger log = LoggerFactory.getLogger(CreateDealNoticeServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private DIqrDealNoticeMapper dIqrDealNoticeMapper;
    @Autowired
    private DIqrDealNoticeItemMapper dIqrDealNoticeItemMapper;
    @Autowired
    private DIqrDealNoticePkgMapper dIqrDealNoticePkgMapper;
    @Autowired
    private CompareIpAddrService compareIpAddrService;
    @Autowired
    private SeqIdCreateService seqIdCreateService;
    @Autowired
    private SeqCodeCreateService seqCodeCreateService;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    public CreateDealNoticeRspBO createDealNotice(CreateDealNoticeReqBO reqBO) {
        CreateDealNoticeRspBO rspBO = new CreateDealNoticeRspBO();
        try {
            if (reqBO.getInquiryId() == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                return rspBO;
            }
            Long inquiryId = reqBO.getInquiryId();
            ArrayList<Long> inquiryItemIds = new ArrayList<Long>();
            ArrayList<Long> quoteIds = new ArrayList<Long>();
            ArrayList<Long> supIds = new ArrayList<Long>();
            DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
            if (inquiryMatePO == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u6267\u884c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            if (inquiryMatePO.getDocStatus() == null || !"2005".equals(inquiryMatePO.getDocStatus().toString())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u6267\u884c\u5355\u4e0d\u7b26\u5408\u6761\u4ef6\u4e0d\u80fd\u751f\u6210\u6210\u4ea4\u901a\u77e5\u4e66\uff01");
                return rspBO;
            }
            reqBO.setQuoteMethod(inquiryMatePO.getQuoteMethod());
            rspBO = this.initParam(reqBO);
            if ("9999".equals(rspBO.getRespCode())) {
                return rspBO;
            }
            List<Object> quotationFXS = new ArrayList();
            DIqrQuotationPO quotationZD = null;
            String busiType = inquiryMatePO.getBusiType();
            String docType = inquiryMatePO.getDocType();
            Date date = new Date();
            if ("2".equals(reqBO.getQuoteMethod().toString()) && CollectionUtils.isEmpty(quotationFXS = this.dIqrQuotationMapper.selectQuotationByItemIds(reqBO.getQuotationItemIds()))) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            if ("2".equals(busiType)) {
                CompareIpAddrReqBO ipAddrReqBO = new CompareIpAddrReqBO();
                BeanUtils.copyProperties((Object)reqBO, (Object)ipAddrReqBO);
                CompareIpAddrRspBO ipAddrRspBO = this.compareIpAddrService.compareIpAddr(ipAddrReqBO);
                if ("9999".equals(ipAddrRspBO.getRespCode())) {
                    BeanUtils.copyProperties((Object)ipAddrReqBO, (Object)rspBO);
                    return rspBO;
                }
            } else if ("2".equals(reqBO.getQuoteMethod().toString()) && quotationFXS.size() > inquiryMatePO.getAllowTradingNum()) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u5206\u9879\u62a5\u4ef7\u6700\u7ec8\u9009\u53d6\u7684\u4f9b\u5e94\u5546\u6570\u91cf\uff0c\u4e0d\u80fd\u8d85\u8fc7\u5141\u8bb8\u6210\u4ea4\u7684\u4f9b\u5e94\u5546\u6570\u91cf\u9650\u5236\uff08\u76ee\u524d\u53ea\u9650\u5b9a5\u5bb6\uff09\uff01");
                return rspBO;
            }
            long finalTotalAmount = 0L;
            if ("1".equals(reqBO.getQuoteMethod().toString())) {
                quoteIds.add(reqBO.getQuotationId());
                quotationZD = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
                if (quotationZD == null) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                    return rspBO;
                }
                SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("6");
                SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                Long dealNoticeId = seqEnquiryPubRspBO.getDocId();
                List<DIqrQuotationItemPO> list = this.dIqrQuotationItemMapper.selectByQuotationId(reqBO.getQuotationId());
                String pkgId = "";
                if (!CollectionUtils.isEmpty(list)) {
                    for (DIqrQuotationItemPO quoteItemPO : list) {
                        inquiryItemIds.add(quoteItemPO.getInquiryItemId());
                        DIqrDealNoticeItemPO dealItemPO = new DIqrDealNoticeItemPO();
                        SeqEnquiryReqBO seqReqBO = new SeqEnquiryReqBO();
                        seqReqBO.setSystemId("ZH01");
                        seqReqBO.setSeqType("62");
                        SeqEnquiryRspBO seqRspBO = this.seqIdCreateService.getSeqId(seqReqBO);
                        dealItemPO.setDealNoticeItemId(seqRspBO.getDocId());
                        dealItemPO.setDealNoticeId(dealNoticeId);
                        dealItemPO.setBrandCode(quoteItemPO.getBrand());
                        dealItemPO.setQuotationId(quoteItemPO.getQuotationId());
                        dealItemPO.setQuoteItemId(quoteItemPO.getQuotationItemId());
                        dealItemPO.setNodeStatus(Constants.DEAL_ITEM_NODE_STATUS_5100);
                        dealItemPO.setFinalPrice(quoteItemPO.getQuotePrice());
                        dealItemPO.setFinalTotalPrice(quoteItemPO.getQuoteAmount());
                        dealItemPO.setQuoteDate(quotationZD.getQuotationSubmitTime());
                        dealItemPO.setPromiseArriveDate(quotationZD.getDeliveryDatePromise());
                        dealItemPO.setSupplierId(quotationZD.getSupplierId());
                        dealItemPO.setSupplierName(quotationZD.getSupplierName());
                        dealItemPO.setDealNoticePkgId(quoteItemPO.getInquiryPkgId());
                        this.dIqrDealNoticeItemMapper.insert(dealItemPO);
                        pkgId = quoteItemPO.getInquiryPkgId();
                        if (quoteItemPO.getQuoteAmount() == null) continue;
                        finalTotalAmount += quoteItemPO.getQuoteAmount().longValue();
                    }
                }
                DIqrDealNoticePkgPO dealPkgPO = new DIqrDealNoticePkgPO();
                dealPkgPO.setDealNoticeId(dealNoticeId);
                dealPkgPO.setDealNoticePkgId(pkgId);
                dealPkgPO.setDealNoticePkgName(quotationZD.getInquiryName() + "\u6210\u4ea4\u901a\u77e5\u4e66");
                dealPkgPO.setValidStatus(Constants.IS_VALID_Y);
                this.dIqrDealNoticePkgMapper.insert(dealPkgPO);
                supIds.add(quotationZD.getSupplierId());
                DIqrDealNoticePO dIqrDealNoticePO = new DIqrDealNoticePO();
                BeanUtils.copyProperties((Object)quotationZD, (Object)dIqrDealNoticePO);
                dIqrDealNoticePO.setDealNoticeId(dealNoticeId);
                dIqrDealNoticePO.setBillCreateTime(date);
                dIqrDealNoticePO.setBillCreateUserId(reqBO.getUserId());
                dIqrDealNoticePO.setBillCreateUserName(reqBO.getUsername());
                dIqrDealNoticePO.setHisStatus(Integer.parseInt("1"));
                dIqrDealNoticePO.setDocStatus(Integer.parseInt("5000"));
                dIqrDealNoticePO.setStatus(3);
                CodeEnquiryReqBO codeReq = new CodeEnquiryReqBO();
                codeReq.setBusiType(busiType);
                codeReq.setPurchaseCategory(Integer.valueOf(1));
                codeReq.setSystemId("ZH01");
                codeReq.setDocumentType("6");
                CodeEnquiryRspBO codeRspBO = this.seqCodeCreateService.getSeqCode(codeReq);
                dIqrDealNoticePO.setDealNoticeCode(codeRspBO.getDocCode());
                dIqrDealNoticePO.setDealNoticeName(quotationZD.getInquiryName() + "\u6210\u4ea4\u901a\u77e5\u4e66");
                if ("Y".equals(inquiryMatePO.getTotalPriceFlag())) {
                    dIqrDealNoticePO.setFinalTotalAmount(quotationZD.getAmount());
                } else {
                    dIqrDealNoticePO.setFinalTotalAmount(finalTotalAmount);
                }
                dIqrDealNoticePO.setValidStatus(Constants.IS_VALID_Y);
                dIqrDealNoticePO.setShippingAddr(inquiryMatePO.getShippingAddr());
                dIqrDealNoticePO.setDisposalMethod(inquiryMatePO.getDisposalMethod());
                dIqrDealNoticePO.setDeliveryMethod(inquiryMatePO.getDeliveryMethod());
                dIqrDealNoticePO.setPlanId(inquiryMatePO.getPlanId());
                this.dIqrDealNoticeMapper.insert(dIqrDealNoticePO);
            } else {
                List<DIqrQuotationItemPO> itemFXS = this.dIqrQuotationItemMapper.selectByItemIds(reqBO.getQuotationItemIds());
                List<DIqrQuotationPkgPO> pkgFXS = this.dIqrQuotationPkgMapper.selectByInquiryId(((DIqrQuotationPO)quotationFXS.get(0)).getInquiryId());
                inquiryId = ((DIqrQuotationPO)quotationFXS.get(0)).getInquiryId();
                for (DIqrQuotationPO dIqrQuotationPO : quotationFXS) {
                    supIds.add(dIqrQuotationPO.getSupplierId());
                    quoteIds.add(dIqrQuotationPO.getQuotationId());
                    DIqrDealNoticePO dIqrDealNoticePO = new DIqrDealNoticePO();
                    BeanUtils.copyProperties((Object)dIqrQuotationPO, (Object)dIqrDealNoticePO);
                    SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                    seqEnquiryReqBO.setSystemId("ZH01");
                    seqEnquiryReqBO.setSeqType("6");
                    SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                    Long dealNoticeId = seqEnquiryPubRspBO.getDocId();
                    dIqrDealNoticePO.setDealNoticeId(dealNoticeId);
                    dIqrDealNoticePO.setBillCreateTime(date);
                    dIqrDealNoticePO.setBillCreateUserId(reqBO.getUserId());
                    dIqrDealNoticePO.setBillCreateUserName(reqBO.getUsername());
                    dIqrDealNoticePO.setHisStatus(Integer.parseInt("1"));
                    dIqrDealNoticePO.setDocStatus(Integer.parseInt("5000"));
                    dIqrDealNoticePO.setStatus(3);
                    CodeEnquiryReqBO codeReq = new CodeEnquiryReqBO();
                    codeReq.setBusiType(busiType);
                    codeReq.setPurchaseCategory(Integer.valueOf(1));
                    codeReq.setSystemId("ZH01");
                    codeReq.setDocumentType("6");
                    CodeEnquiryRspBO codeRspBO = this.seqCodeCreateService.getSeqCode(codeReq);
                    dIqrDealNoticePO.setDealNoticeCode(codeRspBO.getDocCode());
                    dIqrDealNoticePO.setDealNoticeName(dIqrQuotationPO.getInquiryName() + "\u6210\u4ea4\u901a\u77e5\u4e66");
                    for (DIqrQuotationPkgPO pkgFX : pkgFXS) {
                        if (pkgFX.getQuotationId().longValue() != dIqrQuotationPO.getQuotationId().longValue()) continue;
                        DIqrDealNoticePkgPO dealPkgPO = new DIqrDealNoticePkgPO();
                        dealPkgPO.setDealNoticeId(dealNoticeId);
                        dealPkgPO.setDealNoticePkgId(pkgFX.getInquiryPkgId());
                        dealPkgPO.setDealNoticePkgName(quotationZD.getInquiryName() + "\u6210\u4ea4\u901a\u77e5\u4e66");
                        dealPkgPO.setValidStatus(Constants.IS_VALID_Y);
                        this.dIqrDealNoticePkgMapper.insert(dealPkgPO);
                        for (DIqrQuotationItemPO itemFX : itemFXS) {
                            if (itemFX.getQuotationId().longValue() != dIqrQuotationPO.getQuotationId().longValue() || !itemFX.getInquiryPkgId().equals(pkgFX.getInquiryPkgId())) continue;
                            inquiryItemIds.add(itemFX.getInquiryItemId());
                            DIqrDealNoticeItemPO dealItemPO = new DIqrDealNoticeItemPO();
                            SeqEnquiryReqBO seqReqBO = new SeqEnquiryReqBO();
                            seqReqBO.setSystemId("ZH01");
                            seqReqBO.setSeqType("62");
                            SeqEnquiryRspBO seqRspBO = this.seqIdCreateService.getSeqId(seqReqBO);
                            dealItemPO.setDealNoticeItemId(seqRspBO.getDocId());
                            dealItemPO.setDealNoticeId(dealNoticeId);
                            dealItemPO.setBrandCode(itemFX.getBrand());
                            dealItemPO.setQuotationId(itemFX.getQuotationId());
                            dealItemPO.setQuoteItemId(itemFX.getQuotationItemId());
                            dealItemPO.setNodeStatus(Constants.DEAL_ITEM_NODE_STATUS_5100);
                            dealItemPO.setFinalPrice(itemFX.getQuotePrice());
                            dealItemPO.setFinalTotalPrice(itemFX.getQuoteAmount());
                            dealItemPO.setQuoteDate(dIqrQuotationPO.getQuotationSubmitTime());
                            dealItemPO.setPromiseArriveDate(dIqrQuotationPO.getDeliveryDatePromise());
                            dealItemPO.setSupplierId(dIqrQuotationPO.getSupplierId());
                            dealItemPO.setSupplierName(dIqrQuotationPO.getSupplierName());
                            dealItemPO.setDealNoticePkgId(pkgFX.getInquiryPkgId());
                            this.dIqrDealNoticeItemMapper.insert(dealItemPO);
                            if (itemFX.getQuoteAmount() == null) continue;
                            finalTotalAmount += itemFX.getQuoteAmount().longValue();
                        }
                    }
                    dIqrDealNoticePO.setFinalTotalAmount(finalTotalAmount);
                    dIqrDealNoticePO.setValidStatus(Constants.IS_VALID_Y);
                    dIqrDealNoticePO.setShippingAddr(inquiryMatePO.getShippingAddr());
                    dIqrDealNoticePO.setDisposalMethod(inquiryMatePO.getDisposalMethod());
                    dIqrDealNoticePO.setDeliveryMethod(inquiryMatePO.getDeliveryMethod());
                    dIqrDealNoticePO.setPlanId(inquiryMatePO.getPlanId());
                    this.dIqrDealNoticeMapper.insert(dIqrDealNoticePO);
                }
            }
            this.dIqrRegistDocMapper.updateBySupIdsInquiryId(supIds, inquiryId, 3005);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u751f\u6210\u6210\u4ea4\u901a\u77e5\u4e66\u5b8c\u6210\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u751f\u6210\u6210\u4ea4\u901a\u77e5\u4e66\u5f02\u5e38\u5931\u8d25\uff01");
            return rspBO;
        }
        return rspBO;
    }

    private CreateDealNoticeRspBO initParam(CreateDealNoticeReqBO reqBO) {
        CreateDealNoticeRspBO rspBO = new CreateDealNoticeRspBO();
        if (reqBO.getQuoteMethod() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if ("1".equals(reqBO.getQuoteMethod().toString())) {
            if (reqBO.getQuotationId() == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                return rspBO;
            }
        } else if (CollectionUtils.isEmpty((Collection)reqBO.getQuotationItemIds())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u660e\u7ec6ID\u5217\u8868\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        return rspBO;
    }
}

