/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quoteFinish;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.quoteFinish.bo.ChooseBiddingReqBO;
import com.tydic.enquiry.api.quoteFinish.bo.ChooseBiddingRspBO;
import com.tydic.enquiry.api.quoteFinish.service.ChooseBiddingService;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationItemPO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.vo.InquiryItemVO;
import com.tydic.enquiry.vo.QuotationInfoVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=ChooseBiddingService.class)
public class ChooseBiddingServiceImpl
implements ChooseBiddingService {
    private static final Logger log = LoggerFactory.getLogger(ChooseBiddingServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;

    public ChooseBiddingRspBO chooseBidding(ChooseBiddingReqBO reqBO) {
        ChooseBiddingRspBO rspBO = new ChooseBiddingRspBO();
        try {
            rspBO = this.initParam(reqBO);
            if ("9999".equals(rspBO.getRespCode())) {
                return rspBO;
            }
            Date date = new Date();
            if ("1".equals(reqBO.getQuoteMethod().toString())) {
                DIqrQuotationPO quotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(reqBO.getQuotationId());
                if (quotationPO == null) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                    return rspBO;
                }
                if (quotationPO.getDocStatus() == null || !"4004".equals(quotationPO.getDocStatus().toString())) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u62a5\u4ef7\u5355\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u8bf7\u786e\u8ba4\uff01");
                    return rspBO;
                }
                DIqrInquiryMatePO inquiryMatePO = new DIqrInquiryMatePO();
                inquiryMatePO.setNodeStatus(Integer.parseInt("2107"));
                inquiryMatePO.setDocStatus(Integer.parseInt("2005"));
                inquiryMatePO.setModifyTime(date);
                inquiryMatePO.setModifyUserId(reqBO.getUserId());
                inquiryMatePO.setModifyUserName(reqBO.getUsername());
                inquiryMatePO.setInquiryId(quotationPO.getInquiryId());
                this.dIqrInquiryMateMapper.updateByPrimaryKeySelective(inquiryMatePO);
                DIqrInquiryDetailPO detailPO = new DIqrInquiryDetailPO();
                detailPO.setNodeStatus("22103");
                detailPO.setDocStatus(22003);
                detailPO.setModifyTime(date);
                detailPO.setModifyUserId(reqBO.getUserId());
                detailPO.setModifyUserName(reqBO.getUsername());
                this.dIqrInquiryDetailMapper.updateByInquiryId(detailPO);
                quotationPO.setDocStatus(Integer.parseInt("4006"));
                this.dIqrQuotationMapper.updateByPrimaryKeySelective(quotationPO);
                QuotationInfoVO quotationInfoVO = new QuotationInfoVO();
                quotationInfoVO.setDocStatus(Integer.parseInt("44002"));
                ArrayList<Long> quotationIds = new ArrayList<Long>();
                quotationIds.add(reqBO.getQuotationId());
                quotationInfoVO.setQuotationIds(quotationIds);
                this.dIqrQuotationItemMapper.updateByQuotationIds(quotationInfoVO);
            } else {
                List<DIqrQuotationItemPO> itemPOS = this.dIqrQuotationItemMapper.selectByItemIds(reqBO.getQuotationItemIds());
                if (CollectionUtils.isEmpty(itemPOS)) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u62a5\u4ef7\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                    return rspBO;
                }
                DIqrInquiryMatePO inquiryMatePO = new DIqrInquiryMatePO();
                inquiryMatePO.setNodeStatus(Integer.parseInt("2107"));
                inquiryMatePO.setDocStatus(Integer.parseInt("2005"));
                inquiryMatePO.setModifyTime(date);
                inquiryMatePO.setModifyUserId(reqBO.getUserId());
                inquiryMatePO.setModifyUserName(reqBO.getUsername());
                inquiryMatePO.setInquiryId(itemPOS.get(0).getInquiryId());
                this.dIqrInquiryMateMapper.updateByPrimaryKeySelective(inquiryMatePO);
                ArrayList<Long> inquiryItemIds = new ArrayList<Long>();
                ArrayList<Long> quoteItemIds = new ArrayList<Long>();
                ArrayList<Long> quotationIds = new ArrayList<Long>();
                for (DIqrQuotationItemPO item : itemPOS) {
                    inquiryItemIds.add(item.getInquiryItemId());
                    quoteItemIds.add(item.getQuotationItemId());
                    quotationIds.add(item.getQuotationId());
                }
                InquiryItemVO inquiryItemVO = new InquiryItemVO();
                inquiryItemVO.setNodeStatus("22103");
                inquiryItemVO.setDocStatus(22003);
                inquiryItemVO.setModifyTime(date);
                inquiryItemVO.setModifyUserId(reqBO.getUserId());
                inquiryItemVO.setModifyUserName(reqBO.getUsername());
                inquiryItemVO.setInquiryItemIds(inquiryItemIds);
                this.dIqrInquiryDetailMapper.updateByInquiryItemIds(inquiryItemVO);
                QuotationInfoVO quote = new QuotationInfoVO();
                quote.setDocStatus(Integer.parseInt("44002"));
                quote.setQuotationIds(quotationIds);
                this.dIqrQuotationMapper.updateByQuotationIds(quote);
                QuotationInfoVO quotationInfoVO = new QuotationInfoVO();
                quotationInfoVO.setDocStatus(44002);
                quotationInfoVO.setQuotationItemIds(quoteItemIds);
                this.dIqrQuotationItemMapper.updateByQuotationItemIds(quotationInfoVO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5f02\u5e38\u5931\u8d25\uff01");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f\uff01");
        return rspBO;
    }

    private ChooseBiddingRspBO initParam(ChooseBiddingReqBO reqBO) {
        ChooseBiddingRspBO rspBO = new ChooseBiddingRspBO();
        if (reqBO.getQuoteMethod() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getQuoteMethod() == null || "1".equals(reqBO.getQuoteMethod().toString())) {
            if (reqBO.getQuotationId() == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u62a5\u4ef7\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                return rspBO;
            }
        } else if (CollectionUtils.isEmpty((Collection)reqBO.getQuotationItemIds())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u5355\u660e\u7ec6ID\u5217\u8868\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        return rspBO;
    }
}

