/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quoteFinish;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.demandlist.bo.AttachmentBO;
import com.tydic.enquiry.api.quoteFinish.bo.GiveUpBiddingReqBO;
import com.tydic.enquiry.api.quoteFinish.bo.GiveUpBiddingRspBO;
import com.tydic.enquiry.api.quoteFinish.service.GiveUpBiddingService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.RPlanAttachmentInfoMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.RPlanAttachmentInfoPO;
import com.tydic.enquiry.vo.InquiryItemVO;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=GiveUpBiddingService.class)
public class GiveUpBiddingServiceImpl
implements GiveUpBiddingService {
    private static final Logger log = LoggerFactory.getLogger(GiveUpBiddingServiceImpl.class);
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST")
    private SeqIdCreateService seqIdCreateService;
    @Autowired
    private RPlanAttachmentInfoMapper rPlanAttachmentInfoMapper;

    public GiveUpBiddingRspBO giveUpBidding(GiveUpBiddingReqBO reqBO) {
        GiveUpBiddingRspBO rspBO = new GiveUpBiddingRspBO();
        try {
            rspBO = this.initParam(reqBO);
            if ("9999".equals(rspBO.getRespCode())) {
                return rspBO;
            }
            DIqrInquiryMatePO inquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
            if (inquiryMatePO == null) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u6267\u884c\u5355\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
                return rspBO;
            }
            if (!"2004".equals(inquiryMatePO.getDocStatus().toString())) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u8be5\u6267\u884c\u5355\u4e0d\u7b26\u5408\u6761\u4ef6\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01");
                return rspBO;
            }
            Date date = new Date();
            if ("1".equals(inquiryMatePO.getQuoteMethod().toString())) {
                inquiryMatePO.setDocStatus(Integer.parseInt("2008"));
                inquiryMatePO.setGiveupReason(reqBO.getGiveupReasons().toString());
                inquiryMatePO.setGiveupRemark(reqBO.getRemarks());
                inquiryMatePO.setModifyTime(date);
                inquiryMatePO.setModifyUserId(reqBO.getUserId());
                inquiryMatePO.setModifyUserName(reqBO.getUsername());
                inquiryMatePO.setNodeStatus(Integer.parseInt("2114"));
                int chngFlag = this.dIqrInquiryMateMapper.updateByPrimaryKeySelective(inquiryMatePO);
                if (chngFlag < 0) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u653e\u5f03\u672c\u660e\u7ec6\u7ade\u4ef7\u7ed3\u679c\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                    return rspBO;
                }
                DIqrInquiryDetailPO detailPO = new DIqrInquiryDetailPO();
                detailPO.setDocStatus(Constants.INQUIRY_DETAIL_DOC_STATUS_22005);
                detailPO.setDocStatus(22106);
                detailPO.setModifyTime(date);
                detailPO.setModifyUserId(reqBO.getUserId());
                detailPO.setModifyUserName(reqBO.getUsername());
                chngFlag = this.dIqrInquiryDetailMapper.updateByInquiryId(detailPO);
                if (chngFlag < 0) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u653e\u5f03\u672c\u6b21\u7ade\u4ef7\u7ed3\u679c\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                    return rspBO;
                }
            } else {
                InquiryItemVO inquiryItemVO = new InquiryItemVO();
                inquiryItemVO.setInquiryItemIds(reqBO.getInquiryItemIds());
                inquiryItemVO.setDocStatus(Constants.INQUIRY_DETAIL_DOC_STATUS_22005);
                inquiryItemVO.setDocStatus(22106);
                inquiryItemVO.setModifyTime(date);
                inquiryItemVO.setModifyUserId(reqBO.getUserId());
                inquiryItemVO.setModifyUserName(reqBO.getUsername());
                int chngFlag = this.dIqrInquiryDetailMapper.updateByInquiryItemIds(inquiryItemVO);
                if (chngFlag < 0) {
                    rspBO.setRespCode("9999");
                    rspBO.setRespDesc("\u653e\u5f03\u672c\u6b21\u7ade\u4ef7\u7ed3\u679c\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
                    return rspBO;
                }
            }
            for (AttachmentBO attachmentBO : reqBO.getAttachmentInfoList()) {
                SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
                RPlanAttachmentInfoPO dIqrInquiryAttchmentPO = new RPlanAttachmentInfoPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)dIqrInquiryAttchmentPO);
                seqEnquiryReqBO = new SeqEnquiryReqBO();
                seqEnquiryReqBO.setSystemId("ZH01");
                seqEnquiryReqBO.setSeqType("99");
                SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
                dIqrInquiryAttchmentPO.setAttachmentId(seqEnquiryPubRspBO.getDocId());
                dIqrInquiryAttchmentPO.setObjectId(reqBO.getInquiryId());
                dIqrInquiryAttchmentPO.setObjectType(Constants.OBJECT_TYPE_7);
                dIqrInquiryAttchmentPO.setCreateUserId(reqBO.getUserId());
                dIqrInquiryAttchmentPO.setCreateUserName(reqBO.getUsername());
                dIqrInquiryAttchmentPO.setAttachmentName(attachmentBO.getAttachmentName());
                dIqrInquiryAttchmentPO.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                dIqrInquiryAttchmentPO.setAttachmentBusiType(4);
                dIqrInquiryAttchmentPO.setValidFlag(Constants.IS_VALID_Y.toString());
                dIqrInquiryAttchmentPO.setCreateTime(date);
                int resultattach = this.rPlanAttachmentInfoMapper.insertSelective(dIqrInquiryAttchmentPO);
                if (resultattach >= 0) continue;
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u65b0\u589e\u9644\u4ef6\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u64a4\u56de\u5931\u8d25\uff01");
        }
        return rspBO;
    }

    private GiveUpBiddingRspBO initParam(GiveUpBiddingReqBO reqBO) {
        GiveUpBiddingRspBO rspBO = new GiveUpBiddingRspBO();
        if (reqBO.getQuoteMethod() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if ("2".equals(reqBO.getQuoteMethod().toString()) && CollectionUtils.isEmpty((Collection)reqBO.getInquiryItemIds())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355\u660e\u7ec6ID\u5217\u8868\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getGiveupReasons() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u8bf7\u9009\u62e9\u653e\u5f03\u539f\u56e0\uff01");
            return rspBO;
        }
        if (reqBO.getRemarks() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u653e\u5f03\u8bf4\u660e\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAttachmentInfoList()) || reqBO.getAttachmentInfoList().size() > 6) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u9644\u4ef6\u5fc5\u586b\uff0c\u6700\u591a\u4e94\u4e2a\uff01");
            return rspBO;
        }
        return rspBO;
    }
}

