/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.performlist.bo.ApproveRisunExceReqBO;
import com.tydic.enquiry.api.performlist.bo.ApproveRisunExceRspBO;
import com.tydic.enquiry.api.performlist.bo.ExecOrderStatusReqBO;
import com.tydic.enquiry.api.performlist.service.ApproveRisunExceOrderService;
import com.tydic.enquiry.api.performlist.service.UpExecOrderStatusService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryRspBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.base.EnquiryCallHttpSendMassageRspBO;
import com.tydic.enquiry.base.EnquiryRisunSendMassageReqBO;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.util.SendMsgUtil;
import com.tydic.osworkflow.engine.exception.OsworkflowDataException;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=ApproveRisunExceOrderService.class)
public class ApproveRisunExceOrderServiceImpl
implements ApproveRisunExceOrderService {
    private static final Logger log = LoggerFactory.getLogger(ApproveRisunExceOrderServiceImpl.class);
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    CAllOperLogMapper cAllOperLogMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST")
    SeqIdCreateService seqIdCreateService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST")
    UpExecOrderStatusService upExecOrderStatusService;
    @Autowired(required=false)
    UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Value(value="${msg.center.url}")
    private String msgUrl;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Value(value="${risun.XYZR:100000000000000032}")
    private String risunZR;
    @Autowired
    DIqrRegistDetailMapper dIqrRegistDetailMapper;
    @Autowired
    DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;

    public ApproveRisunExceRspBO exceOrderApprove(ApproveRisunExceReqBO reqBO) {
        log.info("\u5165\u53c2ApproveRisunExceReqBO:" + reqBO.toString());
        ApproveRisunExceRspBO rspBO = new ApproveRisunExceRspBO();
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u7ade\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getApproveFlag())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u5ba1\u6279\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!");
            return rspBO;
        }
        try {
            List<DIqrRegistDocPO> dIqrRegistDocList;
            DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(reqBO.getInquiryId());
            if (null == dIqrInquiryMatePO) {
                rspBO.setRespCode("9999");
                rspBO.setRespDesc("\u7ade\u4ef7\u5355\u4e3a\u7a7a\u6216\u8005\u7ade\u4ef7\u5355\u5ba1\u6279\u6d41\u7a0bID\u4e3a\u7a7a!");
                return rspBO;
            }
            UacNoTaskAuditOrderAuditReqBO uacNoTaskAuditOrderAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
            uacNoTaskAuditOrderAuditReqBO.setStepId(dIqrInquiryMatePO.getProcessInstId());
            uacNoTaskAuditOrderAuditReqBO.setOperId(String.valueOf(reqBO.getApproveOperId()));
            uacNoTaskAuditOrderAuditReqBO.setAuditAdvice(reqBO.getApproveComments());
            uacNoTaskAuditOrderAuditReqBO.setObjType(Integer.valueOf(111));
            if ("1".equals(reqBO.getApproveFlag())) {
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(0));
            } else {
                uacNoTaskAuditOrderAuditReqBO.setAuditResult(Integer.valueOf(1));
            }
            ArrayList<Long> objIdList = new ArrayList<Long>();
            objIdList.add(reqBO.getInquiryId());
            uacNoTaskAuditOrderAuditReqBO.setObjId(objIdList);
            ExecOrderStatusReqBO execOrderStatusReqBO = new ExecOrderStatusReqBO();
            execOrderStatusReqBO.setInquiryId(reqBO.getInquiryId());
            String approveFlag = reqBO.getApproveFlag();
            if ("1".equals(approveFlag)) {
                if (Constants.PURCHASE_METHOD_INVITE.intValue() == dIqrInquiryMatePO.getPurchaseMethod().intValue()) {
                    execOrderStatusReqBO.setDocStatus(Integer.valueOf("2005"));
                    execOrderStatusReqBO.setNodeStatus("2005");
                } else {
                    execOrderStatusReqBO.setDocStatus(Integer.valueOf("2004"));
                    execOrderStatusReqBO.setNodeStatus("2004");
                }
            } else {
                execOrderStatusReqBO.setDocStatus(Integer.valueOf("2003"));
                execOrderStatusReqBO.setNodeStatus("2003");
            }
            execOrderStatusReqBO.setOperId(reqBO.getApproveOperId());
            execOrderStatusReqBO.setOperName(reqBO.getApproveOperName());
            execOrderStatusReqBO.setUpFlag("1");
            execOrderStatusReqBO.setProcessStatus(Integer.valueOf(2));
            this.upExecOrderStatusService.updateExecOrderStatus(execOrderStatusReqBO);
            this.insertOperLog(dIqrInquiryMatePO.getInquiryId(), "\u7ade\u4ef7\u5355\u5ba1\u6279", reqBO.getApproveOperId(), reqBO.getApproveOperName(), approveFlag, null, "dealApprove");
            if ("1".equals(approveFlag) && Constants.PURCHASE_METHOD_INVITE.intValue() == dIqrInquiryMatePO.getPurchaseMethod().intValue() && CollectionUtils.isNotEmpty(dIqrRegistDocList = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(dIqrInquiryMatePO.getInquiryId()))) {
                Date currentDate = new Date();
                if (this.risunZR.equals(dIqrInquiryMatePO.getPurchaseIdJson())) {
                    DIqrRegistDocPO dIqrRegistDocPO = new DIqrRegistDocPO();
                    dIqrRegistDocPO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                    dIqrRegistDocPO.setPayDate(currentDate);
                    dIqrRegistDocPO.setModifyTime(currentDate);
                    dIqrRegistDocPO.setPayStatus("2");
                    BigDecimal totalMarginAmount = new BigDecimal(0);
                    dIqrRegistDocPO.setMarginAmount(MoneyUtils.BigDecimal2Long((BigDecimal)totalMarginAmount));
                    if (currentDate.after(dIqrInquiryMatePO.getLimitQuoteDate()) && currentDate.before(dIqrInquiryMatePO.getQuoteEndDate())) {
                        dIqrRegistDocPO.setDocStatus(Integer.valueOf("3006"));
                    } else {
                        dIqrRegistDocPO.setDocStatus(Integer.parseInt("3002"));
                    }
                    this.dIqrRegistDocMapper.updatePayStatusByInquiryId(dIqrRegistDocPO);
                    log.info("ApproveRisunExceOrderService:updatePayStatusByInquiryId \u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)dIqrRegistDocPO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}) + " \u65ed\u9633\u4e2d\u71c3\u7684\u7ade\u4ef7\u5355-\u66f4\u65b0\u5df2\u7f34\u8d39\uff0c\u4f9b\u5e94\u5546\u5df2\u62a5\u540d");
                    for (DIqrRegistDocPO registDocPO : dIqrRegistDocList) {
                        List<DIqrInquiryBidsectionPO> dIqrInquiryBidsectionPOList = this.dIqrInquiryBidsectionMapper.selectByInquiryId(dIqrInquiryMatePO.getInquiryId());
                        if (!CollectionUtils.isNotEmpty(dIqrInquiryBidsectionPOList)) continue;
                        ArrayList<DIqrRegistDetailPO> dIqrRegistDetailPOList = new ArrayList<DIqrRegistDetailPO>();
                        for (DIqrInquiryBidsectionPO dIqrInquiryBidsectionPO : dIqrInquiryBidsectionPOList) {
                            DIqrRegistDetailPO dIqrRegistDetailInsert = new DIqrRegistDetailPO();
                            dIqrRegistDetailInsert.setRegistItemId(this.getDocId("RISUN01", "31"));
                            dIqrRegistDetailInsert.setInquiryId(reqBO.getInquiryId());
                            dIqrRegistDetailInsert.setRegistId(registDocPO.getRegistId());
                            dIqrRegistDetailInsert.setInquiryItemId(dIqrInquiryBidsectionPO.getInquiryItemId());
                            dIqrRegistDetailInsert.setRemarks(dIqrInquiryBidsectionPO.getBidsectionName() + "\u6807\u6bb5\u62a5\u540d\u81ea\u52a8\u521b\u5efa\u3010\u4e2d\u71c3\u3011");
                            dIqrRegistDetailInsert.setValidStatus(Constants.IS_VALID_Y);
                            dIqrRegistDetailInsert.setBidsectionId(dIqrInquiryBidsectionPO.getBidsectionId());
                            dIqrRegistDetailPOList.add(dIqrRegistDetailInsert);
                        }
                        this.dIqrRegistDetailMapper.insertRegistDetailBatch(dIqrRegistDetailPOList);
                        log.info("ApproveRisunExceOrderService:insertRegistDetailBatch \u5165\u53c2\uff1aregistId =" + registDocPO.getRegistId() + ":SupplierName=" + registDocPO.getSupplierName() + " \u65ed\u9633\u4e2d\u71c3\u7684\u7ade\u4ef7\u5355-\u66f4\u65b0\u5df2\u7f34\u8d39\uff0c\u4f9b\u5e94\u5546\u5df2\u62a5\u540d");
                    }
                }
                for (DIqrRegistDocPO registDocPO : dIqrRegistDocList) {
                    String phoneNumber = registDocPO.getPhoneNumber();
                    if (!StringUtils.isNotBlank((CharSequence)phoneNumber)) continue;
                    EnquiryRisunSendMassageReqBO sendMessageReqBO = new EnquiryRisunSendMassageReqBO();
                    sendMessageReqBO.setPhoneNumbers(phoneNumber);
                    sendMessageReqBO.setTemplateCode("SMS_221080024");
                    HashMap<String, String> templateParamMap = new HashMap<String, String>();
                    templateParamMap.put("supplierName", registDocPO.getSupplierName());
                    templateParamMap.put("orgName", dIqrInquiryMatePO.getPurchaseName());
                    templateParamMap.put("bidname", dIqrInquiryMatePO.getInquiryName());
                    sendMessageReqBO.setTemplateParam(JSONObject.toJSONString(templateParamMap));
                    EnquiryCallHttpSendMassageRspBO messageRspBO = SendMsgUtil.risunSendMassage(sendMessageReqBO, this.msgUrl);
                    log.info("ApproveRisunExceOrderService:messageRspBO=" + JSONObject.toJSONString((Object)messageRspBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    if ("0000".equals(messageRspBO.getRespCode())) continue;
                    throw new EnqBusinessException("9999", messageRspBO.getRespDesc());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)dIqrInquiryMatePO.getPurchaserTele())) {
                EnquiryRisunSendMassageReqBO sendMessageReqBO = new EnquiryRisunSendMassageReqBO();
                sendMessageReqBO.setPhoneNumbers(dIqrInquiryMatePO.getPurchaserTele());
                sendMessageReqBO.setTemplateCode("SMS_224125686");
                HashMap<String, String> templateParamMap = new HashMap<String, String>();
                templateParamMap.put("createUserName", dIqrInquiryMatePO.getCreateUserName());
                templateParamMap.put("bidname", dIqrInquiryMatePO.getInquiryName());
                templateParamMap.put("approve", "1".equals(approveFlag) ? "\u901a\u8fc7" : "\u62d2\u7edd");
                sendMessageReqBO.setTemplateParam(JSONObject.toJSONString(templateParamMap));
                EnquiryCallHttpSendMassageRspBO messageRspBO = SendMsgUtil.risunSendMassage(sendMessageReqBO, this.msgUrl);
                this.insertOperLog(dIqrInquiryMatePO.getInquiryId(), "\u53d1\u9001\u77ed\u4fe1", reqBO.getApproveOperId(), reqBO.getApproveOperName(), null, JSONObject.toJSONString((Object)sendMessageReqBO), "dealSendMsg");
                if (!"0000".equals(messageRspBO.getRespCode())) {
                    throw new EnqBusinessException("9999", messageRspBO.getRespDesc());
                }
            }
            rspBO.setDocId(dIqrInquiryMatePO.getInquiryId() + "");
            if (reqBO.getApproveDate() != null) {
                rspBO.setApproveDate(DateUtils.dateToStr((Date)reqBO.getApproveDate(), (String)"yyyyMMddHHmmss"));
            } else {
                rspBO.setApproveDate(DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss"));
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u7ade\u4ef7\u5355\u5ba1\u6279\u5f02\u5e38", (Throwable)e);
            if (e instanceof EnqBusinessException || e instanceof BusinessException || e instanceof OsworkflowDataException) {
                throw new EnqBusinessException("9999", e.getMessage());
            }
            throw new EnqBusinessException("9999", "\u7ade\u4ef7\u5355\u5ba1\u6279\u5f02\u5e38");
        }
        return rspBO;
    }

    private void insertOperLog(Long docId, String operLink, Long operUserId, String operUserName, String approveFlag, String msg, String type) {
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId("RISUN01");
        seqEnquiryReqBO.setSeqType("99");
        SeqEnquiryRspBO seqEnquiryPubRspBO = this.seqIdCreateService.getSeqId(seqEnquiryReqBO);
        cAllOperLogPO.setHisId(seqEnquiryPubRspBO.getDocId());
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        cAllOperLogPO.setBusiStepId(2);
        if ("dealApprove".equals(type)) {
            if ("1".equals(approveFlag)) {
                cAllOperLogPO.setOperBehavior("\u7ade\u4ef7\u5355\u5ba1\u6279\uff08\u901a\u8fc7\uff09");
            } else {
                cAllOperLogPO.setOperBehavior("\u7ade\u4ef7\u5355\u5ba1\u6279\uff08\u9a73\u56de\uff09");
            }
            cAllOperLogPO.setRemark("\u6210\u529f");
        } else if ("dealSendMsg".equals(type)) {
            cAllOperLogPO.setOperBehavior("\u7ade\u4ef7\u9879\u76ee\u5ba1\u6279\u5b8c\u6210\u53d1\u9001\u77ed\u4fe1\u7ed9\u4e1a\u52a1\u5458");
            cAllOperLogPO.setRemark(msg);
        }
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }

    private Long getDocId(String systemId, String type) {
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId(systemId);
        seqEnquiryReqBO.setSeqType(type);
        return this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId();
    }
}

