/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.registdoc.bo.CheckRisunRegistReqBO;
import com.tydic.enquiry.api.registdoc.bo.CheckRisunRegistRspBO;
import com.tydic.enquiry.api.registdoc.service.CheckRisunRegistService;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.DIqrInquiryDetailPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=CheckRisunRegistService.class)
public class CheckRisunRegistServiceImpl
implements CheckRisunRegistService {
    private static final Logger log = LoggerFactory.getLogger(CheckRisunRegistServiceImpl.class);
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;

    public CheckRisunRegistRspBO checkRegist(CheckRisunRegistReqBO reqBO) {
        log.info("\u62a5\u540d\u6821\u9a8c\u5165\u53c2" + reqBO);
        CheckRisunRegistRspBO rspBO = new CheckRisunRegistRspBO();
        if (reqBO.getInquiryId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6267\u884c\u5355ID\u4e0d\u53ef\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCategoryIdList())) {
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u51c6\u5165\u54c1\u7c7b\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        try {
            List<DIqrInquiryDetailPO> dIqrInquiryDetailList = this.dIqrInquiryDetailMapper.selectByInquiryId(reqBO.getInquiryId());
            if (CollectionUtils.isNotEmpty(dIqrInquiryDetailList)) {
                DIqrRegistDocPO dIqrRegistDocPO;
                if (StringUtils.isNotEmpty((CharSequence)dIqrInquiryDetailList.get(0).getMaterialClassId())) {
                    String materialClassId = dIqrInquiryDetailList.get(0).getMaterialClassId().substring(0, 1);
                    if (StringUtils.isNotBlank((CharSequence)materialClassId) && reqBO.getCategoryIdList().contains(materialClassId)) {
                        rspBO.setAccess(Boolean.TRUE.booleanValue());
                    } else {
                        rspBO.setAccess(Boolean.FALSE.booleanValue());
                        rspBO.setMsgDesc("\u60a8\u6ca1\u6709\u8be5\u7ade\u4ef7\u9879\u76ee\u7684\u5408\u4f5c\u54c1\u7c7b\u8d44\u8d28\u4e0d\u53ef\u62a5\u540d");
                    }
                }
                if ((dIqrRegistDocPO = this.dIqrRegistDocMapper.selectRegistDocByInquiryIdSupId(reqBO.getInquiryId(), reqBO.getSupplierId())) != null && ("3002".equals(dIqrRegistDocPO.getDocStatus() + "") || "3005".equals(dIqrRegistDocPO.getDocStatus() + ""))) {
                    rspBO.setAccess(Boolean.FALSE.booleanValue());
                    rspBO.setMsgDesc("\u60a8\u5df2\u53c2\u4e0e\u62a5\u540d\uff01");
                }
            } else {
                rspBO.setAccess(Boolean.FALSE.booleanValue());
                rspBO.setMsgDesc("\u7ade\u4ef7\u9879\u76ee\u7f3a\u5c11\u7269\u6599\u660e\u7ec6\u4fe1\u606f");
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u5f02\u5e38!", (Throwable)e);
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u54c1\u7c7b\u4fe1\u606f\u6821\u9a8c\u5f02\u5e38!");
        }
        return rspBO;
    }
}

