/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.registdoc;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.performlist.bo.ExecOrderStatusReqBO;
import com.tydic.enquiry.api.performlist.bo.ExecOrderStatusRspBO;
import com.tydic.enquiry.api.performlist.service.UpExecOrderStatusService;
import com.tydic.enquiry.api.quote.bo.GenerateQuotationBillReqBO;
import com.tydic.enquiry.api.quote.bo.GenerateQuotationBillRspBO;
import com.tydic.enquiry.api.quote.bo.UpdateQuotationStatusReqBO;
import com.tydic.enquiry.api.quote.bo.UpdateQuotationStatusRspBO;
import com.tydic.enquiry.api.quote.service.GenerateQuotationBillService;
import com.tydic.enquiry.api.quote.service.UpdateQuotationStatusService;
import com.tydic.enquiry.api.registdoc.bo.RegistRisunAutoOverReqBO;
import com.tydic.enquiry.api.registdoc.bo.RegistRisunAutoOverRspBO;
import com.tydic.enquiry.api.registdoc.service.RegistRisunAutoOverService;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST", serviceInterface=RegistRisunAutoOverService.class)
public class RegistRisunAutoOverServiceImpl
implements RegistRisunAutoOverService {
    private static final Logger log = LoggerFactory.getLogger(RegistRisunAutoOverServiceImpl.class);
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrRegistDocMapper dIqrRegistDocMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST")
    UpExecOrderStatusService UpExecOrderStatusService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST")
    UpdateQuotationStatusService updateQuotationStatusService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP_TEST")
    GenerateQuotationBillService generateQuotationBillService;

    @Transactional(rollbackFor={Exception.class})
    public RegistRisunAutoOverRspBO registRisunAutoOver(RegistRisunAutoOverReqBO registAutoOverReqBO) {
        RegistRisunAutoOverRspBO rspBO = new RegistRisunAutoOverRspBO();
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(registAutoOverReqBO.getInquiryId());
        if (dIqrInquiryMatePO != null) {
            boolean upInquiryFlag = false;
            List<DIqrRegistDocPO> dIqrRegistDocPOS = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(dIqrInquiryMatePO.getInquiryId());
            if (CollectionUtils.isNotEmpty(dIqrRegistDocPOS)) {
                Date currentDate = new Date();
                List<Integer> statusList = Arrays.asList(Integer.valueOf("3002"), Integer.valueOf("3005"));
                List<DIqrRegistDocPO> dIqrRegistDocList = this.dIqrRegistDocMapper.queryByRegistTimeAndStatus(dIqrInquiryMatePO.getInquiryId(), statusList, currentDate);
                if (CollectionUtils.isNotEmpty(dIqrRegistDocList)) {
                    ExecOrderStatusReqBO execOrderStatusReqBO = new ExecOrderStatusReqBO();
                    execOrderStatusReqBO.setUpFlag("1");
                    execOrderStatusReqBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                    execOrderStatusReqBO.setDocStatus(Integer.valueOf(Integer.parseInt("2006")));
                    execOrderStatusReqBO.setNodeStatus("2104");
                    ExecOrderStatusRspBO execOrderStatusRspBO = this.UpExecOrderStatusService.updateExecOrderStatus(execOrderStatusReqBO);
                    if (!execOrderStatusRspBO.getRespCode().equals("0000")) {
                        log.error("\u8c03\u7528\u6267\u884c\u5355\u72b6\u6001\u53d8\u66f4\u4e2d\u5fc3\u5c42\u670d\u52a1\u5931\u8d25::execOrderStatusRspBO.getRespDesc()=" + execOrderStatusRspBO.getRespDesc());
                        throw new EnqBusinessException("9999", execOrderStatusRspBO.getRespDesc());
                    }
                    GenerateQuotationBillReqBO generateQuotationBillReqBO = new GenerateQuotationBillReqBO();
                    generateQuotationBillReqBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                    GenerateQuotationBillRspBO generateQuotationBillRspBO = this.generateQuotationBillService.addQuotationBill(generateQuotationBillReqBO);
                    if (!"0000".equals(generateQuotationBillRspBO.getRespCode())) {
                        log.error("\u8c03\u7528\u751f\u6210\u62a5\u4ef7\u5355\u4e2d\u5fc3\u5c42\u670d\u5931\u8d25::generateQuotationBillRspBO.getRespDesc()=" + generateQuotationBillRspBO.getRespDesc());
                        throw new EnqBusinessException("9999", generateQuotationBillRspBO.getRespDesc());
                    }
                    try {
                        UpdateQuotationStatusReqBO updateQuotationStatusReqBO = new UpdateQuotationStatusReqBO();
                        updateQuotationStatusReqBO.setUpdateType(Integer.valueOf(1));
                        updateQuotationStatusReqBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                        UpdateQuotationStatusRspBO updateQuotationStatusRspBO = this.updateQuotationStatusService.updateQuotationStatus(updateQuotationStatusReqBO);
                        log.info("\u62a5\u4ef7\u5355\u72b6\u6001\u53d8\u66f4\u51fa\u53c2" + updateQuotationStatusRspBO);
                        if (!"0000".equals(updateQuotationStatusRspBO.getRespCode())) {
                            log.error("\u8c03\u7528\u62a5\u4ef7\u5355\u72b6\u6001\u53d8\u66f4\u4e2d\u5fc3\u5c42\u670d\u5931\u8d25::updateQuotationStatusRspBO.getRespDesc()=" + updateQuotationStatusRspBO.getRespDesc());
                            throw new EnqBusinessException("9999", updateQuotationStatusRspBO.getRespDesc());
                        }
                    }
                    catch (Exception e) {
                        log.error("\u62a5\u4ef7\u5355\u72b6\u6001\u53d8\u66f4\u5f02\u5e38::e=" + e.toString());
                        throw new EnqBusinessException("9999", "\u62a5\u4ef7\u5355\u72b6\u6001\u53d8\u66f4\u5f02\u5e38");
                    }
                    for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocList) {
                        if (!"2".equals(dIqrRegistDocPO.getPayStatus()) || !currentDate.after(dIqrRegistDocPO.getLimitQuoteDate()) || !currentDate.before(dIqrRegistDocPO.getQuoteEndDate())) continue;
                        dIqrRegistDocPO.setDocStatus(Integer.valueOf("3006"));
                        this.dIqrRegistDocMapper.updateByPrimaryKeySelective(dIqrRegistDocPO);
                    }
                } else {
                    upInquiryFlag = true;
                }
            }
            if (upInquiryFlag) {
                ExecOrderStatusReqBO execOrderStatusReqBO = new ExecOrderStatusReqBO();
                execOrderStatusReqBO.setUpFlag("1");
                execOrderStatusReqBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                execOrderStatusReqBO.setDocStatus(Integer.valueOf(Integer.parseInt("2011")));
                execOrderStatusReqBO.setNodeStatus("2103");
                ExecOrderStatusRspBO execOrderStatusRspBO = this.UpExecOrderStatusService.updateExecOrderStatus(execOrderStatusReqBO);
                if (!execOrderStatusRspBO.getRespCode().equals("0000")) {
                    log.error("\u8c03\u7528\u6267\u884c\u5355\u72b6\u6001\u53d8\u66f4\u4e2d\u5fc3\u5c42\u670d\u52a1\u5931\u8d25::execOrderStatusRspBO.getRespDesc()=" + execOrderStatusRspBO.getRespDesc());
                    throw new EnqBusinessException("9999", execOrderStatusRspBO.getRespDesc());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public RegistRisunAutoOverRspBO qryRegistAutoOverInfo(RegistRisunAutoOverReqBO registAutoOverReqBO) {
        RegistRisunAutoOverRspBO rspBO = new RegistRisunAutoOverRspBO();
        List<DIqrInquiryMatePO> iqrInquiryMatePOS = this.dIqrInquiryMateMapper.queryInquiryMateQuoteDateList(Integer.parseInt("2005"), new Date());
        ArrayList<Long> inquiryIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(iqrInquiryMatePOS)) {
            for (DIqrInquiryMatePO dIqrInquiryMatePO : iqrInquiryMatePOS) {
                inquiryIds.add(dIqrInquiryMatePO.getInquiryId());
            }
        }
        rspBO.setInquiryIds(inquiryIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("qryRegistAutoOverInfo::rspBO=" + rspBO.toString());
        return rspBO;
    }

    public RegistRisunAutoOverRspBO registRisunAutoOverOverTime(RegistRisunAutoOverReqBO registAutoOverReqBO) {
        RegistRisunAutoOverRspBO rspBO = new RegistRisunAutoOverRspBO();
        List<DIqrRegistDocPO> dIqrRegistDocPOS = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(registAutoOverReqBO.getInquiryId());
        if (CollectionUtils.isEmpty(dIqrRegistDocPOS) || CollectionUtils.isNotEmpty(dIqrRegistDocPOS) && dIqrRegistDocPOS.size() < 3) {
            ExecOrderStatusReqBO execOrderStatusReqBO = new ExecOrderStatusReqBO();
            execOrderStatusReqBO.setUpFlag("1");
            execOrderStatusReqBO.setInquiryId(registAutoOverReqBO.getInquiryId());
            execOrderStatusReqBO.setDocStatus(Integer.valueOf(Integer.parseInt("2011")));
            execOrderStatusReqBO.setNodeStatus("2103");
            ExecOrderStatusRspBO execOrderStatusRspBO = this.UpExecOrderStatusService.updateExecOrderStatus(execOrderStatusReqBO);
            if (!execOrderStatusRspBO.getRespCode().equals("0000")) {
                log.error("\u8c03\u7528\u6267\u884c\u5355\u72b6\u6001\u53d8\u66f4\u4e2d\u5fc3\u5c42\u670d\u52a1\u5931\u8d25::execOrderStatusRspBO.getRespDesc()=" + execOrderStatusRspBO.getRespDesc());
                throw new EnqBusinessException("9999", execOrderStatusRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public RegistRisunAutoOverRspBO qryRegistAutoOverInfoOverTime(RegistRisunAutoOverReqBO registAutoOverReqBO) {
        RegistRisunAutoOverRspBO rspBO = new RegistRisunAutoOverRspBO();
        List<DIqrInquiryMatePO> iqrInquiryMatePOS = this.dIqrInquiryMateMapper.queryInquiryMateQuoteDateListOverTime(Integer.parseInt("2005"), new Date());
        ArrayList<Long> inquiryIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(iqrInquiryMatePOS)) {
            for (DIqrInquiryMatePO dIqrInquiryMatePO : iqrInquiryMatePOS) {
                inquiryIds.add(dIqrInquiryMatePO.getInquiryId());
            }
        }
        rspBO.setInquiryIds(inquiryIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        log.info("qryRegistAutoOverInfo::rspBO=" + rspBO.toString());
        return rspBO;
    }
}

