/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.dealNotice;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.dealNotice.bo.PublishConfirmNoticeReqBO;
import com.tydic.enquiry.api.dealNotice.bo.PublishConfirmNoticeRspBO;
import com.tydic.enquiry.api.dealNotice.service.PublishConfirmNoticeService;
import com.tydic.enquiry.api.registdoc.bo.UpMarginPayStatusReqBO;
import com.tydic.enquiry.api.registdoc.service.UpMarginPayStatusService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrConfirmNoticeMapper;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.exception.EnqBusinessException;
import com.tydic.enquiry.po.DIqrConfirmNoticePO;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.HtmlUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=PublishConfirmNoticeService.class)
public class PublishConfirmNoticeServiceImpl
implements PublishConfirmNoticeService {
    private static final Logger log = LoggerFactory.getLogger(PublishConfirmNoticeServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    UpMarginPayStatusService upMarginPayStatusService;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    DIqrConfirmNoticeMapper dIqrConfirmNoticeMapper;
    @Autowired
    DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    SeqIdCreateService seqIdCreateService;
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;
    @Value(value="${msg.center.url}")
    private String msgUrl;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Transactional(rollbackFor={Exception.class})
    public PublishConfirmNoticeRspBO publishConfirmNotice(PublishConfirmNoticeReqBO reqBO) {
        log.info("PublishConfirmNoticeService\u5165\u53c2" + reqBO);
        PublishConfirmNoticeRspBO respBo = new PublishConfirmNoticeRspBO();
        if (null == reqBO.getInquiryId()) {
            respBo.setRespCode("9999");
            respBo.setRespDesc("\u7ade\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return respBo;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getNoticeTitle())) {
            respBo.setRespCode("9999");
            respBo.setRespDesc("\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
            return respBo;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getNoticeContent())) {
            respBo.setRespCode("9999");
            respBo.setRespDesc("\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
            return respBo;
        }
        try {
            DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(reqBO.getInquiryId());
            if (null == dIqrInquiryMatePO) {
                log.error("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u6267\u884c\u5355\u4fe1\u606f");
                respBo.setRespCode("9999");
                respBo.setRespDesc("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u6267\u884c\u5355\u4fe1\u606f");
                return respBo;
            }
            DIqrConfirmNoticePO dIqrConfirmNoticePO = this.dIqrConfirmNoticeMapper.selectByInquiryId(dIqrInquiryMatePO.getInquiryId());
            if (null != dIqrConfirmNoticePO) {
                respBo.setRespCode("9999");
                respBo.setRespDesc("\u6267\u884c\u5355\u5df2\u53d1\u5e03\uff0c\u65e0\u9700\u518d\u53d1\u5e03");
                return respBo;
            }
            DIqrConfirmNoticePO record = new DIqrConfirmNoticePO();
            BeanUtils.copyProperties((Object)dIqrInquiryMatePO, (Object)record);
            record.setNoticeTitle(reqBO.getNoticeTitle());
            record.setNoticeContent(HtmlUtils.htmlEscapeHex((String)reqBO.getNoticeContent()));
            record.setPublishTime(new Date());
            record.setCreateUserId(reqBO.getOperId());
            record.setCreateUserName(reqBO.getOperName());
            record.setPurchaseMethod(reqBO.getPurchaseMethod());
            SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
            seqEnquiryReqBO.setSystemId("RISUN01");
            seqEnquiryReqBO.setSeqType("99");
            record.setNoticeId(this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId());
            int i = this.dIqrConfirmNoticeMapper.insertSelective(record);
            if (i > 0) {
                DIqrQuotationPO quotationPO = new DIqrQuotationPO();
                ArrayList<Integer> docStatusList = new ArrayList<Integer>();
                docStatusList.add(Integer.valueOf("40014"));
                docStatusList.add(Integer.valueOf("40015"));
                quotationPO.setInquiryId(reqBO.getInquiryId());
                quotationPO.setHisStatus("1");
                quotationPO.setValidStatus(Constants.IS_VALID_Y);
                quotationPO.setDocStatusList(docStatusList);
                quotationPO.setReviewResult(Constants.REVIEW_RESULT_1);
                List<DIqrQuotationPO> iqrQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(quotationPO);
                if (!CollectionUtils.isNotEmpty(iqrQuotationPOs)) {
                    log.error("\u6b64\u6267\u884c\u5355\u672a\u627e\u5230\u6210\u4ea4\u7684\u62a5\u4ef7\u4fe1\u606f");
                    respBo.setRespCode("9999");
                    respBo.setRespDesc("\u6b64\u6267\u884c\u5355\u672a\u627e\u5230\u6210\u4ea4\u7684\u62a5\u4ef7\u4fe1\u606f\uff01");
                    return respBo;
                }
                List<DIqrRegistDocPO> dIqrRegistDocList = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(reqBO.getInquiryId());
                if (!CollectionUtils.isNotEmpty(dIqrRegistDocList)) {
                    log.error("\u6b64\u6267\u884c\u5355\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u62a5\u540d\u4fe1\u606f");
                    respBo.setRespCode("9999");
                    respBo.setRespDesc("\u6b64\u6267\u884c\u5355\u672a\u83b7\u53d6\u5230\u4f9b\u5e94\u5546\u62a5\u540d\u4fe1\u606f\uff01");
                    return respBo;
                }
                ArrayList<String> phoneNumberList = new ArrayList<String>(dIqrRegistDocList.size());
                String phoneNumbers = null;
                for (DIqrRegistDocPO dIqrRegistDocPO : dIqrRegistDocList) {
                    if (!"2".equals(dIqrRegistDocPO.getPayStatus())) continue;
                    UpMarginPayStatusReqBO upMarginPayStatusReqBO = new UpMarginPayStatusReqBO();
                    upMarginPayStatusReqBO.setRegistId(dIqrRegistDocPO.getRegistId());
                    upMarginPayStatusReqBO.setSupplierId(dIqrRegistDocPO.getSupplierId());
                    upMarginPayStatusReqBO.setPayFlag("3");
                    this.upMarginPayStatusService.upMarginPayStatus(upMarginPayStatusReqBO);
                    phoneNumberList.add(dIqrRegistDocPO.getPhoneNumber());
                }
                if (CollectionUtils.isNotEmpty(phoneNumberList)) {
                    phoneNumbers = StringUtils.join(phoneNumberList, (String)",");
                }
                DIqrInquiryMatePO dIqrInquiryMateUpdate = new DIqrInquiryMatePO();
                dIqrInquiryMateUpdate.setDocStatus(Integer.valueOf("2009"));
                dIqrInquiryMateUpdate.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                this.dIqrInquiryMateMapper.updateByPrimaryKeySelective(dIqrInquiryMateUpdate);
                DIqrInquiryBidsectionPO dIqrInquiryBidsectionPO = new DIqrInquiryBidsectionPO();
                dIqrInquiryBidsectionPO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
                dIqrInquiryBidsectionPO.setDocStatus(Integer.valueOf("2009"));
                this.dIqrInquiryBidsectionMapper.updateBidsectionStatusByInquiryId(dIqrInquiryBidsectionPO);
                if (StringUtils.isNotBlank((CharSequence)phoneNumbers)) {
                    String finalPhoneNumbers = phoneNumbers;
                    new Thread(() -> this.sendMsg(finalPhoneNumbers, dIqrInquiryMatePO.getInquiryName(), this.msgUrl)).start();
                }
            }
            respBo.setRespCode("0000");
            respBo.setRespDesc("\u6210\u529f");
            log.info("PublishConfirmNoticeService\u51fa\u53c2" + respBo);
            return respBo;
        }
        catch (Exception e) {
            log.error("\u53d1\u5e03\u6210\u4ea4\u7ed3\u679c\u516c\u544a\u5f02\u5e38", (Throwable)e);
            throw new EnqBusinessException("9999", "\u53d1\u5e03\u6210\u4ea4\u7ed3\u679c\u516c\u544a\u5f02\u5e38!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsg(String phoneNumbers, String inquiryName, String msgUrl) {
        log.info("\u77ed\u4fe1\u5730\u5740:" + msgUrl + "\u53f7\u7801\u5217\u8868:" + phoneNumbers);
        if (StringUtils.isNotBlank((CharSequence)msgUrl)) {
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            CloseableHttpResponse response = null;
            try {
                String templateParam = "{\\\"bidName\\\":\\\"" + inquiryName + "\\\"}";
                String params = "{\"templateCode\":\"SMS_207496343\",\"phoneNumbers\":\"" + phoneNumbers + "\",\"templateParam\":\"" + templateParam + "\"}";
                HttpPost httpPost = new HttpPost(msgUrl);
                StringEntity stringEntity = new StringEntity(params, "UTF-8");
                stringEntity.setContentType("text/plain");
                stringEntity.setContentEncoding((Header)new BasicHeader("Content-Type", "text/plain"));
                httpPost.setEntity((HttpEntity)stringEntity);
                httpPost.setHeader("Content-Type", "text/plain");
                response = httpClient.execute((HttpUriRequest)httpPost);
                HttpEntity responseEntity = response.getEntity();
                String xmlContent = EntityUtils.toString((HttpEntity)responseEntity);
                log.info("-------\u8fd4\u56de\u539f\u503c:" + xmlContent);
            }
            catch (Exception e) {
                log.error("\u77ed\u4fe1\u53d1\u9001\u5f02\u5e38:", (Throwable)e);
            }
            finally {
                try {
                    if (httpClient != null) {
                        httpClient.close();
                    }
                    if (response != null) {
                        response.close();
                    }
                }
                catch (Exception e) {
                    log.error("httpClien\u91ca\u653e\u8d44\u6e90\u5f02\u5e38:", (Throwable)e);
                }
            }
        }
    }
}

