/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.performlist;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.enquiry.api.performlist.bo.PublishRisunExecOrderReqBO;
import com.tydic.enquiry.api.performlist.bo.PublishRisunExecOrderRspBO;
import com.tydic.enquiry.api.performlist.service.PublishRisunExecOrderService;
import com.tydic.enquiry.api.sequence.bo.SeqEnquiryReqBO;
import com.tydic.enquiry.api.sequence.service.SeqIdCreateService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.CAllOperLogMapper;
import com.tydic.enquiry.dao.DIqrInquiryBidsectionMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrPurchaseNoticeMapper;
import com.tydic.enquiry.dao.DIqrRegistDocMapper;
import com.tydic.enquiry.po.CAllOperLogPO;
import com.tydic.enquiry.po.DIqrInquiryBidsectionPO;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrPurchaseNoticePO;
import com.tydic.enquiry.po.DIqrRegistDocPO;
import com.tydic.enquiry.util.SendMsgUtil;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.util.HtmlUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=PublishRisunExecOrderService.class)
public class PublishRisunExecOrderServiceImpl
implements PublishRisunExecOrderService {
    private static final Logger log = LoggerFactory.getLogger(PublishRisunExecOrderServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP")
    SeqIdCreateService seqIdCreateService;
    @Autowired
    private DIqrPurchaseNoticeMapper dIqrPurchaseNoticeMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    DIqrRegistDocMapper dIqrRegistDocMapper;
    @Autowired
    private CAllOperLogMapper cAllOperLogMapper;
    @Autowired
    private DIqrInquiryBidsectionMapper dIqrInquiryBidsectionMapper;
    @Value(value="${msg.center.url}")
    private String msgUrl;

    public PublishRisunExecOrderRspBO publishRisunExecOrder(PublishRisunExecOrderReqBO reqBO) {
        log.info("\u5165\u53c2\u6570\u636e\u4fe1\u606f\uff1aPublishRisunExecOrderReqBO=" + reqBO.toString());
        PublishRisunExecOrderRspBO publishRisunExecOrderRspBO = new PublishRisunExecOrderRspBO();
        if (null == reqBO.getInquiryId()) {
            publishRisunExecOrderRspBO.setRespCode("9999");
            publishRisunExecOrderRspBO.setRespDesc("\u7ade\u4ef7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a!");
            return publishRisunExecOrderRspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getNoticeTitle())) {
            publishRisunExecOrderRspBO.setRespCode("9999");
            publishRisunExecOrderRspBO.setRespDesc("\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a!");
            return publishRisunExecOrderRspBO;
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getNoticeContent())) {
            publishRisunExecOrderRspBO.setRespCode("9999");
            publishRisunExecOrderRspBO.setRespDesc("\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!");
            return publishRisunExecOrderRspBO;
        }
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectValidByInquiryId(reqBO.getInquiryId());
        if (dIqrInquiryMatePO != null) {
            List<DIqrRegistDocPO> dIqrRegistDocList;
            List<DIqrPurchaseNoticePO> noticeList = this.dIqrPurchaseNoticeMapper.selectValidDataByInquiryId(dIqrInquiryMatePO.getInquiryId());
            if (CollectionUtils.isNotEmpty(noticeList)) {
                publishRisunExecOrderRspBO.setRespCode("9999");
                publishRisunExecOrderRspBO.setRespDesc("\u6267\u884c\u5355\u5df2\u53d1\u5e03\uff0c\u65e0\u9700\u518d\u53d1\u5e03");
                return publishRisunExecOrderRspBO;
            }
            DIqrPurchaseNoticePO dIqrPurchaseNoticePO = new DIqrPurchaseNoticePO();
            String phoneNumbers = null;
            if (Constants.PURCHASE_METHOD_INVITE.equals(dIqrInquiryMatePO.getPurchaseMethod()) && CollectionUtils.isNotEmpty(dIqrRegistDocList = this.dIqrRegistDocMapper.selectRegistDocByInquiryId(reqBO.getInquiryId()))) {
                List supplierIdList = dIqrRegistDocList.stream().map(DIqrRegistDocPO::getSupplierId).collect(Collectors.toList());
                dIqrPurchaseNoticePO.setSupplierIds(StringUtils.join(supplierIdList, (String)","));
                List phoneNumberList = dIqrRegistDocList.stream().map(DIqrRegistDocPO::getPhoneNumber).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(phoneNumberList)) {
                    phoneNumbers = StringUtils.join(phoneNumberList, (String)",");
                }
            }
            dIqrPurchaseNoticePO.setInquiryCode(dIqrInquiryMatePO.getInquiryCode());
            dIqrPurchaseNoticePO.setInquiryName(dIqrInquiryMatePO.getInquiryName());
            dIqrPurchaseNoticePO.setDeliveryDateMethod(dIqrInquiryMatePO.getDeliveryDateMethod());
            dIqrPurchaseNoticePO.setIqrSeq(dIqrInquiryMatePO.getIqrSeq());
            dIqrPurchaseNoticePO.setPlanClass(dIqrInquiryMatePO.getPlanClass());
            dIqrPurchaseNoticePO.setInventoryClass(dIqrInquiryMatePO.getInventoryClass());
            dIqrPurchaseNoticePO.setProfessionalOrgId(dIqrInquiryMatePO.getProfessionalOrgId());
            dIqrPurchaseNoticePO.setProfessionalOrgName(dIqrInquiryMatePO.getProfessionalOrgName());
            dIqrPurchaseNoticePO.setLimitQuoteDate(dIqrInquiryMatePO.getLimitQuoteDate());
            dIqrPurchaseNoticePO.setQuoteEndDate(dIqrInquiryMatePO.getQuoteEndDate());
            dIqrPurchaseNoticePO.setPurchaseCategory(dIqrInquiryMatePO.getPlanCategory());
            dIqrPurchaseNoticePO.setReqArrivalDate(dIqrInquiryMatePO.getReqArrivalDate());
            dIqrPurchaseNoticePO.setReqArrivalPeriod(dIqrInquiryMatePO.getReqArrivalPeriod());
            dIqrPurchaseNoticePO.setPurchaserId(dIqrInquiryMatePO.getPurchaserId());
            dIqrPurchaseNoticePO.setPurchaseId(Long.valueOf(dIqrInquiryMatePO.getPurchaseIdJson()));
            dIqrPurchaseNoticePO.setPurchaseName(dIqrInquiryMatePO.getPurchaseName());
            dIqrPurchaseNoticePO.setNoticeId(this.getDocId("RISUN01", "99"));
            dIqrPurchaseNoticePO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
            dIqrPurchaseNoticePO.setValidStatus(Constants.IS_VALID_Y);
            dIqrPurchaseNoticePO.setPublishTime(new Date());
            dIqrPurchaseNoticePO.setBusiType(dIqrInquiryMatePO.getBusiType());
            dIqrPurchaseNoticePO.setDocType(dIqrInquiryMatePO.getDocType());
            dIqrPurchaseNoticePO.setNoticeTitle(reqBO.getNoticeTitle());
            dIqrPurchaseNoticePO.setNoticeContent(HtmlUtils.htmlEscapeHex((String)reqBO.getNoticeContent()));
            dIqrPurchaseNoticePO.setPurchaseMethod(reqBO.getPurchaseMethod());
            this.dIqrPurchaseNoticeMapper.insertSelective(dIqrPurchaseNoticePO);
            DIqrInquiryMatePO dIqrInquiryMateUpdate = new DIqrInquiryMatePO();
            dIqrInquiryMateUpdate.setInquiryId(dIqrInquiryMatePO.getInquiryId());
            dIqrInquiryMateUpdate.setDocStatus(Integer.valueOf("2005"));
            dIqrInquiryMateUpdate.setPublishTime(new Date());
            this.dIqrInquiryMateMapper.updateByInquiryId(dIqrInquiryMateUpdate);
            DIqrInquiryBidsectionPO dIqrInquiryBidsectionPO = new DIqrInquiryBidsectionPO();
            dIqrInquiryBidsectionPO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
            dIqrInquiryBidsectionPO.setDocStatus(Integer.valueOf("2005"));
            dIqrInquiryBidsectionPO.setModifyUserId(reqBO.getOperId());
            dIqrInquiryBidsectionPO.setModifyUserName(reqBO.getOperName());
            dIqrInquiryBidsectionPO.setModifyTime(new Date());
            this.dIqrInquiryBidsectionMapper.updateBidsectionStatusByInquiryId(dIqrInquiryBidsectionPO);
            this.insertOperLog(dIqrInquiryMatePO.getInquiryId(), "\u7ade\u4ef7\u5355\u53d1\u5e03", "\u7ade\u4ef7\u5355\u751f\u6210", reqBO.getOperId(), reqBO.getOperName(), "\u6210\u529f");
            if (StringUtils.isNotBlank((CharSequence)phoneNumbers)) {
                String finalPhoneNumbers = phoneNumbers;
                new Thread(() -> SendMsgUtil.sendMsg(finalPhoneNumbers, reqBO.getNoticeTitle(), dIqrInquiryMatePO.getPurchaseName(), this.msgUrl, null, null)).start();
            }
            publishRisunExecOrderRspBO.setRespCode("0000");
            publishRisunExecOrderRspBO.setRespDesc("\u6210\u529f");
            publishRisunExecOrderRspBO.setInquiryId(dIqrInquiryMatePO.getInquiryId());
            publishRisunExecOrderRspBO.setNoticeId(dIqrPurchaseNoticePO.getNoticeId());
        } else {
            publishRisunExecOrderRspBO.setRespCode("9999");
            publishRisunExecOrderRspBO.setRespDesc("\u672a\u83b7\u53d6\u5230\u6709\u6548\u7684\u6267\u884c\u5355\u4fe1\u606f");
        }
        log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1aPublishRisunExecOrderRspBO=" + publishRisunExecOrderRspBO.toString());
        return publishRisunExecOrderRspBO;
    }

    private void insertOperLog(Long docId, String operLink, String behavior, Long operUserId, String operUserName, String remark) {
        CAllOperLogPO cAllOperLogPO = new CAllOperLogPO();
        cAllOperLogPO.setHisId(this.getDocId("RISUN01", "99"));
        cAllOperLogPO.setDocId(docId);
        cAllOperLogPO.setOperLink(operLink);
        cAllOperLogPO.setOperBehavior(behavior);
        cAllOperLogPO.setOperId(operUserId);
        cAllOperLogPO.setOperName(operUserName);
        cAllOperLogPO.setRemark(remark);
        cAllOperLogPO.setOperTime(new Date());
        this.cAllOperLogMapper.insertSelective(cAllOperLogPO);
    }

    private Long getDocId(String systemId, String type) {
        SeqEnquiryReqBO seqEnquiryReqBO = new SeqEnquiryReqBO();
        seqEnquiryReqBO.setSystemId(systemId);
        seqEnquiryReqBO.setSeqType(type);
        return this.seqIdCreateService.getSeqId(seqEnquiryReqBO).getDocId();
    }
}

