/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.enquiry.service.busi.impl.quote;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.enquiry.api.dictionary.service.QryDicAtomService;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillHistoryListReqBO;
import com.tydic.enquiry.api.quote.bo.QryQuotationBillHistoryListRspBO;
import com.tydic.enquiry.api.quote.bo.QuotationBillBO;
import com.tydic.enquiry.api.quote.bo.QuoteExecOrderDetailBO;
import com.tydic.enquiry.api.quote.service.QryQuotationBillHistoryListService;
import com.tydic.enquiry.constant.Constants;
import com.tydic.enquiry.dao.DIqrInquiryDetailMapper;
import com.tydic.enquiry.dao.DIqrInquiryMateMapper;
import com.tydic.enquiry.dao.DIqrQuotationItemMapper;
import com.tydic.enquiry.dao.DIqrQuotationMapper;
import com.tydic.enquiry.dao.DIqrQuotationPkgMapper;
import com.tydic.enquiry.po.DIqrInquiryMatePO;
import com.tydic.enquiry.po.DIqrQuotationPO;
import com.tydic.enquiry.util.QuoteUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="ENQUIRY_GROUP", serviceInterface=QryQuotationBillHistoryListService.class)
public class QryQuotationBillHistoryListServiceImpl
implements QryQuotationBillHistoryListService {
    private static final Logger log = LoggerFactory.getLogger(QryQuotationBillHistoryListServiceImpl.class);
    @Autowired
    private DIqrQuotationMapper dIqrQuotationMapper;
    @Autowired
    private DIqrQuotationItemMapper dIqrQuotationItemMapper;
    @Autowired
    private DIqrInquiryMateMapper dIqrInquiryMateMapper;
    @Autowired
    private DIqrQuotationPkgMapper dIqrQuotationPkgMapper;
    @Autowired
    private DIqrInquiryDetailMapper dIqrInquiryDetailMapper;
    @Autowired
    private QryDicAtomService qryDicAtomService;

    public QryQuotationBillHistoryListRspBO qryQuotationBillHistoryList(QryQuotationBillHistoryListReqBO qryQuotationBillHistoryListReqBO) {
        QryQuotationBillHistoryListRspBO rspBO = new QryQuotationBillHistoryListRspBO();
        DIqrQuotationPO dIqrQuotationPO = this.dIqrQuotationMapper.selectByPrimaryKey(qryQuotationBillHistoryListReqBO.getQuotationId());
        if (dIqrQuotationPO == null || dIqrQuotationPO.getInquiryId() == null) {
            log.error("\u6b64\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u62a5\u4ef7\u5355\u4e0d\u5b58\u5728");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        DIqrInquiryMatePO dIqrInquiryMatePO = this.dIqrInquiryMateMapper.selectByInquiryId(dIqrQuotationPO.getInquiryId());
        if (dIqrInquiryMatePO == null) {
            log.error("\u6b64\u62a5\u4ef7\u5355\u5bf9\u5e94\u7684\u6267\u884c\u5355\u4e0d\u5b58\u5728");
            rspBO.setRespCode("9999");
            rspBO.setRespDesc("\u6b64\u62a5\u4ef7\u5355\u5bf9\u5e94\u7684\u6267\u884c\u5355\u4e0d\u5b58\u5728");
            log.info("\u51fa\u53c2\u6570\u636e\u4fe1\u606f\uff1arspBO=" + rspBO.toString());
            return rspBO;
        }
        QuoteExecOrderDetailBO execOrderDetailBO = new QuoteExecOrderDetailBO();
        BeanUtils.copyProperties((Object)dIqrInquiryMatePO, (Object)execOrderDetailBO);
        execOrderDetailBO.setCreateDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (dIqrInquiryMatePO.getRegistBeginDate() != null) {
            execOrderDetailBO.setRegistBeginDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getRegistBeginDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (dIqrInquiryMatePO.getRegistEndDate() != null) {
            execOrderDetailBO.setRegistEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getRegistEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (dIqrInquiryMatePO.getLimitQuoteDate() != null) {
            execOrderDetailBO.setLimitQuoteDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getLimitQuoteDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (dIqrInquiryMatePO.getQuoteEndDate() != null) {
            execOrderDetailBO.setQuoteEndDate(DateUtils.dateToStr((Date)dIqrInquiryMatePO.getQuoteEndDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        }
        execOrderDetailBO.setTotalPriceFlagName(this.qryDicAtomService.getDicCodeName("TOTAL_PRICE_FLAG", execOrderDetailBO.getTotalPriceFlag() + ""));
        execOrderDetailBO.setOfferIncreaseTypeName(this.qryDicAtomService.getDicCodeName("OFFER_INCREASE_TYPE", execOrderDetailBO.getOfferIncreaseType() + ""));
        execOrderDetailBO.setComparedQuoteTypeName(this.qryDicAtomService.getDicCodeName("COMPARED_QUOTE_TYPE", execOrderDetailBO.getComparedQuoteType() + ""));
        execOrderDetailBO.setDelayBiddingFlagName(this.qryDicAtomService.getDicCodeName("DELAY_BIDDING_FLAG", execOrderDetailBO.getDelayBiddingFlag() + ""));
        execOrderDetailBO.setIsBudgetAnnounceName(this.qryDicAtomService.getDicCodeName("IS_BUDGET_ANNOUNCE", execOrderDetailBO.getIsBudgetAnnounce() + ""));
        execOrderDetailBO.setPurchaseMethodName(this.qryDicAtomService.getDicCodeName("PURCHASE_METHOD", execOrderDetailBO.getPurchaseMethod() + ""));
        execOrderDetailBO.setQuoteMethodName(this.qryDicAtomService.getDicCodeName("QUOTE_METHOD", execOrderDetailBO.getQuoteMethod() + ""));
        execOrderDetailBO.setCurrencyTypeName(this.qryDicAtomService.getDicCodeName("CURRENCY_TYPE", execOrderDetailBO.getCurrencyType() + ""));
        rspBO.setExecOrderInfo(execOrderDetailBO);
        DIqrQuotationPO record = new DIqrQuotationPO();
        record.setInquiryId(dIqrQuotationPO.getInquiryId());
        record.setValidStatus(Constants.IS_VALID_Y);
        record.setHisStatus("1");
        List<DIqrQuotationPO> dIqrQuotationPOs = this.dIqrQuotationMapper.selectQuotationByPrimary(record);
        List<Object> quotationBillBOList = new ArrayList();
        if (CollectionUtils.isNotEmpty(dIqrQuotationPOs)) {
            quotationBillBOList = dIqrQuotationPOs.stream().map(e -> {
                QuotationBillBO quotationBillBO = new QuotationBillBO();
                BeanUtils.copyProperties((Object)e, (Object)quotationBillBO);
                try {
                    Long amount = e.getAmount();
                    if (StringUtils.isNotEmpty((CharSequence)e.getAmountSec())) {
                        amount = QuoteUtil.decode(e.getAmountSec(), e.getQuotationId().toString());
                    }
                    quotationBillBO.setAmount(MoneyUtils.Long2BigDecimal((Long)amount));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                quotationBillBO.setBusiTypeName(this.qryDicAtomService.getDicCodeName("BUSI_TYPE", e.getBusiType() + ""));
                quotationBillBO.setDocTypeName(this.qryDicAtomService.getDicCodeName("DOC_TYPE", e.getDocType() + ""));
                return quotationBillBO;
            }).collect(Collectors.toList());
        }
        rspBO.setQuotationBillInfoList(quotationBillBOList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

